/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.propertybar.imp;


import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.os.Handler;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.LongSparseArray;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.ToolHandler;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.annots.AnnotHandler;
import com.foxit.uiextensions.annots.fileattachment.FileAttachmentConstants;
import com.foxit.uiextensions.annots.fileattachment.FileAttachmentUtil;
import com.foxit.uiextensions.annots.ink.InkConstants;
import com.foxit.uiextensions.annots.line.DistanceMeasurement;
import com.foxit.uiextensions.annots.line.LineUtil;
import com.foxit.uiextensions.annots.note.NoteConstants;
import com.foxit.uiextensions.annots.note.NoteUtil;
import com.foxit.uiextensions.controls.dialog.UIPopoverFrag;
import com.foxit.uiextensions.controls.dialog.UIPopoverWin;
import com.foxit.uiextensions.controls.dialog.UIPopupFragment;
import com.foxit.uiextensions.controls.dialog.UITextEditDialogV;
import com.foxit.uiextensions.controls.dialog.sheetmenu.IActionMenu;
import com.foxit.uiextensions.controls.dialog.sheetmenu.UIActionMenu;
import com.foxit.uiextensions.controls.propertybar.PropertyBar;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.controls.toolbar.IBaseItem;
import com.foxit.uiextensions.controls.toolbar.ToolConstants;
import com.foxit.uiextensions.controls.toolbar.ToolItemBean;
import com.foxit.uiextensions.controls.toolbar.impl.BaseItemImpl;
import com.foxit.uiextensions.controls.toolbar.impl.TopBarImpl;
import com.foxit.uiextensions.controls.toolbar.impl.UIColorItem;
import com.foxit.uiextensions.pdfreader.MainCenterItemBean;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppDevice;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppDmUtil;
import com.foxit.uiextensions.utils.AppKeyboardUtil;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.AppUtil;
import com.foxit.uiextensions.utils.SystemUiHelper;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import androidx.annotation.NonNull;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class PropertyBarImpl implements PropertyBar {
    private static final String FULL_SCREEN_TAG = "FULL_SCREEN_TAG";
    private static final int MIN_FONT_SIZE = 6;
    private static final int MAX_FONT_SIZE = 144;
    private static final int PHONE_LANDSCAPE_WIDTH = 375;
    // highlight,1,typewriter,2,squareness,3,text,4,
    // strikeout,5,squiggly,6,underline,7,textinsert,8,strikeoutinsert,9,
    // line,10,circle,11,arrow,12,pencil,13,eraser,,
    // callout,14,sign,15,stamp,,
    private Context mContext;
    private UIPopupFragment mFullScreenFragment;
    private IActionMenu mActionMenu;

    private RelativeLayout mRootView;
    private RelativeLayout mPbBarView;
    private LinearLayout mTopTabRootLl;
    private LinearLayout mTopTabItemsLl;
    private LinearLayout mTopTabSelectLl;
    LinearLayout mTabContentLl;
    private LinearLayout mTopTitleLl;
    private LinearLayout mTopSubTitleLl;
    private TextView mTopSubTitle;
    private IBaseItem mTitleItem;
    private TopBarImpl mTitleBar;
    private boolean mArrowVisible = false;
    private boolean mShowOnKeyboard;
    private boolean mIsRegisterKeyboardListener = false;

    private List<String> mTabs;
    long mSupportProperty = 0;
    private long mCustomProperty = 0;
    private int mCurrentTab = 0;
    private String[] mSupportTabNames;
    private List<Map<String, Object>> mCustomTabList;
    private List<Map<String, Object>> mCustomItemList;
    private LongSparseArray<String> mCustomItemTitles;

    private int mFontStyle;
    private int mSymbolType;
    private int mNumberType;
    private int mAlignmentType;
    private int mPencilType;
    private int[] mColors;
    private int[] mFillColors;
    private int[] mOpacitys = PB_OPACITYS;
    private int[] mRotations = PB_ROTAIIONS;
    private int mColor;
    private int mFillColor;
    private int mOpacity = mOpacitys[mOpacitys.length - 1];
    private int mRotation = mRotations[0];
    private String mFontname;
    private String mRadioName;
    private String mOverlayText;
    private float mFontsize = PB_FONTSIZE_DEFAULT;
    private float mLinewith = 6.0f;
    private int mMaxLineWidth = 12;
    private int mMinLineWidth = 0;
    private int[] mLinestyles = new int[]{1, 2, 3, 4, 5};
    private int mLinestyle = mLinestyles[0];

    private int mNoteIconType = NoteConstants.TA_ICON_COMMENT;
    private int mAttachmentIconType = FileAttachmentConstants.ICONTYPE_PUSHPIN;

    private int currentDistanceUnit = 0;
    private float scaleFromValue = 1.0f;
    private int currentDistanceDisplayTip = 0;
    private float scaleToValue = 1.0f;

    private String[] mFontNames;
    private String[] mFontNames_2;
    private float[] mFontSizes = PB_FONTSIZES;

    private EditText mScaleEdt;
    private int mScalePercent = 20;
    private int mScaleSwitch = 0;

    private int mEraserShape = 1;

    private IOnShowListener mOnShowListener;
    private DialogInterface.OnKeyListener mOnKeyListener;
    private PropertyChangeListener mPropertyChangeListener;
    private PropertyChangeListener mCustomChangeListener;
    private PropertyBar.DismissListener mDismissListener;
    private int mPadWidth;

    boolean mShowMask = false;
    ViewGroup mAnchor;
    RectF mRectF;
    int mArrowPosition = UIPopoverWin.ARROW_AUTO;

    private float offset = 0;
    private boolean mClearCustomProperty = true;
    private boolean isFullScreen = false;
    private boolean mSubTitleVisiable = true;
    private boolean mAutoResetSystemUiOnDismiss = true;
    private boolean mAutoResetSystemUiOnShow = true;

    private PDFViewCtrl mPdfViewCtrl;
    private UIExtensionsManager mUIExtensionsManager;

    private int mArrowColor;
    private boolean mDismissWithReset = true;
    private boolean canEdit = true;
    private long mShowShapeListType;
    private boolean mScrollEnabled;
    private boolean mShowShapelistView;
    private int mMaxHeight;// for pad
    private Object mTag;

    public PropertyBarImpl(Context context, PDFViewCtrl pdfViewCtrl) {
        this.mContext = context;
        this.mPdfViewCtrl = pdfViewCtrl;
        this.mUIExtensionsManager = (UIExtensionsManager) pdfViewCtrl.getUIExtensionsManager();
        initVariable();
        initView();
    }

    private void initVariable() {
        mPadWidth = AppDisplay.dp2px(320.0f);
        mCustomItemTitles = new LongSparseArray<>();

        int[] colors = new int[PropertyBar.PB_COLORS_TOOL_DEFAULT.length];
        int[] fillColors = new int[PropertyBar.PB_FILLCOLORS_TOOL_DEFAULT.length];
        System.arraycopy(PropertyBar.PB_COLORS_TOOL_DEFAULT, 0, colors, 0, colors.length);
        colors[0] = PropertyBar.PB_COLORS_TOOL_DEFAULT[0];
        mColors = colors;
        mFillColors = fillColors;
        mColor = mColors[0];
        mFillColor = mFillColors[0];
        mRectF = new RectF();
        mSupportTabNames = new String[]{AppResource.getString(mContext, R.string.pb_icon_tab),
                AppResource.getString(mContext, R.string.pb_fill_tab),
                AppResource.getString(mContext, R.string.pb_border_tab),
                AppResource.getString(mContext, R.string.fx_string_font),
                AppResource.getString(mContext, R.string.pb_watermark_tab),
                AppResource.getString(mContext, R.string.pb_overlay_text_tab)};
        mTabs = new ArrayList<>();
        mCustomTabList = new ArrayList<>();
        mCustomItemList = new ArrayList<>();

        mFontname = AppResource.getString(mContext, R.string.fx_font_courier);
        mFontNames = new String[]{AppResource.getString(mContext, R.string.fx_font_courier),
                AppResource.getString(mContext, R.string.fx_font_helvetica),
                AppResource.getString(mContext, R.string.fx_font_times)};
        mFontNames_2 = new String[]{"Courier", "Courier-Bold", "Courier-BoldOblique",
                "Courier-Oblique", "Helvetica", "Helvetica-Bold",
                "Helvetica-BoldOblique", "Helvetica-Oblique", "Times-Roman",
                "Times-Bold", "Times-Italic", "Times-BoldItalic",};
        mClearCustomProperty = true;
    }

    private ArrayList<String> fakeDate() {
        ArrayList<String> list = new ArrayList<>();
        for (DistanceMeasurement rest : DistanceMeasurement.values()) {
            list.add(rest.getName());
        }
        return list;
    }

    private void initView() {
        mRootView = new RelativeLayout(mContext);

        mPbBarView = (RelativeLayout) LayoutInflater.from(mContext).inflate(R.layout.pb_layout, null, false);
        mTopTabRootLl = mPbBarView.findViewById(R.id.pb_top_tap_ll);
        mTopTabItemsLl = mPbBarView.findViewById(R.id.pb_top_tab_icons);
        mTopTabSelectLl = mPbBarView.findViewById(R.id.pb_top_tab_select);
        mTabContentLl = mPbBarView.findViewById(R.id.pb_content_ll);
        mTopTitleLl = mPbBarView.findViewById(R.id.pb_top_title);
        mTopSubTitleLl = mPbBarView.findViewById(R.id.pb_top_subtitle);
        mTopSubTitleLl.setVisibility(View.GONE);
        mTopTitleLl.setVisibility(View.GONE);

        mTopSubTitle = new TextView(mContext);
        LinearLayout.LayoutParams subParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);
        subParams.leftMargin = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_16dp);
        subParams.height = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_pb_title_height);
        mTopSubTitle.setLayoutParams(subParams);
        mTopSubTitle.setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimension(mContext, R.dimen.ux_text_size_12sp));
        mTopSubTitle.setTextColor(AppResource.getColor(mContext, R.color.t2));
        mTopSubTitle.setGravity(Gravity.CENTER_VERTICAL);
        mTopSubTitle.setSingleLine(true);
        mTopSubTitle.setText(AppResource.getString(mContext, R.string.pb_tools_title));
        mTopSubTitle.setEllipsize(TextUtils.TruncateAt.END);
        mTopSubTitleLl.addView(mTopSubTitle);

        mRootView.addView(mPbBarView, new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT));
    }

    private void initTitleView() {
        mTitleBar = new TopBarImpl(mContext);
        mTitleBar.setStartMargin(AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_16dp));
        mTitleBar.setEndMargin(AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_16dp));
        mTitleBar.setShowSolidLine(false);
        mTitleBar.setMiddleButtonCenter(true);
        if (!AppDisplay.isPad()) {
            IBaseItem backItem = new BaseItemImpl(mContext);
            backItem.setText(AppResource.getString(mContext, R.string.fx_string_close));
            backItem.setTextColor(ThemeUtil.getPrimaryTextColor(mContext));
            backItem.setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_text_size_15sp));
            backItem.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    dismiss();
                }
            });
            mTitleBar.addView(backItem, BaseBar.TB_Position.Position_LT);
        }

        mTitleItem = new BaseItemImpl(mContext);
        mTitleItem.setDisplayStyle(IBaseItem.ItemType.Item_Text);
        mTitleItem.setText("");
        mTitleItem.setTextColor(AppResource.getColor(mContext, R.color.t4));
        mTitleItem.setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_text_size_16sp));
        mTitleItem.setTypeface(Typeface.defaultFromStyle(Typeface.BOLD));
        mTitleBar.addView(mTitleItem, BaseBar.TB_Position.Position_CENTER);
        mTopTitleLl.addView(mTitleBar.getContentView());
    }

    @Override
    public void setPhoneFullScreen(boolean fullScreen) {
        if (!AppDisplay.isPad()) {
            isFullScreen = fullScreen;
        }
    }

    private View getScaleView() {
        View scaleItem = LayoutInflater.from(mContext).inflate(R.layout.pb_scale, null, false);
        mScaleEdt = scaleItem.findViewById(R.id.pb_scale_percent);
        LinearLayout switchLayout = scaleItem.findViewById(R.id.pb_scale_switch_ll);
        ImageView switchImg = scaleItem.findViewById(R.id.pb_scale_switch);

        mScaleEdt.setText(String.valueOf(mScalePercent));
        mScaleEdt.setSelection(String.valueOf(mScalePercent).length());
        mScaleEdt.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (mScaleSwitch == 1) {
                    if (s.toString().length() == 0) {
                        return;
                    }
                    int percent = Integer.parseInt(s.toString());
                    if (percent < 1) {
                        mScaleEdt.setText(String.valueOf(mScalePercent));
                        mScaleEdt.selectAll();
                    } else if (percent > 100) {
                        mScaleEdt.setText(s.toString().substring(0, s.toString().length() - 1));
                        mScaleEdt.selectAll();
                    } else {
                        mScalePercent = percent;
                        onValueChanged(PROPERTY_SCALE_PERCENT, mScalePercent);
                    }
                }
            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        });

        if (mScaleSwitch == 1) {
            switchImg.setImageResource(R.drawable.setting_on);
            mScaleEdt.setEnabled(true);
        } else {
            switchImg.setImageResource(R.drawable.setting_off);
            mScaleEdt.setEnabled(false);
        }
        switchLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ImageView switchImage = (ImageView) ((LinearLayout) v).getChildAt(0);
                EditText scaleEdit = (EditText) ((LinearLayout) v.getParent()).getChildAt(0);

                if (mScaleSwitch == 1) {
                    mScaleSwitch = 0;
                    switchImage.setImageResource(R.drawable.setting_off);
                    scaleEdit.setEnabled(false);
                } else {
                    mScaleSwitch = 1;
                    switchImage.setImageResource(R.drawable.setting_on);
                    scaleEdit.setEnabled(true);
                }

                onValueChanged(PROPERTY_SCALE_SWITCH, mScaleSwitch);
            }
        });

        return scaleItem;
    }

    private void onValueChanged(long property, Object value) {
        if (mPropertyChangeListener != null) {
            if (value instanceof Integer) {
                mPropertyChangeListener.onValueChanged(property, (int) value);
            } else if (value instanceof Float) {
                mPropertyChangeListener.onValueChanged(property, (float) value);
            } else if (value instanceof String) {
                mPropertyChangeListener.onValueChanged(property, (String) value);
            }
        }

        if (mUIExtensionsManager.canUpdateAnnotDefaultProperties()) {
            AnnotHandler annotHandler = mUIExtensionsManager.getCurrentAnnotHandler();
            if (annotHandler == null) return;

            CreatePropertyChangedListener changedListener = mUIExtensionsManager.getCreatePropertyChangedListener(annotHandler.getType());
            if (changedListener != null) {
                changedListener.onCreateValueChanged(property, value);

                ToolItemBean toolItemBean = getToolItemBean(changedListener.getToolType(), changedListener.getTabPosition());
                if (toolItemBean == null) return;

                if (property == PROPERTY_COLOR || property == PROPERTY_SELF_COLOR) {
                    toolItemBean.property.color = (int) value;
                    if (toolItemBean.toolItem instanceof UIColorItem) {
                        ((UIColorItem) toolItemBean.toolItem).setAlphaColorBg((int) value);
                        if (toolItemBean.toolItem.isSelected()) {
                            mUIExtensionsManager.getMainFrame().getCurToolbar().getPropView().setFillColorFilter((int) value);
                        }
                    }
                } else if (property == PROPERTY_FILL_COLOR) {
                    toolItemBean.property.fillColor = (int) value;
                } else if (property == PROPERTY_OPACITY) {
                    toolItemBean.property.opacity = (int) value;
                } else if (property == PROPERTY_FONTSIZE) {
                    toolItemBean.property.fontSize = (float) value;
                } else if (property == PROPERTY_FONTNAME) {
                    toolItemBean.property.fontName = (String) value;
                } else if (property == PROPERTY_PENCIL_TYPE) {
                    toolItemBean.property.style = (int) value;
                } else if (property == PROPERTY_LINEWIDTH || property == PROPERTY_LINEWIDTH_2) {
                    toolItemBean.property.lineWidth = (float) value;
                } else if (property == PROPERTY_FILEATTACHMENT) {
                    toolItemBean.property.style = (int) value;
                } else if (property == PROPERTY_ANNOT_TYPE) {
                    toolItemBean.property.style = (int) value;
                } else if (property == PROPERTY_DISTANCE) {
                    toolItemBean.property.scaleFromUnitIndex = (int) value;
                } else if (property == PROPERTY_DISTANCE_TIP) {
                    toolItemBean.property.scaleToUnitIndex = (int) value;
                } else if (property == PROPERTY_DISTANCE_VALUE) {
                    toolItemBean.property.scaleFromValue = (int) value;
                } else if (property == PROPERTY_DISTANCE_TIP_VALUE) {
                    toolItemBean.property.scaleToValue = (int) value;
                } else if (property == PROPERTY_ROTATION) {
                    toolItemBean.property.rotation = (int) value;
                }

                if (toolItemBean.toolItem != null && toolItemBean.toolItem.isSelected()) {
                    changedListener.resetToolPropertyBar();
                }
            }
        }
    }

    private ToolItemBean getToolItemBean(int toolType, int tabPosition) {
        if (toolType == -1 || tabPosition == -1) return null;

        List<MainCenterItemBean> centerItems = mUIExtensionsManager.getMainFrame().getCenterItems();
        for (MainCenterItemBean centerItemBean : centerItems) {
            if (centerItemBean.type == tabPosition) {
                List<ToolItemBean> toolItems = centerItemBean.toolItems;
                if (toolItems == null || toolItems.size() == 0) return null;

                for (ToolItemBean toolItemBean : toolItems) {
                    if (toolItemBean.type == toolType) {
                        return toolItemBean;
                    }
                }
                break;
            }
        }
        return null;
    }

    private Map<Long, TextView> map_type_name_views = new HashMap<>();

    private View getShapeView(final long type) {
        View shapeItem = View.inflate(mContext, R.layout.pb_shape, null);
        LinearLayout pb_ll_shape = shapeItem.findViewById(R.id.pb_ll_shape);
        TextView pb_shape_type_tv = shapeItem.findViewById(R.id.pb_shape_type_tv);
        TextView pb_shape_type_name = shapeItem.findViewById(R.id.pb_shape_name);
        TextView pb_shape_title_tv = shapeItem.findViewById(R.id.pb_subtitle_tv);
        // sub title
        String title = mCustomItemTitles.get(type);
        if (AppUtil.isEmpty(title)) {
            pb_shape_title_tv.setVisibility(View.GONE);
        } else {
            pb_shape_title_tv.setVisibility(View.VISIBLE);
            pb_shape_title_tv.setText(title);
        }

        if (type == PropertyBar.PROPERTY_ANNOT_TYPE) {
            pb_shape_type_name.setText(AppResource.getString(mContext, NoteUtil.getNameId(mNoteIconType)));
        } else if (type == PropertyBar.PROPERTY_FILEATTACHMENT) {
            pb_shape_type_name.setText(AppResource.getString(mContext, FileAttachmentUtil.getNameId(mAttachmentIconType)));
        } else if (type == PropertyBar.PROPERTY_FONTNAME || type == PropertyBar.PROPERTY_FONTNAME_2) {
            pb_shape_type_tv.setText(AppResource.getString(mContext, R.string.fx_string_font));
            pb_shape_type_name.setText(mFontname);
        } else if (type == PropertyBar.PROPERTY_RADIO_NAME) {
            pb_shape_type_tv.setText(AppResource.getString(mContext, R.string.fx_string_name));
            pb_shape_type_name.setText(mRadioName);
        } else if (type == PropertyBar.PROPERTY_OVERLAY_TEXT) {
            pb_shape_type_tv.setText(AppResource.getString(mContext, R.string.fx_string_overlay_title));
            pb_shape_type_name.setText(mOverlayText);
        }
        map_type_name_views.put(type, pb_shape_type_name);

        pb_ll_shape.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (type == PROPERTY_ANNOT_TYPE
                        || type == PROPERTY_FILEATTACHMENT
                        || type == PROPERTY_FONTNAME
                        || type == PropertyBar.PROPERTY_FONTNAME_2) {
                    mShowShapelistView = true;
//                    mTopSubTitleLl.setVisibility(View.GONE);
                    mTopTabRootLl.setVisibility(View.GONE);
                    int _contentWidth = mTabContentLl.getMeasuredWidth();
                    for (int i = 0; i < mTabContentLl.getChildCount(); i++) {
                        LinearLayout tabContent = (LinearLayout) mTabContentLl.getChildAt(i);
                        tabContent.removeAllViews();
                    }
                    mTabContentLl.removeAllViews();
                    int margin = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_8dp);
                    int titleHeight = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_pb_title_height);
                    int contentHeight = 0;
                    mTabContentLl.addView(getSubListView(type));
                    Point point = measureAdapterSize(mPBShapeListView);
                    if (point != null)
                        contentHeight = point.y;

                    int _contentHeight = margin + titleHeight + contentHeight;
                    int maxHeight;
                    if (mMaxHeight > 0) {
                        maxHeight = mMaxHeight;
                    } else {
                        maxHeight = mUIExtensionsManager.getRootView().getHeight()
                                - AppResource.getDimensionPixelSize(mContext, R.dimen.ux_topbar_height)
                                - mActionMenu.getSliderHeight();
                    }
                    int height = Math.min(maxHeight, _contentHeight);
                    ViewGroup.LayoutParams layoutParams = mTabContentLl.getLayoutParams();
                    layoutParams.height = height;
                    mTabContentLl.setLayoutParams(layoutParams);
                    mActionMenu.setScrollingEnabled(false);
                    PropertyBarImpl.this.show(mUIExtensionsManager.getRootView(),
                            mRectF, _contentWidth, height, mArrowPosition);
                } else if (type == PROPERTY_RADIO_NAME || type == PROPERTY_OVERLAY_TEXT) {
                    showEditDialog(type, new UITextEditDialogV.IDialogListener() {
                        @Override
                        public void onDismiss() {
                        }

                        @Override
                        public void onPositiveButtonCallback(String editContent) {
                            if (type == PROPERTY_RADIO_NAME) {
                                if (!mRadioName.equals(editContent)) {
                                    mRadioName = editContent;

                                    TextView type_name = map_type_name_views.get(type);
                                    if (type_name != null)
                                        type_name.setText(editContent);
                                    onValueChanged(type, editContent);
                                }

                            } else {
                                if (!mOverlayText.equals(editContent)) {
                                    mOverlayText = editContent;
                                    TextView type_name = map_type_name_views.get(type);
                                    if (type_name != null)
                                        type_name.setText(editContent);
                                    onValueChanged(type, editContent);
                                }
                            }
                        }

                        @Override
                        public void onNegativeButtonCallback() {
                        }
                    });
                }
            }
        });
        return shapeItem;
    }

    private void showEditDialog(final long type, UITextEditDialogV.IDialogListener dialogListener) {
        final UITextEditDialogV textEditDialog = new UITextEditDialogV(mUIExtensionsManager.getAttachedActivity());
        if (type == PROPERTY_RADIO_NAME) {
            textEditDialog.setTitle(AppResource.getString(mContext, R.string.fx_string_name));
            textEditDialog.setContent(mRadioName);
        } else if (type == PROPERTY_OVERLAY_TEXT) {
            textEditDialog.setTitle(AppResource.getString(mContext, R.string.fx_string_overlay_title));
            textEditDialog.setContent(mOverlayText);
        }
        textEditDialog.getPositiveButton().setEnabled(false);
        textEditDialog.setDialogListener(dialogListener);
        textEditDialog.setCanEdit(canEdit);
        textEditDialog.setTextChangedListener(new UITextEditDialogV.ITextWatcher() {
            @Override
            public boolean beforeTextChanged(CharSequence s, int start, int count, int after) {
                return false;
            }

            @Override
            public boolean onTextChanged(CharSequence s, int start, int before, int count) {
                return false;
            }

            @Override
            public boolean afterTextChanged(Editable s) {
                if (type == PROPERTY_RADIO_NAME && TextUtils.isEmpty(s)) {
                    textEditDialog.getPositiveButton().setEnabled(false);
                    return true;
                }
                return false;
            }
        });
        textEditDialog.show();
    }

    private ListView mPBShapeListView;

    @SuppressLint("ClickableViewAccessibility")
    private View getSubListView(final long type) {
        mShowShapeListType = type;
        View subListItem = View.inflate(mContext, R.layout.pb_shape_list, null);
        LinearLayout pb_shape_back = subListItem.findViewById(R.id.pb_ll_back_view);
        ImageView pb_back_iv = subListItem.findViewById(R.id.pb_title_back_view);
        LinearLayout.LayoutParams backParams = (LinearLayout.LayoutParams) pb_shape_back.getLayoutParams();
        if (AppDisplay.isPad())
            backParams.height = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_pb_title_pad_height);
        else
            backParams.height = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_pb_title_height);
        pb_shape_back.setLayoutParams(backParams);
        pb_shape_back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mShowShapelistView = false;
                mClearCustomProperty = false;
                reset(mSupportProperty);
                PropertyBarImpl.this.update(mRectF, mArrowPosition);
            }
        });

        TextView pb_shape_title = subListItem.findViewById(R.id.pb_title_text_view);
        List<ShapeListAdapter.ShapeItemInfo> items = new ArrayList<>();
        if (type == PropertyBar.PROPERTY_ANNOT_TYPE) {
            pb_shape_title.setText(AppResource.getString(mContext, R.string.pb_shape_title));

            for (int icontype : ICONTYPES) {
                ShapeListAdapter.ShapeItemInfo itemInfo = new ShapeListAdapter.ShapeItemInfo();
                itemInfo.iconId = NoteUtil.getIconId(icontype);
                itemInfo.name = AppResource.getString(mContext, NoteUtil.getNameId(icontype));
                itemInfo.type = icontype;
                itemInfo.isChecked = mNoteIconType == icontype;
                items.add(itemInfo);
            }
        } else if (type == PropertyBar.PROPERTY_FILEATTACHMENT) {
            pb_shape_title.setText(AppResource.getString(mContext, R.string.pb_shape_title));

            String[] fatTypes = FileAttachmentUtil.getIconNames();
            for (String s : fatTypes) {
                ShapeListAdapter.ShapeItemInfo itemInfo = new ShapeListAdapter.ShapeItemInfo();
                int fatType = FileAttachmentUtil.getIconType(s);
                itemInfo.iconId = FileAttachmentUtil.getIconId(fatType);
                itemInfo.name = AppResource.getString(mContext, FileAttachmentUtil.getNameId(fatType));
                itemInfo.type = fatType;
                itemInfo.isChecked = mAttachmentIconType == fatType;
                items.add(itemInfo);
            }
        } else if (type == PropertyBar.PROPERTY_FONTNAME) {
            pb_shape_title.setText(AppResource.getString(mContext, R.string.pb_fontname_tab));

            for (String fontName : mFontNames) {
                ShapeListAdapter.ShapeItemInfo itemInfo = new ShapeListAdapter.ShapeItemInfo();
                itemInfo.name = fontName;
                itemInfo.isChecked = mFontname.equals(fontName);
                items.add(itemInfo);
            }
        } else if (type == PropertyBar.PROPERTY_FONTNAME_2) {
            pb_shape_title.setText(AppResource.getString(mContext, R.string.pb_fontname_tab));

            for (String fontName : mFontNames_2) {
                ShapeListAdapter.ShapeItemInfo itemInfo = new ShapeListAdapter.ShapeItemInfo();
                itemInfo.name = fontName;
                itemInfo.isChecked = mFontname.equals(fontName);
                items.add(itemInfo);
            }
        } else if (type == PropertyBar.PROPERTY_FONTNAME_LIST) {
            pb_back_iv.setVisibility(View.GONE);
            pb_shape_title.setText(AppResource.getString(mContext, R.string.pb_fontname_tab));

            for (String fontName : mFontNames_2) {
                ShapeListAdapter.ShapeItemInfo itemInfo = new ShapeListAdapter.ShapeItemInfo();
                itemInfo.name = fontName;
                itemInfo.isChecked = mFontname.equals(fontName);
                items.add(itemInfo);
            }
        } else if (type == PropertyBar.PROPERTY_FONTSIZE
                || type == PropertyBar.PROPERTY_FONTSIZE_2
                || type == PROPERTY_AUTO_FONTSIZE
                || type == PROPERTY_FONTSIZE_LIST) {
            if (type == PROPERTY_FONTSIZE_LIST)
                pb_back_iv.setVisibility(View.GONE);

            pb_shape_title.setText(AppResource.getString(mContext, R.string.fx_string_fontsize));

            float[] fontSizes;
            if (type == PROPERTY_FONTSIZE_2 || type == PROPERTY_FONTSIZE_LIST) {
                int length = mFontSizes.length;
                fontSizes = new float[length + 2];
                System.arraycopy(mFontSizes, 0, fontSizes, 0, length);
                fontSizes[length] = 96.0f;
                fontSizes[length + 1] = 144.0f;
            } else {
                fontSizes = mFontSizes;
            }
            for (float fontSize : fontSizes) {
                ShapeListAdapter.ShapeItemInfo itemInfo = new ShapeListAdapter.ShapeItemInfo();
                itemInfo.name = (int) fontSize == 0
                        ? AppResource.getString(mContext, R.string.fx_string_auto) : (int) fontSize + "pt";
                itemInfo.value = fontSize;
                itemInfo.isChecked = mFontsize == fontSize;
                items.add(itemInfo);
            }
        } else if (type == PropertyBar.PROPERTY_DISTANCE) {
            pb_shape_title.setText(AppResource.getString(mContext, R.string.fx_string_unit));

            List<String> distanceNames = LineUtil.getDistanceNames();
            for (int i = 0; i < distanceNames.size(); i++) {
                ShapeListAdapter.ShapeItemInfo itemInfo = new ShapeListAdapter.ShapeItemInfo();
                itemInfo.name = distanceNames.get(i);
                itemInfo.type = i;
                itemInfo.isChecked = i == currentDistanceUnit;
                items.add(itemInfo);
            }
        } else if (type == PropertyBar.PROPERTY_DISTANCE_TIP) {
            pb_shape_title.setText(AppResource.getString(mContext, R.string.fx_string_unit));

            List<String> distanceNames = LineUtil.getDistanceNames();
            for (int i = 0; i < distanceNames.size(); i++) {
                ShapeListAdapter.ShapeItemInfo itemInfo = new ShapeListAdapter.ShapeItemInfo();
                itemInfo.name = distanceNames.get(i);
                itemInfo.type = i;
                itemInfo.isChecked = i == currentDistanceDisplayTip;
                items.add(itemInfo);
            }
        }

        mPBShapeListView = subListItem.findViewById(R.id.pb_shape_list);
        mPBShapeListView.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (mPBShapeListView.canScrollVertically(-1)) {
                    mPBShapeListView.requestDisallowInterceptTouchEvent(true);
                } else {
                    mPBShapeListView.requestDisallowInterceptTouchEvent(false);
                }
                return false;
            }
        });

        final ShapeListAdapter pb_shape_adapter = new ShapeListAdapter(mContext, items);
        mPBShapeListView.setAdapter(pb_shape_adapter);
        if (canEdit) {
            mPBShapeListView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                @Override
                public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                    ShapeListAdapter.ShapeItemInfo itemInfo = (ShapeListAdapter.ShapeItemInfo) parent.getItemAtPosition(position);
                    if (type == PROPERTY_ANNOT_TYPE) {
                        if (mNoteIconType != itemInfo.type) {
                            for (ShapeListAdapter.ShapeItemInfo info : pb_shape_adapter.getItemInfos()) {
                                if (info.isChecked) {
                                    info.isChecked = false;
                                    break;
                                }
                            }
                            itemInfo.isChecked = true;
                            pb_shape_adapter.notifyDataSetChanged();

                            mNoteIconType = itemInfo.type;
                            onValueChanged(PropertyBar.PROPERTY_ANNOT_TYPE, mNoteIconType);
                        }
                    } else if (type == PROPERTY_FILEATTACHMENT) {
                        for (ShapeListAdapter.ShapeItemInfo info : pb_shape_adapter.getItemInfos()) {
                            if (info.isChecked) {
                                info.isChecked = false;
                                break;
                            }
                        }
                        itemInfo.isChecked = true;
                        pb_shape_adapter.notifyDataSetChanged();

                        mAttachmentIconType = itemInfo.type;
                        onValueChanged(PropertyBar.PROPERTY_FILEATTACHMENT, mAttachmentIconType);
                    } else if (type == PROPERTY_FONTNAME || type == PROPERTY_FONTNAME_2 || type == PROPERTY_FONTNAME_LIST) {
                        if (!mFontname.equals(itemInfo.name)) {
                            for (ShapeListAdapter.ShapeItemInfo info : pb_shape_adapter.getItemInfos()) {
                                if (info.isChecked) {
                                    info.isChecked = false;
                                    break;
                                }
                            }

                            mFontname = itemInfo.name;
                            itemInfo.isChecked = true;
                            pb_shape_adapter.notifyDataSetChanged();
                            onValueChanged(type, mFontname);
                        }
                    } else if (type == PROPERTY_FONTSIZE
                            || type == PROPERTY_FONTSIZE_2
                            || type == PROPERTY_AUTO_FONTSIZE
                            || type == PROPERTY_FONTSIZE_LIST) {
                        if (mFontsize != itemInfo.value) {
                            for (ShapeListAdapter.ShapeItemInfo info : pb_shape_adapter.getItemInfos()) {
                                if (info.isChecked) {
                                    info.isChecked = false;
                                    break;
                                }
                            }

                            mFontsize = itemInfo.value;
                            itemInfo.isChecked = true;
                            pb_shape_adapter.notifyDataSetChanged();
                            onValueChanged(type, mFontsize);
                        }
                    } else if (type == PROPERTY_DISTANCE) {
                        if (currentDistanceUnit != itemInfo.type) {
                            for (ShapeListAdapter.ShapeItemInfo info : pb_shape_adapter.getItemInfos()) {
                                if (info.isChecked) {
                                    info.isChecked = false;
                                    break;
                                }
                            }
                            currentDistanceUnit = itemInfo.type;
                            itemInfo.isChecked = true;
                            pb_shape_adapter.notifyDataSetChanged();
                            onValueChanged(PropertyBar.PROPERTY_DISTANCE, position);
                        }
                    } else if (type == PROPERTY_DISTANCE_TIP) {
                        if (currentDistanceDisplayTip != itemInfo.type) {
                            for (ShapeListAdapter.ShapeItemInfo info : pb_shape_adapter.getItemInfos()) {
                                if (info.isChecked) {
                                    info.isChecked = false;
                                    break;
                                }
                            }
                            currentDistanceDisplayTip = itemInfo.type;
                            itemInfo.isChecked = true;
                            pb_shape_adapter.notifyDataSetChanged();
                            onValueChanged(PropertyBar.PROPERTY_DISTANCE_TIP, position);
                        }
                    }
                }
            });
        } else {
            mPBShapeListView.setEnabled(false);
            subListItem.setAlpha(PB_ALPHA);
        }
        return subListItem;
    }

    private Point measureAdapterSize(ListView listView) {
        ListAdapter listAdapter = listView.getAdapter();
        if (listAdapter == null) {
            return null;
        }
        int width = 0;
        int height = 0;
        for (int i = 0, len = listAdapter.getCount(); i < len; i++) {
            View listItem = listAdapter.getView(i, null, listView);
            listItem.measure(0, 0);
            height += listItem.getMeasuredHeight();

            int itemWidth = listItem.getMeasuredWidth();
            if (itemWidth > width)
                width = itemWidth;
        }
        return new Point(width, height);
    }

    private ThicknessImage mThicknessImage;
    private float mPenRealWidth;

    private View getLineWidthView(final long type) {
        final View lineWidthItem = LayoutInflater.from(mContext).inflate(R.layout.pb_linewidth, null, false);
        mThicknessImage = lineWidthItem.findViewById(R.id.pb_img_lineWidth_mypic);
        TextView tv_width = lineWidthItem.findViewById(R.id.pb_tv_lineWidth_size);
        SeekBar sb_lineWidth = lineWidthItem.findViewById(R.id.sb_lineWidth);
        LayerDrawable layerDrawable = (LayerDrawable) sb_lineWidth.getProgressDrawable();
        Drawable drawable = layerDrawable.getDrawable(1);
        drawable.setColorFilter(ThemeConfig.getInstance(mContext).getPrimaryColor(), PorterDuff.Mode.SRC);

        final AnnotHandler annotHandler = mUIExtensionsManager.getCurrentAnnotHandler();
        final boolean isInkTool = isInkTool();
        if (type == PropertyBar.PROPERTY_LINEWIDTH) {
            /* suyu
                ink  toolHandler 单独设置了 MaxLineWidth, 其他模块为 12
                ink annotHandler MaxLineWidth 统一为 36
             */
            if (isInkTool) {
                if (annotHandler != null && annotHandler.getType() == Annot.e_Ink) {
                    mMaxLineWidth = 45;
                }
                sb_lineWidth.setMax(mMaxLineWidth - 1);
                if (mLinewith < 1) {
                    tv_width.setText(String.format(Locale.US, "%.1fpt", mLinewith));
                    sb_lineWidth.setProgress((int) (mLinewith * 10 - 1));
                } else {
                    tv_width.setText(String.format(Locale.US, "%dpt", (int) mLinewith));
                    sb_lineWidth.setProgress((int) (mLinewith + 8));
                }
            } else {
                mMaxLineWidth = 12;
                sb_lineWidth.setMax(mMaxLineWidth - 1);
                tv_width.setText((int) (mLinewith + 0.5f) + " pt");
                sb_lineWidth.setProgress((int) (mLinewith - 1 + 0.5f));
            }
        } else {
            sb_lineWidth.setMax(mMaxLineWidth * 2 - 1);
            sb_lineWidth.setProgress((int) (mLinewith * 2 - 1));
            if (mLinewith % 1 == 0) {
                tv_width.setText((int) mLinewith + " pt");
            } else {
                DecimalFormat decimalFormat = new DecimalFormat("#.#");
                String lineWidth = decimalFormat.format(mLinewith);
                tv_width.setText(String.format("%spt", lineWidth));
            }
        }

        //sub text
        if (!AppUtil.isEmpty(mCustomItemTitles.get(type))) {
            ((TextView) lineWidthItem.findViewById(R.id.pb_subtitle_tv)).setText(mCustomItemTitles.get(type));
        }

        if (canEdit) {
            sb_lineWidth.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
                @Override
                public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                    LinearLayout linearLayout = (LinearLayout) (seekBar.getParent());
                    ThicknessImage thicknessImage = (ThicknessImage) linearLayout.getChildAt(0);
                    TextView tv_width = (TextView) linearLayout.getChildAt(2);
                    mPenRealWidth = 0f;

                    if (type == PropertyBar.PROPERTY_LINEWIDTH) {
                        if (progress >= 0 && progress < mMaxLineWidth) {
                            mLinewith = progress + 1;
                            if (isInkTool) {
                                if (mLinewith < 10) {
                                    mPenRealWidth = mLinewith / 10;
                                    tv_width.setText(String.format(Locale.US, "%.1fpt", mPenRealWidth));
                                    thicknessImage.setBorderThickness(0.5f);
                                } else {
                                    mPenRealWidth = mLinewith - 9;
                                    tv_width.setText(String.format(Locale.US, "%dpt", (int) mPenRealWidth));
                                    thicknessImage.setBorderThickness(mPenRealWidth);
                                }
                            } else {
                                mPenRealWidth = mLinewith;
                                tv_width.setText((int) mLinewith + " pt");
                                thicknessImage.setBorderThickness(mLinewith);
                            }
                            onValueChanged(type, mPenRealWidth);
                        }
                    } else {
                        if (progress >= 0 && progress < mMaxLineWidth * 2) {
                            mLinewith = (float) (progress + 1) / 2;
                            mLinewith = Math.max(mLinewith, mMinLineWidth);
                            thicknessImage.setBorderThickness(mLinewith);
                            if (mLinewith % 1 == 0) {
                                tv_width.setText((int) mLinewith + " pt");
                            } else {
                                DecimalFormat decimalFormat = new DecimalFormat("#.#");
                                String lineWidth = decimalFormat.format(mLinewith);
                                tv_width.setText(String.format("%spt", lineWidth));
                            }
                        }
                        onValueChanged(type, mLinewith);
                    }
                }

                @Override
                public void onStartTrackingTouch(SeekBar seekBar) {
                }

                @Override
                public void onStopTrackingTouch(SeekBar seekBar) {
                }
            });
        } else {
            sb_lineWidth.setEnabled(false);
            lineWidthItem.setAlpha(PB_ALPHA);
        }

        if (mLinewith < 1) {
            mThicknessImage.setBorderThickness(0.5f);
        } else {
            mThicknessImage.setBorderThickness(mLinewith);
        }
        if (mSupportProperty != PropertyBar.PROPERTY_ERASERSHAPE && ((mSupportProperty & PropertyBar.PROPERTY_COLOR) == PropertyBar.PROPERTY_COLOR
                || (mSupportProperty & PropertyBar.PROPERTY_FILL_COLOR) == PropertyBar.PROPERTY_FILL_COLOR)) {
            mThicknessImage.setColor(mColor);
        } else {
            mThicknessImage.setColor(AppResource.getColor(mContext, R.color.p3));
        }
        return lineWidthItem;
    }

    private boolean isInkTool(){
        ToolHandler toolHandler = mUIExtensionsManager.getCurrentToolHandler();
        if (toolHandler != null && toolHandler.getType().equals(ToolHandler.TH_TYPE_INK)) return true;

        AnnotHandler annotHandler = mUIExtensionsManager.getCurrentAnnotHandler();
        if (annotHandler != null && annotHandler.getType() == Annot.e_Ink) return true;
        return mTag instanceof Integer && ((Integer) mTag == ToolConstants.Pencil || (Integer) mTag == ToolConstants.Highlighter);
    }

    private View getLineStyleView() {
        View lineStyleItem = LayoutInflater.from(mContext).inflate(R.layout.pb_linestyle, null, false);
        LinearLayout pb_ll_borderStyle = lineStyleItem.findViewById(R.id.pb_ll_borderStyle);
        for (int i = 0; i < mLinestyles.length; i++) {
            if (i + 1 == mLinestyle) {
                pb_ll_borderStyle.getChildAt(i).setBackgroundResource(R.drawable.pb_border_style_checked);
            } else {
                pb_ll_borderStyle.getChildAt(i).setBackgroundResource(0);
            }
        }
        for (int i = 0; i < mLinestyles.length; i++) {
            ImageView imageView = (ImageView) pb_ll_borderStyle.getChildAt(i);
            imageView.setTag(i);
            imageView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    LinearLayout linearLayout = (LinearLayout) (v.getParent());
                    int tag = Integer.parseInt(v.getTag().toString());

                    for (int i = 0; i < mLinestyles.length; i++) {
                        if (i == tag) {
                            linearLayout.getChildAt(i).setBackgroundResource(R.drawable.pb_border_style_checked);
                        } else {
                            linearLayout.getChildAt(i).setBackgroundResource(0);
                        }
                    }
                    onValueChanged(PropertyBar.PROPERTY_LINE_STYLE, mLinestyles[tag]);
                }
            });
        }

        return lineStyleItem;
    }

    @Override
    public void scaleFromUnit(int index) {
        this.currentDistanceUnit = index;
    }

    @Override
    public void scaleFromValue(float value) {
        scaleFromValue = value;
    }

    @Override
    public void scaleToUnit(int index) {
        this.currentDistanceDisplayTip = index;
    }

    @Override
    public void scaleToValue(float value) {
        scaleToValue = value;
    }

    private String[] displayScale;

    @Override
    public void setDistanceScale(String[] distanceScale) {
        this.displayScale = distanceScale;
    }

    @Override
    public void setEditable(boolean canEdit) {
        this.canEdit = canEdit;
    }

    private View getDistanceUnitSettingView() {
        View distanceItem = LayoutInflater.from(mContext).inflate(R.layout.pb_distance_unit, null, false);
        TextView pb_tv_distance = distanceItem.findViewById(R.id.pb_tv_distance_unit_1);
        TextView pb_tv_distance_distip = distanceItem.findViewById(R.id.pb_tv_distance_unit_2);
        final EditText pv_et_distance1 = distanceItem.findViewById(R.id.pb_tv_distance_unit_1_value);
        pv_et_distance1.setText("" + scaleFromValue);
        pv_et_distance1.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                pv_et_distance1.removeTextChangedListener(this);
                PropertyBarImpl.this.afterTextChanged(pv_et_distance1, s, 6, 2);
                pv_et_distance1.addTextChangedListener(this);

                String value = s.toString();
                if (!AppUtil.isBlank(value)) {
                    if (value.endsWith(".")) {
                        value = value.replace(".", "");
                    }
                    scaleFromValue = Float.parseFloat(value);
                    onValueChanged(PropertyBar.PROPERTY_DISTANCE_VALUE, scaleFromValue);
                }
            }
        });

        final EditText pv_et_distance2 = distanceItem.findViewById(R.id.pb_tv_distance_unit_2_value);
        pv_et_distance2.setText("" + scaleToValue);
        pv_et_distance2.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                pv_et_distance2.removeTextChangedListener(this);
                PropertyBarImpl.this.afterTextChanged(pv_et_distance2, s, 6, 2);
                pv_et_distance2.addTextChangedListener(this);

                String value = s.toString();
                if (!AppUtil.isBlank(value)) {
                    if (value.endsWith(".")) {
                        value = value.replace(".", "");
                    }
                    scaleToValue = Float.parseFloat(value);
                    onValueChanged(PropertyBar.PROPERTY_DISTANCE_TIP_VALUE, scaleToValue);
                }
            }
        });

        pb_tv_distance_distip.setText(DistanceMeasurement.valueOf(currentDistanceDisplayTip).getName());
        pb_tv_distance_distip.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mShowShapelistView = true;
                AppUtil.dismissInputSoft(pv_et_distance2);
//                mTopSubTitleLl.setVisibility(View.GONE);
                mTopTabRootLl.setVisibility(View.GONE);
                int _contentWidth = mTabContentLl.getMeasuredWidth();
                for (int i = 0; i < mTabContentLl.getChildCount(); i++) {
                    LinearLayout tabContent = (LinearLayout) mTabContentLl.getChildAt(i);
                    tabContent.removeAllViews();
                }
                mTabContentLl.removeAllViews();
                int margin = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_8dp);
                int titleHeight = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_pb_title_height);
                int contentHeight = 0;
                mTabContentLl.addView(getSubListView(PROPERTY_DISTANCE_TIP));
                Point point = measureAdapterSize(mPBShapeListView);
                if (point != null)
                    contentHeight = point.y;

                int _contentHeight = margin + titleHeight + contentHeight;
                int maxHeight;
                if (mMaxHeight > 0) {
                    maxHeight = mMaxHeight;
                } else {
                    maxHeight = mUIExtensionsManager.getRootView().getHeight()
                            - AppResource.getDimensionPixelSize(mContext, R.dimen.ux_topbar_height)
                            - mActionMenu.getSliderHeight();
                }
                int height = Math.min(maxHeight, _contentHeight);
                ViewGroup.LayoutParams layoutParams = mTabContentLl.getLayoutParams();
                layoutParams.height = height;
                mTabContentLl.setLayoutParams(layoutParams);
                PropertyBarImpl.this.show(mUIExtensionsManager.getRootView(), mRectF, _contentWidth, height, mArrowPosition);
            }
        });

        pb_tv_distance.setText(DistanceMeasurement.valueOf(currentDistanceUnit).getName());
        pb_tv_distance.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mShowShapelistView = true;
                AppUtil.dismissInputSoft(pv_et_distance1);
//                mTopSubTitleLl.setVisibility(View.GONE);
                mTopTabRootLl.setVisibility(View.GONE);
                int _contentWidth = mTabContentLl.getMeasuredWidth();
                for (int i = 0; i < mTabContentLl.getChildCount(); i++) {
                    LinearLayout tabContent = (LinearLayout) mTabContentLl.getChildAt(i);
                    tabContent.removeAllViews();
                }
                mTabContentLl.removeAllViews();
                int margin = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_8dp);
                int titleHeight = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_pb_title_height);
                int contentHeight = 0;
                mTabContentLl.addView(getSubListView(PROPERTY_DISTANCE));
                Point point = measureAdapterSize(mPBShapeListView);
                if (point != null)
                    contentHeight = point.y;

                int _contentHeight = margin + titleHeight + contentHeight;
                int maxHeight;
                if (mMaxHeight > 0) {
                    maxHeight = mMaxHeight;
                } else {
                    maxHeight = mUIExtensionsManager.getRootView().getHeight()
                            - AppResource.getDimensionPixelSize(mContext, R.dimen.ux_topbar_height)
                            - mActionMenu.getSliderHeight();
                }
                int height = Math.min(maxHeight, _contentHeight);
                ViewGroup.LayoutParams layoutParams = mTabContentLl.getLayoutParams();
                layoutParams.height = height;
                mTabContentLl.setLayoutParams(layoutParams);
                PropertyBarImpl.this.show(mUIExtensionsManager.getRootView(), mRectF, _contentWidth, height, mArrowPosition);
            }
        });

        if (!AppDisplay.isPad()) {
            mIsRegisterKeyboardListener = true;

            final ViewGroup parent = mUIExtensionsManager.getRootView();
            AppKeyboardUtil.setKeyboardListener(parent, parent, new AppKeyboardUtil.IKeyboardListener() {

                @Override
                public void onKeyboardOpened(int keyboardHeight) {
                    int y = 0;
                    int rootWidth = mUIExtensionsManager.getRootView().getWidth();
                    int rootHeight = mUIExtensionsManager.getRootView().getHeight();
                    if (AppDisplay.getRawScreenHeight() != rootHeight)
                        y = AppDisplay.getNavBarHeight();
                    int width;
                    if (AppDisplay.isLandscape())
                        width = Math.min(rootWidth, rootHeight);
                    else
                        width = parent.getWidth();
                    if (mActionMenu != null) {
                        int height = keyboardHeight + pv_et_distance1.getHeight() + mActionMenu.getSliderHeight();
                        mActionMenu.update(mUIExtensionsManager.getRootView(), 0, y, width, height);
                    }
                }

                @Override
                public void onKeyboardClosed() {
                    PropertyBarImpl.this.update(mRectF, mArrowPosition);
                }
            });
        }
        if (!canEdit) {
            distanceItem.setAlpha(PB_ALPHA);
        }
        return distanceItem;
    }

    private void afterTextChanged(EditText editText, Editable editable, int integerDigits, int decimalDigits) {
        String value = editable.toString();

        if (value.contains(".")) {
            if (value.trim().startsWith(".")) {
                value = "0" + value;
                editable.replace(0, editable.length(), value.trim());
            }
            editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(integerDigits + decimalDigits + 1)});

            if (value.indexOf(".") > integerDigits) {
                value = value.substring(0, integerDigits) + "." + value.substring(value.indexOf(".") + 1);
                editable.replace(0, editable.length(), value.trim());
            }

            if (value.length() - 1 - value.indexOf(".") > decimalDigits) {
                value = value.substring(0, value.indexOf(".") + decimalDigits + 1);
                editable.replace(0, editable.length(), value.trim());
            }
        } else {
            if (integerDigits > 0) {
                editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(integerDigits + 1)});
                if (value.length() > integerDigits) {
                    value = value.substring(0, integerDigits);
                    editable.replace(0, editable.length(), value.trim());
                }
            }
        }

        if (value.startsWith("0") && value.trim().length() > 1) {
            if (value.charAt(1) != '.') {
                value = "0." + value.substring(value.indexOf(".") + 1);
                editable.replace(0, editable.length(), value);
            }
        }
    }

    private View getDistanceUnitDisplayView() {
        View distanceItem = LayoutInflater.from(mContext).inflate(R.layout.pb_distance_scale_display, null, false);
        TextView pb_tv_distance = distanceItem.findViewById(R.id.pb_tv_distance_unit_1);
        TextView pb_tv_distance_distip = distanceItem.findViewById(R.id.pb_tv_distance_unit_2);
        TextView pv_et_distance1 = distanceItem.findViewById(R.id.pb_tv_distance_unit_1_value);
        pv_et_distance1.setText(displayScale[0]);

        TextView pv_et_distance2 = distanceItem.findViewById(R.id.pb_tv_distance_unit_2_value);
        pv_et_distance2.setText(displayScale[3]);

        pb_tv_distance_distip.setText(displayScale[4]);
        pb_tv_distance.setText(displayScale[1]);
        return distanceItem;
    }

    private View getFontSizeView(final long type) {
        View fontSizeItem = LayoutInflater.from(mContext).inflate(R.layout.pb_font_size, null, false);
        LinearLayout pb_ll_font_content = fontSizeItem.findViewById(R.id.pb_ll_font_size);
        LinearLayout pb_ll_zoom_font_size = fontSizeItem.findViewById(R.id.pb_ll_zoom_font_size);
        ImageView pb_iv_right_arrow = fontSizeItem.findViewById(R.id.pb_iv_font_size_right_arrow);
        final TextView pb_tv_font_size = fontSizeItem.findViewById(R.id.pb_font_size_value);
        String fontSize = (int) mFontsize == 0
                ? AppResource.getString(mContext, R.string.fx_string_auto) : (int) mFontsize + " pt";
        pb_tv_font_size.setText(fontSize);

        if (type == PROPERTY_FONTSIZE || type == PROPERTY_FONTSIZE_2) {
            pb_ll_zoom_font_size.setVisibility(View.VISIBLE);
            pb_iv_right_arrow.setVisibility(View.GONE);
            final ImageView pb_iv_reduce_font_size = fontSizeItem.findViewById(R.id.pb_reduce_font_size);
            final ImageView pb_iv_increate_font_size = fontSizeItem.findViewById(R.id.pb_increate_font_size);
            ColorStateList colorStateList = AppCompatResources.getColorStateList(mContext, R.color.pb_font_size_ic_selector);
            ThemeUtil.setTintList(pb_iv_reduce_font_size, colorStateList);
            ThemeUtil.setTintList(pb_iv_increate_font_size, colorStateList);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
                pb_iv_increate_font_size.setForceDarkAllowed(false);
                pb_iv_reduce_font_size.setForceDarkAllowed(false);
            }
            if (mFontsize == MIN_FONT_SIZE)
                pb_iv_reduce_font_size.setEnabled(false);
            if (mFontsize == MAX_FONT_SIZE)
                pb_iv_increate_font_size.setEnabled(false);
            if (canEdit) {
                pb_iv_increate_font_size.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (AppUtil.isFastDoubleClick()) {
                            return;
                        }

                        if (mFontsize < MAX_FONT_SIZE) {
                            mFontsize++;
                            pb_tv_font_size.setText(String.format("%spt", (int) mFontsize));
                            if (mFontsize == MAX_FONT_SIZE)
                                pb_iv_increate_font_size.setEnabled(false);
                            if (mFontsize > MIN_FONT_SIZE)
                                pb_iv_reduce_font_size.setEnabled(true);
                            onValueChanged(type, mFontsize);
                        }
                    }
                });

                pb_iv_reduce_font_size.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (AppUtil.isFastDoubleClick()) {
                            return;
                        }

                        if (mFontsize > MIN_FONT_SIZE) {
                            mFontsize--;
                            pb_tv_font_size.setText(String.format("%spt", (int) mFontsize));
                            if (mFontsize == MIN_FONT_SIZE)
                                pb_iv_reduce_font_size.setEnabled(false);
                            if (mFontsize < MAX_FONT_SIZE)
                                pb_iv_increate_font_size.setEnabled(true);
                            onValueChanged(type, mFontsize);
                        }
                    }
                });
            } else {
                pb_iv_reduce_font_size.setClickable(false);
                pb_iv_increate_font_size.setClickable(false);
            }
        } else {
            pb_iv_right_arrow.setVisibility(View.VISIBLE);
            pb_ll_zoom_font_size.setVisibility(View.GONE);
        }

        pb_ll_font_content.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mShowShapelistView = true;
//                mTopSubTitleLl.setVisibility(View.GONE);
                mTopTabRootLl.setVisibility(View.GONE);
                int _contentWidth = mTabContentLl.getMeasuredWidth();
                for (int i = 0; i < mTabContentLl.getChildCount(); i++) {
                    LinearLayout tabContent = (LinearLayout) mTabContentLl.getChildAt(i);
                    tabContent.removeAllViews();
                }
                mTabContentLl.removeAllViews();
                int margin = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_8dp);
                int titleHeight = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_pb_title_height);
                int contentHeight = 0;
                mTabContentLl.addView(getSubListView(type));
                Point point = measureAdapterSize(mPBShapeListView);
                if (point != null)
                    contentHeight = point.y;

                int _contentHeight = margin + titleHeight + contentHeight;
                int maxHeight;
                if (mMaxHeight > 0) {
                    maxHeight = mMaxHeight;
                } else {
                    maxHeight = mUIExtensionsManager.getRootView().getHeight()
                            - AppResource.getDimensionPixelSize(mContext, R.dimen.ux_topbar_height)
                            - mActionMenu.getSliderHeight();
                }
                int height = Math.min(maxHeight, _contentHeight);
                ViewGroup.LayoutParams layoutParams = mTabContentLl.getLayoutParams();
                layoutParams.height = height;
                mTabContentLl.setLayoutParams(layoutParams);
                mActionMenu.setScrollingEnabled(false);
                PropertyBarImpl.this.show(mUIExtensionsManager.getRootView(), mRectF, _contentWidth, height, mArrowPosition);
            }
        });
        return fontSizeItem;
    }

    private View getFontStyleView() {
        View fontStyleView = LayoutInflater.from(mContext).inflate(R.layout.pb_font_style, null, false);
        final ImageView pb_iv_bold_style = fontStyleView.findViewById(R.id.pb_font_style_bold);
        final ImageView pb_iv_italic_style = fontStyleView.findViewById(R.id.pb_font_style_italic);
        ColorStateList colorStateList = AppCompatResources.getColorStateList(mContext, R.color.pb_font_style_ic_selector);
        ThemeUtil.setTintList(pb_iv_bold_style, colorStateList);
        ThemeUtil.setTintList(pb_iv_italic_style, colorStateList);
        ThemeUtil.setBackgroundTintList(pb_iv_bold_style, getFontStyleBgTintList(mContext));
        ThemeUtil.setBackgroundTintList(pb_iv_italic_style, getFontStyleBgTintList(mContext));
        if (Build.VERSION.SDK_INT >= 29) {//29 =Build.VERSION_CODES.Q
            pb_iv_bold_style.setForceDarkAllowed(false);
            pb_iv_italic_style.setForceDarkAllowed(false);
        }

        pb_iv_bold_style.setSelected((mFontStyle & PROPERTY_FONT_BOLD) != 0);
        pb_iv_italic_style.setSelected((mFontStyle & PROPERTY_FONT_ITALIC) != 0);

        pb_iv_bold_style.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if ((mFontStyle & PROPERTY_FONT_BOLD) == 0) {
                    mFontStyle |= PROPERTY_FONT_BOLD;
                    pb_iv_bold_style.setSelected(true);
                } else {
                    mFontStyle &= (~PROPERTY_FONT_BOLD);
                    pb_iv_bold_style.setSelected(false);
                }
                onValueChanged(PropertyBar.PROPERTY_FONTSTYLE, mFontStyle);
            }
        });

        pb_iv_italic_style.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if ((mFontStyle & PROPERTY_FONT_ITALIC) == 0) {
                    mFontStyle |= PROPERTY_FONT_ITALIC;
                    pb_iv_italic_style.setSelected(true);
                } else {
                    mFontStyle &= (~PROPERTY_FONT_ITALIC);
                    pb_iv_italic_style.setSelected(false);
                }
                onValueChanged(PropertyBar.PROPERTY_FONTSTYLE, mFontStyle);
            }
        });
        return fontStyleView;
    }

    private ColorStateList getFontStyleBgTintList(Context context) {
        int pressed = AppResource.getColor(mContext, R.color.p1);
        int disabled = AppResource.getColor(mContext, R.color.p1);
        int normal = AppResource.getColor(mContext, R.color.p2);
        int selected = ThemeConfig.getInstance(context).getPrimaryColor();
        return AppResource.createColorStateList(pressed, selected, selected, disabled, normal);
    }

    private LinearLayout mPBLlOpacity;

    private View getOpacityView() {
        View opacityItem = LayoutInflater.from(mContext).inflate(R.layout.pb_opacity, null, false);
        mPBLlOpacity = opacityItem.findViewById(R.id.pb_ll_opacity);
        if (Build.VERSION.SDK_INT >= 29) { //29 = Build.VERSION.Q
            mPBLlOpacity.setForceDarkAllowed(false);
        }
        ImageView ivOne = opacityItem.findViewById(R.id.pb_opacity_bg_one);
        ImageView ivTwo = opacityItem.findViewById(R.id.pb_opacity_bg_two);
        ImageView ivThree = opacityItem.findViewById(R.id.pb_opacity_bg_three);
        ImageView ivFour = opacityItem.findViewById(R.id.pb_opacity_bg_four);
        if (AppUtil.isDarkMode(mContext)) {
            ivOne.setBackground(AppResource.getDrawable(mContext, R.drawable.dark_pb_opacity_bg));
            ivTwo.setBackground(AppResource.getDrawable(mContext, R.drawable.dark_pb_opacity_bg));
            ivThree.setBackground(AppResource.getDrawable(mContext, R.drawable.dark_pb_opacity_bg));
            ivFour.setBackground(AppResource.getDrawable(mContext, R.drawable.dark_pb_opacity_bg));
        } else {
            ivOne.setBackground(AppResource.getDrawable(mContext, R.drawable.pb_opacity_bg));
            ivTwo.setBackground(AppResource.getDrawable(mContext, R.drawable.pb_opacity_bg));
            ivThree.setBackground(AppResource.getDrawable(mContext, R.drawable.pb_opacity_bg));
            ivFour.setBackground(AppResource.getDrawable(mContext, R.drawable.pb_opacity_bg));
        }

        int opacityColor;
        if ((mSupportProperty & PropertyBar.PROPERTY_COLOR) == PropertyBar.PROPERTY_COLOR)
            opacityColor = mColor;
        else
            opacityColor = AppResource.getColor(mContext, R.color.p3);
        for (int i = 0; i < mPBLlOpacity.getChildCount(); i++) {
            LinearLayout ll_opacity_item = (LinearLayout) ((LinearLayout) mPBLlOpacity.getChildAt(i)).getChildAt(0);
            ll_opacity_item.setBackground(AppResource.getDrawable(mContext, R.drawable.common_border_radius_6_rectangle));
            ll_opacity_item.setTag(i);

            ImageView iv_opacity_item = (ImageView) ll_opacity_item.getChildAt(0);
            iv_opacity_item.setImageAlpha(AppDmUtil.opacity100To255(mOpacitys[i]));
            iv_opacity_item.setColorFilter(opacityColor);
            if (canEdit) {
                ll_opacity_item.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        int tag = Integer.parseInt(v.getTag().toString());

                        for (int j = 0; j < mPBLlOpacity.getChildCount(); j++) {
                            LinearLayout ll_opacity = (LinearLayout) ((LinearLayout) mPBLlOpacity.getChildAt(j)).getChildAt(0);
                            ll_opacity.setSelected(tag == j);
                            int color;
                            if (tag == j)
                                color = ThemeConfig.getInstance(mContext).getPrimaryColor();
                            else
                                color = AppResource.getColor(mContext, R.color.ux_color_translucent);
                            ll_opacity.getBackground().setColorFilter(new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
                        }

                        if (mPropertyChangeListener != null) {
                            onValueChanged(PropertyBar.PROPERTY_OPACITY, mOpacitys[tag]);
                            mOpacity = mOpacitys[tag];
                        }
                    }
                });
            } else {
                ll_opacity_item.setEnabled(false);
            }
            int color;
            if (mOpacity == mOpacitys[i])
                color = ThemeConfig.getInstance(mContext).getPrimaryColor();
            else
                color = AppResource.getColor(mContext, R.color.ux_color_translucent);
            ll_opacity_item.getBackground().setColorFilter(new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
        }

        if (!canEdit) {
            opacityItem.setAlpha(PB_ALPHA);
        }
        return opacityItem;
    }

    private ShapeGridListAdaper mSymbolListAdapter;
    private ShapeGridListAdaper mNumberListAdapter;

    private View getGridView(final long type) {
        int spanCount = 0;
        int margin = 0;
        List<ShapeGridListAdaper.GridItemInfo> itemInfos = new ArrayList<>();
        if (type == PropertyBar.PROPERTY_LIST_SYMBOL) {
            spanCount = 7;
            margin = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_16dp);

            int[] icons = {R.drawable.pb_ic_none, R.drawable.pb_bullet_library_oval,
                    R.drawable.pb_bullet_library_rect, R.drawable.pb_bullet_library_diamond,
                    R.drawable.pb_bullet_library_check, R.drawable.pb_bullet_library_star,
                    R.drawable.pb_bullet_library_arrow,};
            int[] types = {SYMBOL_NONE, SYMBOL_OVAL,
                    SYMBOL_RECT, SYMBOL_DIAMOND,
                    SYMBOL_CHECK, SYMBOL_STAR,
                    SYMBOL_ARROW};
            itemInfos = getGridInfos(mSymbolType, icons, types);
        } else if (type == PropertyBar.PROPERTY_LIST_NUMBER) {
            spanCount = 6;
            margin = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_16dp);

            int[] icons = {R.drawable.pb_ic_none, R.drawable.pb_number_library_1,
                    R.drawable.pb_number_library_2, R.drawable.pb_number_library_3,
                    R.drawable.pb_number_library_4, R.drawable.pb_number_library_5};
            int[] types = {NUMBER_STYLE_NONE, NUMBER_STYLE_1,
                    NUMBER_STYLE_2, NUMBER_STYLE_3,
                    NUMBER_STYLE_4, NUMBER_STYLE_5};
            itemInfos = getGridInfos(mNumberType, icons, types);
        } else if (type == PropertyBar.PROPERTY_ALIGNMENT) {
            spanCount = 4;
            margin = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_alignment_item_margin);

            int[] icons = {R.drawable.pb_align_left, R.drawable.pb_align_vertical,
                    R.drawable.pb_align_right, R.drawable.pb_align_center};
            int[] types = {ALIGN_LEFT, ALIGN_MID,
                    ALIGN_RIGHT, ALIGN_JUSTIFY};
            itemInfos = getGridInfos(mAlignmentType, icons, types);
        }

        View view = LayoutInflater.from(mContext).inflate(R.layout.common_recyclerview_layout, null, false);
        RecyclerView recyclerView = view.findViewById(R.id.rd_recyclerview_list);
        recyclerView.setMinimumHeight(AppResource.getDimensionPixelSize(mContext, R.dimen.ux_color_item_height));
        recyclerView.setHasFixedSize(true);
        recyclerView.setItemAnimator(new DefaultItemAnimator());
        GridLayoutManager gridLayoutManager = new GridLayoutManager(mContext, spanCount);
        recyclerView.setLayoutManager(gridLayoutManager);

        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) recyclerView.getLayoutParams();
        layoutParams.leftMargin = margin;
        layoutParams.rightMargin = margin;
        recyclerView.setLayoutParams(layoutParams);

        final ShapeGridListAdaper gridListAdaper = new ShapeGridListAdaper(mContext);
        gridListAdaper.setItemInfos(itemInfos);
        recyclerView.setAdapter(gridListAdaper);
        if (type == PropertyBar.PROPERTY_LIST_SYMBOL) {
            mSymbolListAdapter = gridListAdaper;
        } else if (type == PropertyBar.PROPERTY_LIST_NUMBER) {
            mNumberListAdapter = gridListAdaper;
        }
        gridListAdaper.setGridItemClickListener(new ShapeGridListAdaper.OnGridItemClickListener() {
            @Override
            public void onItemClick(int position, ShapeGridListAdaper.GridItemInfo itemInfo) {
                int value = itemInfo.type;
                if (type == PROPERTY_LIST_SYMBOL) {
                    mSymbolType = value;
                    mNumberType = NUMBER_STYLE_NONE;
                    if (mNumberListAdapter != null) {
                        List<ShapeGridListAdaper.GridItemInfo> infos = mNumberListAdapter.getGridItemInfos();
                        for (ShapeGridListAdaper.GridItemInfo info : infos) {
                            info.isChecked = false;
                        }
                        infos.get(0).isChecked = true;
                        mNumberListAdapter.notifyUpdateData();
                    }
                } else if (type == PROPERTY_LIST_NUMBER) {
                    mNumberType = value;
                    mSymbolType = SYMBOL_NONE;
                    if (mSymbolListAdapter != null) {
                        List<ShapeGridListAdaper.GridItemInfo> infos = mSymbolListAdapter.getGridItemInfos();
                        for (ShapeGridListAdaper.GridItemInfo info : infos) {
                            info.isChecked = false;
                        }
                        infos.get(0).isChecked = true;
                        mSymbolListAdapter.notifyUpdateData();
                    }
                } else if (type == PROPERTY_ALIGNMENT) {
                    mAlignmentType = value;
                }

                onValueChanged(type, value);
            }
        });

        int gridWidth;
        if (AppDisplay.isPad()) {
            gridWidth = mPadWidth;
        } else {
            View rootView = mUIExtensionsManager.getRootView();
            gridWidth = Math.min(rootView.getWidth(), rootView.getHeight());
        }
        int spaceWidth = (gridWidth - margin * 2 - AppDisplay.dp2px(32) * spanCount) / (spanCount * (spanCount - 1));
        recyclerView.addItemDecoration(new SpacesItemDecoration(spaceWidth, spanCount));

        // sub title
        String title = mCustomItemTitles.get(type);
        TextView subtitle_tv = (TextView) view.findViewById(R.id.pb_subtitle_tv);
        if (AppUtil.isEmpty(title)) {
            subtitle_tv.setVisibility(View.GONE);
        } else {
            subtitle_tv.setVisibility(View.VISIBLE);
            subtitle_tv.setText(title);
        }

        return view;
    }

    private static class SpacesItemDecoration extends RecyclerView.ItemDecoration {
        private final int column;
        private final int space;

        private SpacesItemDecoration(int space, int column) {
            this.space = space;
            this.column = column;
        }

        @Override
        public void getItemOffsets(@NonNull Rect outRect, @NonNull View view,
                                   @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            int mod = parent.getChildAdapterPosition(view) % column;
            outRect.left = space * mod;
        }
    }

    private List<ShapeGridListAdaper.GridItemInfo> getGridInfos(int curType, int[] icons, int[] types) {
        List<ShapeGridListAdaper.GridItemInfo> infos = new ArrayList<>();
        for (int i = 0; i < icons.length; i++) {
            ShapeGridListAdaper.GridItemInfo gridItemInfo = new ShapeGridListAdaper.GridItemInfo();
            gridItemInfo.iconId = icons[i];
            int type = types[i];
            gridItemInfo.type = type;
            gridItemInfo.isChecked = type == curType;
            infos.add(gridItemInfo);
        }
        return infos;
    }

    @Override
    public void requestLayout() {
        if (!AppDisplay.isPad()) {
            int w1 = View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED);
            int h1 = View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED);
            mRootView.measure(w1, h1);

            // move full screen to somewhere in selected annotation model.
            AnnotHandler currentAnnotHandler = mUIExtensionsManager.getCurrentAnnotHandler();
            if ((!AppDisplay.isPad())
                    && currentAnnotHandler != null
                    && mUIExtensionsManager.getCurrentToolHandler() == null) {
                ViewGroup viewGroup = mUIExtensionsManager.getRootView();
                int height = viewGroup.getHeight();
                int width = viewGroup.getWidth();

                mRootView.measure(w1, h1);
                if (mRectF.bottom > 0 && mRectF.bottom <= height) {
                    if (mRectF.bottom > height - mRootView.getMeasuredHeight()) {
                        offset = mRootView.getMeasuredHeight() - (height - mRectF.bottom);
                        mPdfViewCtrl.layout(0, -(int) offset, mPdfViewCtrl.getWidth(), mPdfViewCtrl.getHeight() - (int) offset);
                    }

                } else if (mRectF.top >= 0 && mRectF.top <= height && mRectF.bottom > height) {
                    if (mRectF.top > height - mRootView.getMeasuredHeight()) {
                        offset = mRootView.getMeasuredHeight() - (height - mRectF.top) + 10;
                        mPdfViewCtrl.layout(0, -(int) offset, mPdfViewCtrl.getWidth(), mPdfViewCtrl.getHeight() - (int) offset);
                    }
                }
            }
        }
    }

    @Override
    public void setShowOnKeyboard(boolean value) {
        mShowOnKeyboard = value;
        if (mActionMenu != null)
            mActionMenu.setShowOnKeyboard(mShowOnKeyboard);
    }

    @Override
    public void setDismissWithResetProperties(boolean reset) {
        mDismissWithReset = reset;
    }

    @Override
    public void setScrollingEnabled(boolean enabled) {
        if (mScrollEnabled != enabled) {
            mScrollEnabled = enabled;
            getActionPopup().setScrollingEnabled(mScrollEnabled);
        }
    }

    private View getPencilTypeView() {
        final View pencilTypeItem = LayoutInflater.from(mContext).inflate(R.layout.pb_pencil_type, null, false);
        final LinearLayout pb_ll_pencil_pen = pencilTypeItem.findViewById(R.id.pb_ll_pencil_type_pen);
        final ImageView ivPencilPen = pencilTypeItem.findViewById(R.id.pb_iv_pencil_type_pen);
        ThemeUtil.setTintList(ivPencilPen, ThemeUtil.getEnableIconColor(mContext));

        final LinearLayout pb_ll_pencil_brush = pencilTypeItem.findViewById(R.id.pb_ll_pencil_type_brush);
        final ImageView ivPencilBrush = pencilTypeItem.findViewById(R.id.pb_iv_pencil_type_brush);
        ThemeUtil.setTintList(ivPencilBrush, ThemeUtil.getEnableIconColor(mContext));
        if (mPencilType == InkConstants.PENCIL_WITH_PEN) {
            pb_ll_pencil_pen.setBackgroundResource(R.drawable.common_border_radius_4_rectangle);
            pb_ll_pencil_pen.getBackground().setColorFilter(new PorterDuffColorFilter(
                    ThemeConfig.getInstance(mContext).getPrimaryColor(), PorterDuff.Mode.SRC_IN));
            pb_ll_pencil_brush.setBackgroundResource(0);
        } else {
            pb_ll_pencil_brush.setBackgroundResource(R.drawable.common_border_radius_4_rectangle);
            pb_ll_pencil_brush.getBackground().setColorFilter(new PorterDuffColorFilter(
                    ThemeConfig.getInstance(mContext).getPrimaryColor(), PorterDuff.Mode.SRC_IN));
            pb_ll_pencil_pen.setBackgroundResource(0);
        }

        if (canEdit) {
            pb_ll_pencil_pen.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    pb_ll_pencil_pen.setBackgroundResource(R.drawable.common_border_radius_4_rectangle);
                    pb_ll_pencil_pen.getBackground().setColorFilter(new PorterDuffColorFilter(
                            ThemeConfig.getInstance(mContext).getPrimaryColor(), PorterDuff.Mode.SRC_IN));
                    pb_ll_pencil_brush.setBackgroundResource(0);
                    if (mPropertyChangeListener != null) {
                        mPencilType = InkConstants.PENCIL_WITH_PEN;
                        onValueChanged(PropertyBar.PROPERTY_PENCIL_TYPE, mPencilType);
                    }
                }
            });

            pb_ll_pencil_brush.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    pb_ll_pencil_brush.setBackgroundResource(R.drawable.common_border_radius_4_rectangle);
                    pb_ll_pencil_brush.getBackground().setColorFilter(new PorterDuffColorFilter(
                            ThemeConfig.getInstance(mContext).getPrimaryColor(), PorterDuff.Mode.SRC_IN));
                    pb_ll_pencil_pen.setBackgroundResource(0);
                    if (mPropertyChangeListener != null) {
                        mPencilType = InkConstants.PENCIL_WITH_BRUSH;
                        onValueChanged(PropertyBar.PROPERTY_PENCIL_TYPE, mPencilType);
                    }
                }
            });
        } else {
            pencilTypeItem.setAlpha(PB_ALPHA);
        }
        return pencilTypeItem;
    }

    private View getEraserShapeView() {
        final View eraserShapeItem = LayoutInflater.from(mContext).inflate(R.layout.pb_eraser_type, null, false);
        final LinearLayout pb_ll_eraser_type_whole = eraserShapeItem.findViewById(R.id.pb_ll_eraser_type_whole);
        final ImageView ivEraserWhole = eraserShapeItem.findViewById(R.id.pb_iv_eraser_type_whole);
        ThemeUtil.setTintList(ivEraserWhole, ThemeUtil.getEnableIconColor(mContext));

        final LinearLayout pb_ll_eraserI_type_partial = eraserShapeItem.findViewById(R.id.pb_ll_eraser_type_partial);
        final ImageView ivEraserPartial = eraserShapeItem.findViewById(R.id.pb_iv_eraser_type_partial);
        ThemeUtil.setTintList(ivEraserPartial, ThemeUtil.getEnableIconColor(mContext));

        if (mEraserShape == InkConstants.ERASER_SHAPE_WHOLE) {
            pb_ll_eraser_type_whole.setBackgroundResource(R.drawable.common_border_radius_4_rectangle);
            pb_ll_eraser_type_whole.getBackground().setColorFilter(new PorterDuffColorFilter(
                    ThemeConfig.getInstance(mContext).getPrimaryColor(), PorterDuff.Mode.SRC_IN));
            pb_ll_eraserI_type_partial.setBackgroundResource(0);
        } else {
            pb_ll_eraserI_type_partial.setBackgroundResource(R.drawable.common_border_radius_4_rectangle);
            pb_ll_eraserI_type_partial.getBackground().setColorFilter(new PorterDuffColorFilter(
                    ThemeConfig.getInstance(mContext).getPrimaryColor(), PorterDuff.Mode.SRC_IN));
            pb_ll_eraser_type_whole.setBackgroundResource(0);
        }

        if (canEdit) {
            pb_ll_eraser_type_whole.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    pb_ll_eraser_type_whole.setBackgroundResource(R.drawable.common_border_radius_4_rectangle);
                    pb_ll_eraser_type_whole.getBackground().setColorFilter(new PorterDuffColorFilter(
                            ThemeConfig.getInstance(mContext).getPrimaryColor(), PorterDuff.Mode.SRC_IN));
                    pb_ll_eraserI_type_partial.setBackgroundResource(0);
                    if (mPropertyChangeListener != null) {
                        mEraserShape = InkConstants.ERASER_SHAPE_WHOLE;
                        onValueChanged(PropertyBar.PROPERTY_ERASERSHAPE, mEraserShape);
                    }
                }
            });

            pb_ll_eraserI_type_partial.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    pb_ll_eraserI_type_partial.setBackgroundResource(R.drawable.common_border_radius_4_rectangle);
                    pb_ll_eraserI_type_partial.getBackground().setColorFilter(new PorterDuffColorFilter(
                            ThemeConfig.getInstance(mContext).getPrimaryColor(), PorterDuff.Mode.SRC_IN));
                    pb_ll_eraser_type_whole.setBackgroundResource(0);
                    if (mPropertyChangeListener != null) {
                        mEraserShape = InkConstants.ERASER_SHAPE_PARTIAL;
                        onValueChanged(PropertyBar.PROPERTY_ERASERSHAPE, mEraserShape);
                    }
                }
            });
        } else {
            eraserShapeItem.setAlpha(PB_ALPHA);
        }
        return eraserShapeItem;
    }

    private View getRotationView() {
        final View rotationItem = LayoutInflater.from(mContext).inflate(R.layout.pb_rotation, null, false);

        final LinearLayout pb_ll_rotate = rotationItem.findViewById(R.id.pb_ll_rotation);
        for (int i = 0; i < pb_ll_rotate.getChildCount(); i++) {
            if (i % 2 != 0) {
                TextView pb_rotate_tv = (TextView) pb_ll_rotate.getChildAt(i);
                pb_rotate_tv.setBackgroundResource(R.drawable.common_border_radius_4_rectangle);
                pb_rotate_tv.setTag(i);
                if (canEdit) {
                    pb_rotate_tv.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            int tag = Integer.parseInt(v.getTag().toString());

                            for (int j = 0; j < pb_ll_rotate.getChildCount(); j++) {
                                if (j % 2 != 0) {
                                    TextView pb_rotate_tv = (TextView) pb_ll_rotate.getChildAt(j);
                                    if (j == tag) {
                                        pb_rotate_tv.getBackground().setColorFilter(new PorterDuffColorFilter(
                                                ThemeConfig.getInstance(mContext).getPrimaryColor(), PorterDuff.Mode.SRC_IN));
                                    } else {
                                        pb_rotate_tv.getBackground().setColorFilter(new PorterDuffColorFilter(
                                                AppResource.getColor(mContext, R.color.p2), PorterDuff.Mode.SRC_IN));
                                    }
                                }
                            }
                            if (mPropertyChangeListener != null) {
                                mRotation = mRotations[(tag + 1) / 2 - 1];
                                onValueChanged(PropertyBar.PROPERTY_ROTATION, mRotation);
                            }
                        }
                    });
                } else {
                    pb_rotate_tv.setEnabled(false);
                }

                if (mRotation == mRotations[(i + 1) / 2 - 1]) {
                    pb_rotate_tv.getBackground().setColorFilter(new PorterDuffColorFilter(
                            ThemeConfig.getInstance(mContext).getPrimaryColor(), PorterDuff.Mode.SRC_IN));
                } else {
                    pb_rotate_tv.getBackground().setColorFilter(new PorterDuffColorFilter(
                            AppResource.getColor(mContext, R.color.p2), PorterDuff.Mode.SRC_IN));
                }
            }
        }

        if (!canEdit) {
            rotationItem.setAlpha(PB_ALPHA);
        }
        return rotationItem;
    }

    private ColorView mColorView;

    private View getColorView(final long type) {
        final int color = type == PROPERTY_COLOR ? mColor : mFillColor;
        if (type == PropertyBar.PROPERTY_COLOR) {
            mColorView = new ColorView(mContext, this, mUIExtensionsManager.getRootView(), color, mColors, canEdit);
        } else {
            mColorView = new ColorView(mContext, this, mUIExtensionsManager.getRootView(), color, mFillColors, canEdit);
        }

        if (mCustomItemTitles.get(type) != null) {
            mColorView.setTitle(mCustomItemTitles.get(type));
        }

        mColorView.setPropertyChangeListener(new PropertyChangeListener() {
            @Override
            public void onValueChanged(long property, int value) {
                if (type == PROPERTY_COLOR) {
                    mColor = value;
                    if ((mSupportProperty & PropertyBar.PROPERTY_LINEWIDTH) == PropertyBar.PROPERTY_LINEWIDTH) {
                        if (mThicknessImage != null)
                            mThicknessImage.setColor(mColor);
                    }

                    if ((mSupportProperty & PropertyBar.PROPERTY_OPACITY) == PropertyBar.PROPERTY_OPACITY) {
                        if (mPBLlOpacity != null) {
                            for (int i = 0; i < mPBLlOpacity.getChildCount(); i++) {
                                LinearLayout ll_opacity_item = (LinearLayout) ((LinearLayout) mPBLlOpacity.getChildAt(i)).getChildAt(0);
                                ImageView iv_opacity_item = (ImageView) ll_opacity_item.getChildAt(0);
                                iv_opacity_item.setColorFilter(value);
                            }
                        }
                    }

                    PropertyBarImpl.this.onValueChanged(property, value);
                    if (mCustomChangeListener != null)
                        mCustomChangeListener.onValueChanged(property, value);
                } else {
                    mFillColor = value;

                    PropertyBarImpl.this.onValueChanged(type, value);
                    if (mCustomChangeListener != null)
                        mCustomChangeListener.onValueChanged(type, value);
                }
            }

            @Override
            public void onValueChanged(long property, float value) {
            }

            @Override
            public void onValueChanged(long property, String value) {
            }

        });
        if (!canEdit) {
            mColorView.setAlpha(PropertyBar.PB_ALPHA);
        }
        return mColorView;
    }

    @Override
    public void reset(final long items) {
        mSupportProperty = items;
        if (mClearCustomProperty) {
            mCustomProperty = 0;
            mCurrentTab = 0;
            mCustomTabList.clear();
            mCustomItemList.clear();
        }

        map_type_name_views.clear();
        mTabs.clear();
        mTopTabItemsLl.removeAllViews();
        mTopTabSelectLl.removeAllViews();
        for (int i = 0; i < mTabContentLl.getChildCount(); i++) {
            ViewGroup tabContent = (ViewGroup) mTabContentLl.getChildAt(i);
            tabContent.removeAllViews();
        }
        mTabContentLl.removeAllViews();

        if (items == PropertyBar.PROPERTY_UNKNOWN) {
//            mTopSubTitleLl.setVisibility(View.GONE);
            mTopTabRootLl.setVisibility(View.GONE);
        } else {
//            mTopSubTitleLl.setVisibility(mSubTitleVisiable ? View.VISIBLE : View.GONE);
            mTopTabRootLl.setVisibility(View.VISIBLE);
            resetSupportedView();
        }

        if (!mClearCustomProperty) {
            if (mCustomProperty != 0) {
                resetCustomView();
            }
            mClearCustomProperty = true;
        }
    }

    @Override
    public void reset(long items, boolean clearCustomProperty) {
        mClearCustomProperty = clearCustomProperty;
        if (mPenRealWidth > 0) {
            mLinewith = mPenRealWidth;
        }
        reset(items);
    }

    @Override
    public long getProperties() {
        if (mShowShapelistView)
            return mShowShapeListType;
        else
            return mSupportProperty;
    }

    @Override
    public void setTitleVisible(boolean visible) {
        if (visible) {
            if (mTitleItem == null)
                initTitleView();
            mTopTitleLl.setVisibility(View.VISIBLE);
        } else {
            mTopTitleLl.setVisibility(View.GONE);
        }
    }

    @Override
    public void setSubTitleVisible(boolean visible) {
//        mSubTitleVisiable = visible;
//        if (visible) {
//            mTopSubTitleLl.setVisibility(View.VISIBLE);
//        } else {
//            mTopSubTitleLl.setVisibility(View.GONE);
//        }
    }

    private void resetSupportedView() {
        if ((mSupportProperty & PropertyBar.PROPERTY_FONTNAME) == PropertyBar.PROPERTY_FONTNAME
                || (mSupportProperty & PropertyBar.PROPERTY_FONTSIZE) == PropertyBar.PROPERTY_FONTSIZE
                || (mSupportProperty & PropertyBar.PROPERTY_FONTSIZE_2) == PropertyBar.PROPERTY_FONTSIZE_2
                || (mSupportProperty & PropertyBar.PROPERTY_AUTO_FONTSIZE) == PropertyBar.PROPERTY_AUTO_FONTSIZE
                || (mSupportProperty & PropertyBar.PROPERTY_LINEWIDTH) == PropertyBar.PROPERTY_LINEWIDTH
                || (mSupportProperty & PropertyBar.PROPERTY_LINEWIDTH_2) == PropertyBar.PROPERTY_LINEWIDTH_2
                || (mSupportProperty & PropertyBar.PROPERTY_COLOR) == PropertyBar.PROPERTY_COLOR
                || (mSupportProperty & PropertyBar.PROPERTY_OPACITY) == PropertyBar.PROPERTY_OPACITY
                || (mSupportProperty & PropertyBar.PROPERTY_ROTATION) == PropertyBar.PROPERTY_ROTATION
                || (mSupportProperty & PropertyBar.PROPERTY_SCALE_PERCENT) == PropertyBar.PROPERTY_SCALE_PERCENT
                || (mSupportProperty & PropertyBar.PROPERTY_SCALE_SWITCH) == PropertyBar.PROPERTY_SCALE_SWITCH
                || (mSupportProperty & PropertyBar.PROPERTY_RADIO_NAME) == PropertyBar.PROPERTY_RADIO_NAME
                || (mSupportProperty & PropertyBar.PROPERTY_FONTNAME_LIST) == PropertyBar.PROPERTY_FONTNAME_LIST
                || (mSupportProperty & PropertyBar.PROPERTY_FONTSIZE_LIST) == PropertyBar.PROPERTY_FONTSIZE_LIST) {
            String propertyTabTitle = "";
            mShowShapelistView = false;

            if ((mSupportProperty & PropertyBar.PROPERTY_RADIO_NAME) == PropertyBar.PROPERTY_RADIO_NAME
                    || (mSupportProperty & PropertyBar.PROPERTY_OVERLAY_TEXT) == PropertyBar.PROPERTY_OVERLAY_TEXT) {
                propertyTabTitle = mSupportTabNames[5];
            } else if ((mSupportProperty & PropertyBar.PROPERTY_FONTNAME) == PropertyBar.PROPERTY_FONTNAME
                    || (mSupportProperty & PropertyBar.PROPERTY_FONTSIZE) == PropertyBar.PROPERTY_FONTSIZE
                    || (mSupportProperty & PropertyBar.PROPERTY_FONTSIZE_2) == PropertyBar.PROPERTY_FONTSIZE_2
                    || (mSupportProperty & PropertyBar.PROPERTY_AUTO_FONTSIZE) == PropertyBar.PROPERTY_AUTO_FONTSIZE
                    || (mSupportProperty & PropertyBar.PROPERTY_DISTANCE) == PropertyBar.PROPERTY_DISTANCE
                    || (mSupportProperty & PropertyBar.PROPERTY_DISTANCE_DISPLAY) == PropertyBar.PROPERTY_DISTANCE_DISPLAY) {
                propertyTabTitle = mSupportTabNames[3];
            } else if ((mSupportProperty & PropertyBar.PROPERTY_LINEWIDTH) == PropertyBar.PROPERTY_LINEWIDTH
                    || (mSupportProperty & PropertyBar.PROPERTY_LINE_STYLE) == PropertyBar.PROPERTY_LINE_STYLE) {
                propertyTabTitle = mSupportTabNames[2];
            } else if ((mSupportProperty & PropertyBar.PROPERTY_SCALE_PERCENT) == PropertyBar.PROPERTY_SCALE_PERCENT
                    || (mSupportProperty & PropertyBar.PROPERTY_SCALE_SWITCH) == PropertyBar.PROPERTY_SCALE_SWITCH) {
                propertyTabTitle = mSupportTabNames[4];
            } else {
                propertyTabTitle = mSupportTabNames[1];
            }

            int propertyTabIndex = mTabs.size();
            addTab(propertyTabTitle, propertyTabIndex);

            if (mSupportProperty == PropertyBar.PROPERTY_ERASERSHAPE) { //suyu
                addCustomItem(0, getEraserShapeView(), propertyTabIndex, -1);
                addCustomItem(0, getLineWidthView(PROPERTY_LINEWIDTH_2), propertyTabIndex, -1);
                return;
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_SCALE_PERCENT) == PropertyBar.PROPERTY_SCALE_PERCENT
                    || (mSupportProperty & PropertyBar.PROPERTY_SCALE_SWITCH) == PropertyBar.PROPERTY_SCALE_SWITCH) {
                addCustomItem(0, getScaleView(), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_DISTANCE) == PropertyBar.PROPERTY_DISTANCE) {
                addCustomItem(0, getDistanceUnitSettingView(), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_DISTANCE_DISPLAY) == PropertyBar.PROPERTY_DISTANCE_DISPLAY) {
                addCustomItem(0, getDistanceUnitDisplayView(), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_PENCIL_TYPE) == PropertyBar.PROPERTY_PENCIL_TYPE) {
                addCustomItem(0, getPencilTypeView(), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_COLOR) == PropertyBar.PROPERTY_COLOR) {
                View colorView;
                colorView = getColorView(PROPERTY_COLOR);
                addCustomItem(0, colorView, propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_LINEWIDTH) == PropertyBar.PROPERTY_LINEWIDTH ||
                    (mSupportProperty & PropertyBar.PROPERTY_LINEWIDTH_2) == PropertyBar.PROPERTY_LINEWIDTH_2) {
                long type;
                if ((mSupportProperty & PropertyBar.PROPERTY_LINEWIDTH) == PropertyBar.PROPERTY_LINEWIDTH)
                    type = PropertyBar.PROPERTY_LINEWIDTH;
                else
                    type = PropertyBar.PROPERTY_LINEWIDTH_2;
                addCustomItem(0, getLineWidthView(type), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_LINE_STYLE) == PropertyBar.PROPERTY_LINE_STYLE) {
                addCustomItem(0, getLineStyleView(), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_FILL_COLOR) == PropertyBar.PROPERTY_FILL_COLOR) {
                View colorView;
                colorView = getColorView(PROPERTY_FILL_COLOR);
                addCustomItem(0, colorView, propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_ROTATION) == PropertyBar.PROPERTY_ROTATION) {
                addCustomItem(0, getRotationView(), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_OPACITY) == PropertyBar.PROPERTY_OPACITY) {
                addCustomItem(0, getOpacityView(), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_LIST_SYMBOL) == PropertyBar.PROPERTY_LIST_SYMBOL) {
                addCustomItem(0, getGridView(PropertyBar.PROPERTY_LIST_SYMBOL), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_LIST_NUMBER) == PropertyBar.PROPERTY_LIST_NUMBER) {
                addCustomItem(0, getGridView(PROPERTY_LIST_NUMBER), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_ALIGNMENT) == PropertyBar.PROPERTY_ALIGNMENT) {
                addCustomItem(0, getGridView(PROPERTY_ALIGNMENT), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_OVERLAY_TEXT) == PropertyBar.PROPERTY_OVERLAY_TEXT) {
                addCustomItem(0, getShapeView(PROPERTY_OVERLAY_TEXT), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_RADIO_NAME) == PropertyBar.PROPERTY_RADIO_NAME) {
                addCustomItem(0, getShapeView(PROPERTY_RADIO_NAME), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_FONTSTYLE) == PropertyBar.PROPERTY_FONTSTYLE) {
                addCustomItem(0, getFontStyleView(), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_FONTNAME) == PropertyBar.PROPERTY_FONTNAME) {
                addCustomItem(0, getShapeView(PropertyBar.PROPERTY_FONTNAME), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_FONTNAME_2) == PropertyBar.PROPERTY_FONTNAME_2) {
                addCustomItem(0, getShapeView(PropertyBar.PROPERTY_FONTNAME_2), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_AUTO_FONTSIZE) == PropertyBar.PROPERTY_AUTO_FONTSIZE) {
                addCustomItem(0, getFontSizeView(PROPERTY_AUTO_FONTSIZE), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_FONTSIZE) == PropertyBar.PROPERTY_FONTSIZE) {
                addCustomItem(0, getFontSizeView(PROPERTY_FONTSIZE), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_FONTSIZE_2) == PropertyBar.PROPERTY_FONTSIZE_2) {
                addCustomItem(0, getFontSizeView(PROPERTY_FONTSIZE_2), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_ANNOT_TYPE) == PropertyBar.PROPERTY_ANNOT_TYPE) {
                addCustomItem(0, getShapeView(PropertyBar.PROPERTY_ANNOT_TYPE), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_FILEATTACHMENT) == PropertyBar.PROPERTY_FILEATTACHMENT) {
                addCustomItem(0, getShapeView(PropertyBar.PROPERTY_FILEATTACHMENT), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_FONTNAME_LIST) == PropertyBar.PROPERTY_FONTNAME_LIST) {
                mShowShapelistView = true;
                addCustomItem(0, getSubListView(PropertyBar.PROPERTY_FONTNAME_LIST), propertyTabIndex, -1);
            }

            if ((mSupportProperty & PropertyBar.PROPERTY_FONTSIZE_LIST) == PropertyBar.PROPERTY_FONTSIZE_LIST) {
                mShowShapelistView = true;
                addCustomItem(0, getSubListView(PropertyBar.PROPERTY_FONTSIZE_LIST), propertyTabIndex, -1);
            }
        }
    }

    private void resetCustomView() {
        for (int i = 0; i < mCustomTabList.size(); i++) {
            addTab(mCustomTabList.get(i).get("topTitle").toString(), (Integer) mCustomTabList.get(i).get("resid_img"),
                    mCustomTabList.get(i).get("title").toString(), (Integer) mCustomTabList.get(i).get("tabIndex"));
        }
        for (int i = 0; i < mCustomItemList.size(); i++) {
            long item = (Long) mCustomItemList.get(i).get("item");
            if ((item & mCustomProperty) == item) {
                addCustomItem(item, (View) mCustomItemList.get(i).get("itemView"), (Integer) mCustomItemList.get(i).get("tabIndex"),
                        (Integer) mCustomItemList.get(i).get("index"));
            }
        }
    }

    private void doAfterAddContentItem() {
        for (int i = 0; i < mTabContentLl.getChildCount(); i++) {
            LinearLayout tabContentTemp = (LinearLayout) mTabContentLl.getChildAt(i);
            if (tabContentTemp != null && tabContentTemp.getChildCount() > 0) {
                for (int j = 0; j < tabContentTemp.getChildCount(); j++) {
                    View viewItem = tabContentTemp.getChildAt(j);
                    if (viewItem != null) {
                        View separator = viewItem.findViewById(R.id.pb_separator_iv);
                        if (separator != null) {
                            if (j == tabContentTemp.getChildCount() - 1) {
                                separator.setVisibility(View.GONE);
                            } else {
                                separator.setVisibility(View.VISIBLE);
                            }
                        }
                    }
                }
            }
        }

        resetContentHeight();

        for (int i = 0; i < mTabContentLl.getChildCount(); i++) {
            if (i == mCurrentTab) {
                mTabContentLl.getChildAt(i).setVisibility(View.VISIBLE);
            } else {
                mTabContentLl.getChildAt(i).setVisibility(View.GONE);
            }
        }
    }

    @Override
    public void resetContentHeight() {
        if (mShowShapelistView) {
            int margin = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_8dp);
            int titleHeight = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_pb_title_height);
            int contentHeight = 0;
            Point point = measureAdapterSize(mPBShapeListView);
            if (point != null)
                contentHeight = point.y;
            int _contentHeight = margin + titleHeight + contentHeight;
            int maxHeight;
            if (AppDisplay.isPad()) {
                if (mMaxHeight > 0) {
                    maxHeight = Math.min(mMaxHeight, mUIExtensionsManager.getRootView().getHeight() / 2);
                } else {
                    maxHeight = mUIExtensionsManager.getRootView().getHeight() / 2;
                }
            } else {
                if (mMaxHeight > 0) {
                    maxHeight = mMaxHeight;
                } else {
                    maxHeight = mUIExtensionsManager.getRootView().getHeight()
                            - AppResource.getDimensionPixelSize(mContext, R.dimen.ux_topbar_height)
                            - mActionMenu.getSliderHeight();
                }
            }
            int height = Math.min(maxHeight, _contentHeight);
            ViewGroup.LayoutParams layoutParams = mTabContentLl.getLayoutParams();
            layoutParams.height = height;
            mTabContentLl.setLayoutParams(layoutParams);
        } else {
            int maxTabContentHeight = 0;
            int w = View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED);
            int h = View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED);
            int iconTabIndex = -1;
            if (mTabs.contains(mSupportTabNames[0])) {
                iconTabIndex = mTabs.indexOf(mSupportTabNames[0]);
            }
            for (int i = 0; i < mTabContentLl.getChildCount(); i++) {
                LinearLayout child = (LinearLayout) mTabContentLl.getChildAt(i);
                child.measure(w, h);
                int childHeight = child.getMeasuredHeight();
                if (i == iconTabIndex) {
                    childHeight = 0;
                }
                if (childHeight > maxTabContentHeight) {
                    maxTabContentHeight = childHeight;
                }
            }

            ViewGroup.LayoutParams layoutParams = mTabContentLl.getLayoutParams();
            if (layoutParams.height != ViewGroup.LayoutParams.MATCH_PARENT) {
                layoutParams.height = maxTabContentHeight;
                mTabContentLl.setLayoutParams(layoutParams);
            }
        }
    }

    @Override
    public void setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
        mOnKeyListener = onKeyListener;
    }

    @Override
    public void setOnShowListener(IOnShowListener showListener) {
        mOnShowListener = showListener;
    }

    @Override
    public Object getTag() {
        return mTag;
    }

    @Override
    public void setTag(Object tag) {
        mTag = tag;
    }

    @Override
    public void addTab(String title, int tabIndex) {
        if (tabIndex > mTabs.size() || tabIndex < 0)
            return;
        if (title.length() == 0) {
            mTabs.add(tabIndex, "");
        } else {
            mTabs.add(tabIndex, title);
        }

        TextView tv_title = new TextView(mContext);
        tv_title.setLayoutParams(new LinearLayout.LayoutParams(0, LinearLayout.LayoutParams.WRAP_CONTENT, 1));
        tv_title.setText(title);
        tv_title.setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimension(mContext, R.dimen.ux_text_size_12sp));
        tv_title.setTextColor(mContext.getResources().getColor(R.color.t4));
        tv_title.setTypeface(Typeface.DEFAULT);
        tv_title.setGravity(Gravity.CENTER);
        tv_title.setSingleLine(true);
        tv_title.setEllipsize(TextUtils.TruncateAt.END);
        tv_title.setPadding(0, AppDisplay.dp2px(5.0f), 0, AppDisplay.dp2px(10.0f));

        tv_title.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int clickTagIndex = 0;
                for (int i = 0; i < mTopTabItemsLl.getChildCount(); i++) {
                    if (v == mTopTabItemsLl.getChildAt(i)) {
                        clickTagIndex = i;
                        break;
                    }
                }

                if (mCurrentTab != clickTagIndex) {
                    mCurrentTab = clickTagIndex;
                    setCurrentTab(mCurrentTab);
                }
            }
        });
        mTopTabItemsLl.addView(tv_title, tabIndex);

        ImageView iv_title_checked = new ImageView(mContext);
        iv_title_checked.setLayoutParams(new LinearLayout.LayoutParams(0, LinearLayout.LayoutParams.MATCH_PARENT, 1));
        mTopTabSelectLl.addView(iv_title_checked, tabIndex);

        LinearLayout ll_content = new LinearLayout(mContext);
        ll_content.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT));
        ll_content.setOrientation(LinearLayout.VERTICAL);
        mTabContentLl.addView(ll_content, tabIndex);

        if (mTabs.size() + mCustomTabList.size() > 0) {
            if (mTabs.size() + mCustomTabList.size() == 1) {
                mTopTabRootLl.setVisibility(View.GONE);
            } else {
                mTopTabRootLl.setVisibility(View.VISIBLE);
                setCurrentTab(mCurrentTab);
            }
        }
    }

    @Override
    public void addTab(String topTitle, int tabIcon, String tabText, int tabIndex) {
        if (tabIndex > mTabs.size() + mCustomTabList.size() || tabIndex < 0) {
            return;
        }

        if (mClearCustomProperty) {
            Map<String, Object> map = new HashMap<String, Object>();
            if (topTitle.isEmpty()) {
                map.put("topTitle", "");
            } else {
                map.put("topTitle", topTitle);
            }
            if (tabText.isEmpty()) {
                map.put("title", "");
            } else {
                map.put("title", tabText);
            }
            map.put("resid_img", tabIcon);
            map.put("tabIndex", tabIndex);
            mCustomTabList.add(map);
        }

        LinearLayout titleLayout = new LinearLayout(mContext);
        titleLayout.setLayoutParams(new LinearLayout.LayoutParams(0, LinearLayout.LayoutParams.WRAP_CONTENT, 1));
        titleLayout.setGravity(Gravity.CENTER);
        titleLayout.setOrientation(LinearLayout.HORIZONTAL);
        titleLayout.setPadding(0, AppDisplay.dp2px(5.0f), 0, AppDisplay.dp2px(10.0f));
        titleLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int clickTagIndex = 0;
                for (int i = 0; i < mTopTabItemsLl.getChildCount(); i++) {
                    if (v == mTopTabItemsLl.getChildAt(i)) {
                        clickTagIndex = i;
                        break;
                    }
                }

                if (mCurrentTab != clickTagIndex) {
                    setCurrentTab(clickTagIndex);
                }
            }
        });

        if (tabIcon > 0) {
            ImageView img = new ImageView(mContext);
            img.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT));
            img.setImageResource(tabIcon);
            ThemeUtil.setTintList(img, ThemeUtil.getPrimaryIconColor(mContext));
            titleLayout.addView(img);
        }
        if (tabText != null && !"".equals(tabText)) {
            TextView tv_title = new TextView(mContext);
            tv_title.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT));
            tv_title.setText(tabText);
            tv_title.setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimension(mContext, R.dimen.ux_text_size_12sp));
            tv_title.setTextColor(mContext.getResources().getColor(R.color.t4));
            tv_title.setGravity(Gravity.CENTER);
            tv_title.setSingleLine(true);
            tv_title.setEllipsize(TextUtils.TruncateAt.END);
            titleLayout.addView(tv_title);
        }
        mTopTabItemsLl.addView(titleLayout, tabIndex);

        ImageView iv_title_checked = new ImageView(mContext);
        iv_title_checked.setLayoutParams(new LinearLayout.LayoutParams(0, LinearLayout.LayoutParams.MATCH_PARENT, 1));
        mTopTabSelectLl.addView(iv_title_checked, tabIndex);

        LinearLayout ll_content = new LinearLayout(mContext);
        ll_content.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT));
        ll_content.setOrientation(LinearLayout.VERTICAL);
        mTabContentLl.addView(ll_content, tabIndex);

        if (mTabs.size() + mCustomTabList.size() > 0) {
            if (mTabs.size() + mCustomTabList.size() == 1) {
                mTopTabRootLl.setVisibility(View.GONE);
            } else {
                mTopTabRootLl.setVisibility(View.VISIBLE);
                setCurrentTab(mCurrentTab);
            }
        }
    }

    @Override
    public int getCurrentTabIndex() {
        return mCurrentTab;
    }

    @Override
    public void setCurrentTab(int currentTab) {
        mCurrentTab = currentTab;
        for (int i = 0; i < mTopTabItemsLl.getChildCount(); i++) {
            if (i == currentTab) {
                View viewTab = mTopTabItemsLl.getChildAt(i);
                if (viewTab instanceof TextView) {
                    mTopTitleLl.setVisibility(View.GONE);
                } else if (viewTab instanceof LinearLayout) {
                    if (mTopTitleLl.getVisibility() == View.VISIBLE) {
                        String topTitle = "";
                        for (int j = 0; j < mCustomTabList.size(); j++) {
                            if (currentTab == (Integer) mCustomTabList.get(j).get("tabIndex")) {
                                topTitle = mCustomTabList.get(j).get("topTitle").toString();
                                break;
                            }
                        }
                        mTitleItem.setText(topTitle);
                    }

                    View view = ((LinearLayout) viewTab).getChildAt(0);
                    if (view instanceof ImageView) {
                        ((ImageView) view).setImageState(new int[]{android.R.attr.state_selected}, true);
                        ((ImageView) view).setSelected(true);
                    }
                }

                mTabContentLl.getChildAt(i).setVisibility(View.VISIBLE);
                mTopTabSelectLl.getChildAt(i).setBackgroundColor(ThemeConfig.getInstance(mContext).getPrimaryColor());
            } else {
                View viewTab = mTopTabItemsLl.getChildAt(i);
                if (viewTab instanceof LinearLayout) {
                    View view = ((LinearLayout) mTopTabItemsLl.getChildAt(i)).getChildAt(0);
                    if (view != null && view instanceof ImageView) {
                        ((ImageView) view).setImageState(new int[]{}, true);
                        ((ImageView) view).setSelected(false);
                    }
                } else if (viewTab instanceof TextView) {

                }
                mTabContentLl.getChildAt(i).setVisibility(View.GONE);
                mTopTabSelectLl.getChildAt(i).setBackgroundColor(AppResource.getColor(mContext, R.color.p1));
            }
        }
    }

    @Override
    public int getItemIndex(long item) {
        int indexItemInTab = -1;
        if ((mSupportProperty & item) == item) {
            if (mTabs.contains(mSupportTabNames[0])) {
                indexItemInTab = mTabs.indexOf(mSupportTabNames[0]);
            }
            if (mTabs.contains(mSupportTabNames[1])) {
                indexItemInTab = mTabs.indexOf(mSupportTabNames[1]);
            }
            if (mTabs.contains(mSupportTabNames[2])) {
                indexItemInTab = mTabs.indexOf(mSupportTabNames[2]);
            }
            if (mTabs.contains(mSupportTabNames[3])) {
                indexItemInTab = mTabs.indexOf(mSupportTabNames[3]);
            }
            if (mTabs.contains(mSupportTabNames[4])) {
                indexItemInTab = mTabs.indexOf(mSupportTabNames[4]);
            }
        } else {
            if ((mCustomProperty & item) == item) {
                for (int i = 0; i < mCustomItemList.size(); i++) {
                    if (item == (Long) mCustomItemList.get(i).get("item")) {
                        indexItemInTab = (Integer) mCustomItemList.get(i).get("tabIndex");
                        break;
                    }
                }
            }
        }

        return indexItemInTab;
    }

    @Override
    public void addCustomItem(long item, View itemView, int tabIndex, int index) {
        if (itemView == null) {
            return;
        }
        if (tabIndex < 0 || tabIndex > mTabContentLl.getChildCount() - 1) {
            return;
        }
        View view = mTabContentLl.getChildAt(tabIndex);
        if (view != null) {
            LinearLayout ll_content = (LinearLayout) view;
            if (index != -1 && (index < 0 || index > ll_content.getChildCount())) {
                return;
            }

            if (item > 0 && mClearCustomProperty) {
                mCustomProperty = mCustomProperty | item;
                Map<String, Object> map = new HashMap<String, Object>();
                map.put("item", item);
                map.put("itemView", itemView);
                map.put("tabIndex", tabIndex);
                map.put("index", index);
                mCustomItemList.add(map);
            }

            ViewGroup itemParent = (ViewGroup) itemView.getParent();
            if (itemParent != null) {
                itemParent.removeView(itemView);
            }

            if (index == -1) {
                ll_content.addView(itemView);
            } else {
                if (index > ll_content.getChildCount()) {
                    return;
                }
                ll_content.addView(itemView, index);
            }
        }
        doAfterAddContentItem();
    }

    @Override
    public void addContentView(View contentView) {
        mTabContentLl.addView(contentView);
    }

    @Override
    public LinearLayout getContentView() {
        return mTabContentLl;
    }

    @Override
    public ViewGroup getRootView() {
        return mRootView;
    }

    @Override
    public boolean isShowing() {
        if (isFullScreen && mFullScreenFragment != null)
            return mFullScreenFragment.isShowing();

        if (mActionMenu != null)
            return getActionPopup().isShowing();
        return false;
    }

    @Override
    public void show(RectF rectF, boolean showMask) {
        show(rectF, showMask, UIPopoverFrag.ARROW_AUTO);
    }

    @Override
    public void show(RectF rectF, boolean showMask, int arrowPosition) {
        show(mUIExtensionsManager.getRootView(), rectF, showMask, arrowPosition);
    }

    @Override
    public void show(ViewGroup anchor, RectF rectF, boolean showMask) {
        show(anchor, rectF, showMask, UIPopoverFrag.ARROW_AUTO);
    }

    @Override
    public void show(ViewGroup anchor, RectF rectF, boolean showMask, int arrowPosition) {
        showNavigationBar();
        if (isShowing()) {
            return;
        }
        mAnchor = anchor;
        mRectF.set(rectF);
        mShowMask = showMask;
        mArrowPosition = arrowPosition;

        int parentWidth = anchor.getWidth();
        int parentHeight = anchor.getHeight();
        int width = parentWidth;
        if (AppDisplay.isPad()) {
            width = mPadWidth;
        } else if (AppDisplay.isLandscape()) {
            width = Math.min(parentWidth, parentHeight);
        }
        mPbBarView.setBackgroundColor(AppResource.getColor(mContext, R.color.ux_color_popwnd_background));

        if (isFullScreen) {
            AppUtil.removeViewFromParent(mPbBarView);
            mTabContentLl.getLayoutParams().height = ViewGroup.LayoutParams.MATCH_PARENT;
            initFullScreenFragment();
            mFullScreenFragment.showAtLocation(anchor, Gravity.CENTER | Gravity.BOTTOM, 0, 0);
        } else {
            if (mPbBarView.getParent() != mRootView) {
                AppUtil.removeViewFromParent(mPbBarView);
                mRootView.addView(mPbBarView, new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT));
                mTabContentLl.getLayoutParams().height = ViewGroup.LayoutParams.WRAP_CONTENT;
            }
            mPbBarView.measure(View.MeasureSpec.makeMeasureSpec(width, View.MeasureSpec.EXACTLY),
                    View.MeasureSpec.makeMeasureSpec(parentHeight, View.MeasureSpec.UNSPECIFIED));

            mActionMenu = getActionPopup(false);
            int height;
            if (AppDisplay.isPad())
                width = mPbBarView.getMeasuredWidth();
            height = mPbBarView.getMeasuredHeight();
            if (mMaxHeight > 0)
                height = Math.min(height, mMaxHeight);
            show(anchor, rectF, width, height, arrowPosition);
        }
    }

    @Override
    public void show(ViewGroup parent, RectF rectF, int width, int height, int arrowPosition) {
        int parentWidth = parent.getWidth();
        int parentHeight = parent.getHeight();

        mActionMenu.setWidth(width);
        if (AppDisplay.isPad()) {
            if (mShowShapelistView && AppDevice.isChromeOs(mUIExtensionsManager.getAttachedActivity())) {
                int actH = AppDisplay.getActivityHeight();
                height = Math.min(actH / 2, height);
            }
            mActionMenu.setHeight(height);
        } else {
            mActionMenu.setHeight(height + mActionMenu.getSliderHeight());
        }

        Rect rect = new Rect();
        mRectF.round(rect);
        mActionMenu.show(parent, rect, arrowPosition, 0);

        if (mOnShowListener != null) {
            mOnShowListener.onShow(this);
        }

        // move full screen to somewhere in selected annotation model.
        AnnotHandler currentAnnotHandler = mUIExtensionsManager.getCurrentAnnotHandler();
        if ((!AppDisplay.isPad())
                && currentAnnotHandler != null
                && mUIExtensionsManager.getCurrentToolHandler() == null) {
            if (rectF.bottom > 0 && rectF.bottom <= parentHeight) {
                if (rectF.bottom > parentHeight - mPbBarView.getMeasuredHeight()) {
                    offset = mPbBarView.getMeasuredHeight() - (parentHeight - rectF.bottom);

                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            mPdfViewCtrl.layout(0, -(int) offset, mPdfViewCtrl.getWidth(), mPdfViewCtrl.getHeight() - (int) offset);
                        }
                    }, 300);
                }

            } else if (rectF.top >= 0 && rectF.top <= parentHeight && rectF.bottom > parentHeight) {
                if (rectF.top > parentHeight - mPbBarView.getMeasuredHeight()) {
                    offset = mPbBarView.getMeasuredHeight() - (parentHeight - rectF.top) + 10;

                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            mPdfViewCtrl.layout(0, -(int) offset, mPdfViewCtrl.getWidth(), mPdfViewCtrl.getHeight() - (int) offset);
                        }
                    }, 300);
                }
            }
        }
    }

    @Override
    public void update() {
        update(mRectF);
    }

    @Override
    public void update(RectF rectF) {
        update(mAnchor == null ? mUIExtensionsManager.getRootView() : mAnchor, rectF);
    }

    @Override
    public void update(ViewGroup parent, RectF rectF) {
        update(parent, rectF, UIPopoverFrag.ARROW_AUTO);
    }

    @Override
    public void update(RectF rectF, int pos) {
        update(mAnchor == null ? mUIExtensionsManager.getRootView() : mAnchor, rectF, pos);
    }

    public void update(ViewGroup parent, RectF rectF, int arrowPosition) {
        if (!isShowing()) {
            return;
        }

        mRectF.set(rectF);
        int screenWidth = parent.getWidth();
        int screenHeight = parent.getHeight();
        int width = screenWidth;
        if (AppDisplay.isPad()) {
            width = mPadWidth;
        } else if (AppDisplay.isLandscape()) {
            int statusBarHeight = 0;
            if (SystemUiHelper.getInstance().isStatusBarShown(mUIExtensionsManager.getAttachedActivity())) {
                statusBarHeight = SystemUiHelper.getInstance().getStatusBarHeight(mContext);
            }
            width = Math.min(screenWidth, screenHeight) + statusBarHeight;
        }
        mPbBarView.measure(View.MeasureSpec.makeMeasureSpec(width, View.MeasureSpec.EXACTLY),
                View.MeasureSpec.makeMeasureSpec(screenHeight, View.MeasureSpec.UNSPECIFIED));

        if (AppDisplay.isPad()) {
            Rect rect = new Rect();
            mRectF.round(rect);
            int height = mPbBarView.getMeasuredHeight();
            if (mShowShapelistView && AppDevice.isChromeOs(mUIExtensionsManager.getAttachedActivity())) {
                int actH = AppDisplay.getActivityHeight();
                height = Math.min(actH / 2, height);
            }
            if (mScrollEnabled && mMaxHeight > 0)
                height = Math.min(height, mMaxHeight);
            mActionMenu.update(parent, rect, mPbBarView.getMeasuredWidth(), height, arrowPosition);
        } else if (isFullScreen) {
            initFullScreenFragment();
            mFullScreenFragment.update(0, 0, screenWidth, screenHeight);
        } else {
            int height;
            if (mShowShapelistView) {
                int margin = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_8dp);
                int titleHeight = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_pb_title_height);
                int contentHeight = 0;
                Point point = measureAdapterSize(mPBShapeListView);
                if (point != null)
                    contentHeight = point.y;
                int _contentHeight = margin + titleHeight + contentHeight;
                int maxHeight = mUIExtensionsManager.getRootView().getHeight()
                        - AppResource.getDimensionPixelSize(mContext, R.dimen.ux_topbar_height)
                        - mActionMenu.getSliderHeight();
                height = Math.min(maxHeight, _contentHeight);
                ViewGroup.LayoutParams layoutParams = mTabContentLl.getLayoutParams();
                layoutParams.height = height;
                mTabContentLl.setLayoutParams(layoutParams);
            } else {
                height = mPbBarView.getMeasuredHeight();
            }
            int y = 0;
            int rootHeight = mUIExtensionsManager.getRootView().getHeight();
            int actHeight = AppDevice.isChromeOs(mUIExtensionsManager.getAttachedActivity())
                    ? AppDisplay.getActivityHeight() : AppDisplay.getRawScreenHeight();
            if (actHeight != rootHeight)
                y = AppDisplay.getNavBarHeight();
            mActionMenu.update(mUIExtensionsManager.getRootView(), 0, 0, width, height + mActionMenu.getSliderHeight() + y);
        }
    }

    public void dismissPopup() {
        if (mActionMenu != null) {
            getActionPopup().dismiss();
        }
    }

    @Override
    public void dismiss() {
        if (isShowing()) {
            hideStatusBar();

            if (isFullScreen) {
                if (mFullScreenFragment != null && mFullScreenFragment.isShowing()) {
                    mFullScreenFragment.dismiss();
                }
            } else {
                if (mActionMenu != null) {
                    getActionPopup().dismiss();
                }
            }
        }
    }

    private void hideStatusBar() {
        mUIExtensionsManager.startHideToolbarsTimer();
        if (SystemUiHelper.getInstance().isFullScreen())
            SystemUiHelper.getInstance().hideStatusBar(mUIExtensionsManager.getAttachedActivity());
    }

    private void showNavigationBar() {
        mUIExtensionsManager.stopHideToolbarsTimer();
        if (!AppDisplay.isPad())
            SystemUiHelper.getInstance().showNavigationBar(mUIExtensionsManager.getAttachedActivity());
        mUIExtensionsManager.getAttachedActivity().getWindow().getDecorView().setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener() {
            @Override
            public void onSystemUiVisibilityChange(int visibility) {
                PropertyBarImpl.this.update(mRectF, mArrowPosition);
            }
        });
    }

    @Override
    public void setArrowVisible(boolean visible) {
        mArrowVisible = visible;
    }

    @Override
    public void setArrowColor(int color) {
        mArrowColor = color;
        if (mActionMenu != null)
            mActionMenu.setArrowColor(color);
    }

    @Override
    public void setColors(int[] colors) {
        this.mColors = colors;
    }

    @Override
    public void setFillColors(int[] fillColors) {
        this.mFillColors = fillColors;
    }

    @Override
    public void setProperty(long property, float[] values) {
        if (property == PropertyBar.PROPERTY_FONTSIZE
                || property == PROPERTY_FONTSIZE_2
                || property == PropertyBar.PROPERTY_AUTO_FONTSIZE
                || property == PropertyBar.PROPERTY_FONTSIZE_LIST) {
            mFontSizes = values;
        }
    }

    @Override
    public void setProperty(long property, int value) {
        if (property == PropertyBar.PROPERTY_COLOR) {
            int color = 0xff000000 | value;
            int r = Color.red(color);
            int g = Color.green(color);
            int b = Color.blue(color);
            for (int item : mColors) {
                int r2 = Color.red(item);
                int g2 = Color.green(item);
                int b2 = Color.blue(item);
                if (Math.abs(r2 - r) <= 3 && Math.abs(g2 - g) <= 3 && Math.abs(b2 - b) <= 3) {
                    color = item;
                    break;
                }
            }
            mColor = color;
        } else if (property == PropertyBar.PROPERTY_FILL_COLOR) {
            int color = 0xff000000 | value;
            int r = Color.red(color);
            int g = Color.green(color);
            int b = Color.blue(color);
            for (int item : mFillColors) {
                int r2 = Color.red(item);
                int g2 = Color.green(item);
                int b2 = Color.blue(item);
                if (Math.abs(r2 - r) <= 3 && Math.abs(g2 - g) <= 3 && Math.abs(b2 - b) <= 3) {
                    color = item;
                    break;
                }
            }
            mFillColor = color;
        } else if (property == PropertyBar.PROPERTY_OPACITY) {
            mOpacity = value;
        } else if (property == PropertyBar.PROPERTY_ANNOT_TYPE) {
            mNoteIconType = value;
        } else if (property == PropertyBar.PROPERTY_SCALE_PERCENT) {
            mScalePercent = value;
        } else if (property == PropertyBar.PROPERTY_SCALE_SWITCH) {
            mScaleSwitch = value;
        } else if (property == PropertyBar.PROPERTY_ROTATION) {
            mRotation = value;
        } else if (property == PropertyBar.PROPERTY_FILEATTACHMENT) {
            mAttachmentIconType = value;
        } else if (property == PropertyBar.PROPERTY_PENCIL_TYPE) {
            mPencilType = value;
        } else if (property == PropertyBar.PROPERTY_LIST_SYMBOL) {
            mSymbolType = value;
        } else if (property == PropertyBar.PROPERTY_LIST_NUMBER) {
            mNumberType = value;
        } else if (property == PropertyBar.PROPERTY_ALIGNMENT) {
            mAlignmentType = value;
        } else if (property == PropertyBar.PROPERTY_FONTSTYLE) {
            mFontStyle = value;
        } else if (property == PropertyBar.PROPERTY_MAX_LINEWIDTH) {
            mMaxLineWidth = value;
        } else if (property == PropertyBar.PROPERTY_MIN_LINEWIDTH) {
            mMinLineWidth = value;
        } else if (property == PropertyBar.PROPERTY_ERASERSHAPE) {
            mEraserShape = value;
        }
    }

    @Override
    public int getInt(long property) {
        if (property == PropertyBar.PROPERTY_COLOR || property == PropertyBar.PROPERTY_FILL_COLOR) {
            if (property == PROPERTY_COLOR)
                return mColor;
            else
                return mFillColor;
        } else if (property == PropertyBar.PROPERTY_OPACITY) {
            return mOpacity;
        } else if (property == PropertyBar.PROPERTY_ANNOT_TYPE) {
            return mNoteIconType;
        } else if (property == PropertyBar.PROPERTY_SCALE_PERCENT) {
            return mScalePercent;
        } else if (property == PropertyBar.PROPERTY_SCALE_SWITCH) {
            return mScaleSwitch;
        } else if (property == PropertyBar.PROPERTY_ROTATION) {
            return mRotation;
        } else if (property == PropertyBar.PROPERTY_FILEATTACHMENT) {
            return mAttachmentIconType;
        } else if (property == PropertyBar.PROPERTY_PENCIL_TYPE) {
            return mPencilType;
        } else if (property == PropertyBar.PROPERTY_LIST_SYMBOL) {
            return mSymbolType;
        } else if (property == PropertyBar.PROPERTY_LIST_NUMBER) {
            return mNumberType;
        } else if (property == PropertyBar.PROPERTY_ALIGNMENT) {
            return mAlignmentType;
        } else if (property == PropertyBar.PROPERTY_FONTSTYLE) {
            return mFontStyle;
        } else if (property == PropertyBar.PROPERTY_ERASERSHAPE) {
            return mEraserShape;
        }
        return -1;
    }

    @Override
    public void setProperty(long property, float value) {
        if (property == PropertyBar.PROPERTY_LINEWIDTH || property == PropertyBar.PROPERTY_LINEWIDTH_2) {
            mLinewith = value;
        } else if (property == PropertyBar.PROPERTY_FONTSIZE
                || property == PROPERTY_FONTSIZE_2
                || property == PROPERTY_FONTSIZE_LIST
                || property == PropertyBar.PROPERTY_AUTO_FONTSIZE) {
            mFontsize = value;
        }
    }

    @Override
    public void setProperty(long property, String value) {
        if (property == PropertyBar.PROPERTY_FONTNAME
                || property == PropertyBar.PROPERTY_FONTNAME_2
                || property == PropertyBar.PROPERTY_FONTNAME_LIST) {
            mFontname = value;
            TextView type_name = map_type_name_views.get(property);
            if (isShowing() && type_name != null)
                type_name.setText(mFontname);
        } else if (property == PropertyBar.PROPERTY_RADIO_NAME) {
            mRadioName = value;
        } else if (property == PropertyBar.PROPERTY_OVERLAY_TEXT) {
            mOverlayText = value;
        }
    }

    @Override
    public String getString(long property) {
        if (property == PropertyBar.PROPERTY_FONTNAME
                || property == PropertyBar.PROPERTY_FONTNAME_2
                || property == PropertyBar.PROPERTY_FONTNAME_LIST) {
            return mFontname;
        } else if (property == PropertyBar.PROPERTY_RADIO_NAME) {
            return mRadioName;
        } else if (property == PropertyBar.PROPERTY_OVERLAY_TEXT) {
            return mOverlayText;
        }
        return null;
    }

    @Override
    public void clearPropertyTitle() {
        mCustomItemTitles.clear();
    }

    @Override
    public void setPropertyTitle(long property, String title) {
        mCustomItemTitles.put(property, title);
    }


    @Override
    public PropertyChangeListener getPropertyChangeListener() {
        return this.mPropertyChangeListener;
    }

    @Override
    public void setPropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertyChangeListener = listener;
    }

    @Override
    public void setCustomPropertyChangeListener(PropertyChangeListener listener) {
        this.mCustomChangeListener = listener;
    }

    @Override
    public PropertyChangeListener getCustomPropertyChangeListener() {
        return mCustomChangeListener;
    }

    @Override
    public void setDismissListener(PropertyBar.DismissListener dismissListener) {
        this.mDismissListener = dismissListener;
    }


    IActionMenu.OnActionMenuDismissListener mMenuDismissListener = new IActionMenu.OnActionMenuDismissListener() {
        @Override
        public void onDismiss(IActionMenu actionMenu) {
            _dismiss();
        }
    };

    PopupWindow.OnDismissListener mPopDismissListener = new PopupWindow.OnDismissListener() {
        @Override
        public void onDismiss() {
            _dismiss();
            AppUtil.removeViewFromParent(mPbBarView);
            mFullScreenFragment = null;
        }
    };

    private void _dismiss() {
        if (mScrollEnabled)
            setScrollingEnabled(false);
//        mShowShapelistView = false;
        mUIExtensionsManager.getAttachedActivity().getWindow().getDecorView().setOnSystemUiVisibilityChangeListener(null);
        mShowShapelistView = false;
        if (mDismissListener != null) {
            mDismissListener.onDismiss();
        }

        if (mShowMask) {
            mShowMask = false;
        }
        mTag = null;
        map_type_name_views.clear();

        setShowOnKeyboard(false);
        if (mIsRegisterKeyboardListener) {
            mIsRegisterKeyboardListener = false;
            AppKeyboardUtil.removeKeyboardListener(mUIExtensionsManager.getRootView());
        }
        AnnotHandler currentAnnotHandler = mUIExtensionsManager.getCurrentAnnotHandler();
        // move full screen to original position if it's moved to somewhere in selected annotation model.
        if ((!AppDisplay.isPad())
                && currentAnnotHandler != null
                && mUIExtensionsManager.getCurrentToolHandler() == null) {
            if (offset > 0) {
                mPdfViewCtrl.layout(0, 0, mPdfViewCtrl.getWidth(), mPdfViewCtrl.getHeight());
                offset = 0;
            }
        }

        if (mDismissWithReset) {
            if ((mSupportProperty != 0 || mCustomProperty != 0)
                    && mPdfViewCtrl.getDoc() != null)
                reset(mSupportProperty, false);

            if (mUIExtensionsManager.getDocumentManager().getCurrentAnnot() != null)
                mUIExtensionsManager.getDocumentManager().setCurrentAnnot(null);
        }
    }

    IActionMenu getActionPopup() {
        return getActionPopup(false);
    }

    IActionMenu getActionPopup(boolean createNew) {
        if (mActionMenu == null || createNew) {
            mActionMenu = UIActionMenu.newInstance((FragmentActivity) mUIExtensionsManager.getAttachedActivity());
            AppUtil.removeViewFromParent(mRootView);
            mActionMenu.setContentView(mRootView);
            mActionMenu.setAutoResetSystemUiOnDismiss(mAutoResetSystemUiOnDismiss);
            mActionMenu.setAutoResetSystemUiOnShow(mAutoResetSystemUiOnShow);
            mActionMenu.setOnDismissListener(mMenuDismissListener);
            mActionMenu.setShowOnKeyboard(mShowOnKeyboard);
            if (mArrowColor != 0)
                mActionMenu.setArrowColor(mArrowColor);
        }
        return mActionMenu;
    }

    void removeContentViews() {
//        mTopSubTitleLl.setVisibility(View.GONE);
        mTopTabRootLl.setVisibility(View.GONE);
        for (int i = 0; i < mTabContentLl.getChildCount(); i++) {
            LinearLayout tabContent = (LinearLayout) mTabContentLl.getChildAt(i);
            tabContent.removeAllViews();
        }
        mTabContentLl.removeAllViews();
    }

    @Override
    public void updateTheme() {
        if (mTitleBar != null) {
            mTitleBar.setBackgroundColor(AppResource.getColor(mContext, R.color.b2));
            mTitleItem.setTextColorResource(R.color.t4);
        }
        mTopTabItemsLl.setBackgroundColor(AppResource.getColor(mContext, R.color.b2));
        mTabContentLl.setBackgroundColor(AppResource.getColor(mContext, R.color.b1));
        mTopSubTitleLl.setBackgroundColor(AppResource.getColor(mContext, R.color.b1));
        if (mActionMenu instanceof UIActionMenu) {
            ((UIActionMenu) mActionMenu).setDarkModeColor();
        }
        reset(mSupportProperty, false);
        dismiss();
    }

    @Override
    public void setAutoResetSystemUiOnDismiss(boolean auto) {
        this.mAutoResetSystemUiOnDismiss = auto;
        if (mActionMenu != null)
            mActionMenu.setAutoResetSystemUiOnDismiss(auto);
    }

    @Override
    public void setAutoResetSystemUiOnShow(boolean auto) {
        this.mAutoResetSystemUiOnShow = auto;
        if (mActionMenu != null)
            mActionMenu.setAutoResetSystemUiOnShow(auto);
    }

    @Override
    public void setMaxHeight(int height) {
        mMaxHeight = height;
    }

    @Override
    public void setShowWidth(int width) {
        mPadWidth = width;
    }

    @Override
    public int getShowWidth() {
        return mPadWidth;
    }

    private boolean mNeedAutoSetCustomPropertyListener = true;

    public boolean needAutoSetCustomPropertyListener() {
        return mNeedAutoSetCustomPropertyListener;
    }

    public void setNeedAutoSetCustomPropertyListener(boolean flag) {
        this.mNeedAutoSetCustomPropertyListener = flag;
    }

    private void initFullScreenFragment() {
        if (mFullScreenFragment != null) return;
        mFullScreenFragment = UIPopupFragment.create((FragmentActivity) mUIExtensionsManager.getAttachedActivity(), mPbBarView,
                FULL_SCREEN_TAG, true, false);
        mFullScreenFragment.setOnDismissListener(mPopDismissListener);
        mFullScreenFragment.setOnKeyListener(mOnKeyListener);
        mFullScreenFragment.setAnimationStyle(R.style.View_Animation_BtoT);

        mFullScreenFragment.setWidth(mAnchor.getWidth());
        mFullScreenFragment.setHeight(mAnchor.getHeight());
    }
}
