/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.propertybar.imp;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;

import com.foxit.sdk.PDFException;
import com.foxit.sdk.PDFViewCtrl;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.uiextensions.IPermissionProvider;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.controls.propertybar.AnnotMenu;
import com.foxit.uiextensions.controls.propertybar.MenuItem;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.SystemUiHelper;

import java.util.ArrayList;

public class AnnotMenuImpl implements AnnotMenu {
    private Context mContext;
    private ArrayList<Integer> mMenuItems;
    private ArrayList<MenuItem> mExtensoinMenuItems;
    private LinearLayout mPopView;
    private ScrollView mContentView;

    private int mMaxWidth;
    private int mMinWidth;
    private ClickListener mListener;//menu click listener
    private PopupWindow mPopupWindow;
    private boolean mShowing = false;
    private PDFViewCtrl mPDFViewCtrl;
    private UIExtensionsManager mUIExtensionsManager;
    private int mShowingPosition = SHOWING_TOP;

    public AnnotMenuImpl(Context context, PDFViewCtrl pdfViewCtrl) {
        this.mContext = context;
        this.mPDFViewCtrl = pdfViewCtrl;
        mUIExtensionsManager = (UIExtensionsManager) pdfViewCtrl.getUIExtensionsManager();

        mMaxWidth = AppDisplay.dp2px(5000.0f);
        mMinWidth = AppDisplay.dp2px(80.0f);
    }

    @Override
    public void setMenuItems(ArrayList<Integer> menuItems) {
        this.mMenuItems = menuItems;
        initView();
    }

    @Override
    public void setExtensionMenuItems(ArrayList<MenuItem> menuItems) {
        mExtensoinMenuItems = menuItems;
        initView();
    }

    private void initView() {
        if (mContentView == null) {
            mContentView = new ScrollView(mContext);
            mContentView.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT));
            mContentView.setBackgroundResource(R.drawable.am_popup_bg);
        } else {
            mContentView.removeAllViews();
        }

        mPopView = new LinearLayout(mContext);
        mPopView.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT));
        mPopView.setOrientation(LinearLayout.VERTICAL);
        mContentView.addView(mPopView);

        if (mMenuItems != null && mMenuItems.size() > 0) {
            for (int i = 0; i < mMenuItems.size(); i++) {
                if (i > 0) {
                    ImageView separate = new ImageView(mContext);
                    separate.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, AppDisplay.dp2px(1.0f)));
                    separate.setImageResource(R.color.p1);
                    mPopView.addView(separate);
                }
                if (mMenuItems.get(i) == AnnotMenu.AM_BT_COPY) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.rd_am_item_copy_text), R.id.id_AM_BT_COPY);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_HIGHLIGHT) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_highlight), R.id.id_AM_BT_HIGHLIGHT);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_UNDERLINE) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_underline), R.id.id_AM_BT_UNDERLINE);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_STRIKEOUT) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_strikeout), R.id.id_AM_BT_STRIKEOUT);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_SQUIGGLY) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_squiggly), R.id.id_AM_BT_SQUIGGLY);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_EDIT) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_edit), R.id.id_AM_BT_EDIT);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_STYLE) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_am_style), R.id.id_AM_BT_STYLE);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_COMMENT) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_open), R.id.id_AM_BT_COMMENT);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_REPLY) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_reply), R.id.id_AM_BT_REPLY);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_DELETE) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_delete), R.id.id_AM_BT_DELETE);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_NOTE) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_note), R.id.id_AM_BT_NOTE);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_TYPEWRITER) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.annot_tool_display_name_typewrite), R.id.id_AM_BT_TYPEWRITER);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_PENCIL) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_pencil), R.id.id_AM_BT_PENCIL);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_SIGNATURE) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_signature), R.id.id_AM_BT_SIGNATURE);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_SIGN) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_signature), R.id.id_AM_BT_SIGN);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_CANCEL) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_cancel), R.id.id_AM_BT_CANCEL);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_VERIFY_SIGNATURE) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.rv_security_dsg_verify), R.id.id_AM_BT_VERIFY_SIGNATURE);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_PALY) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.multimedia_play), R.id.id_AM_BT_PALY);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_FLATTEN) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_flatten), R.id.id_AM_BT_FLATTEN);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_REDACT) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_redaction), R.id.id_AM_BT_REDACT);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_APPLY) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_apply), R.id.id_AM_BT_APPLY);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_SIGN_LIST) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.rv_sign_model), R.id.id_AM_BT_SIGN_LIST);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_TTS) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.rd_tts_speak), R.id.id_AM_BT_TTS);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_TTS_STRING) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.rd_tts_speak_string), R.id.id_AM_BT_TTS_STRING);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_TTS_START) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.rd_tts_speak_start), R.id.id_AM_BT_TTS_START);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_GROUP) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_group), R.id.id_AM_BT_GROUP);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_UNGROUP) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_ungroup), R.id.id_AM_BT_UNGROUP);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_SELECT_ALL) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_select_all), R.id.id_AM_BT_SELECT_ALL);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_ROTATE) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_rotate), R.id.id_AM_BT_ROTATE);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_REPLACE) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_replace), R.id.id_AM_BT_REPLACE);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_EXPORT) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_export), R.id.id_AM_BT_EXPORT);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_ROTATE_CLOCKWISE) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_rotate_clockwise), R.id.id_AM_BT_ROTATE_CLOCKWISE);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_ROTATE_COUNTERCLOCKWISE) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_rotate_counterclockwise), R.id.id_AM_BT_ROTATE_COUNTERCLOCKWISE);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_GALERY) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_import_dcim), R.id.id_AM_BT_GALERY);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_CAMERA) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_import_camera), R.id.id_AM_BT_CAMERA);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_FILE) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.from_document), R.id.id_AM_BT_FILE);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_ADD_IMAGE) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_add_image), R.id.id_AM_BT_ADD_IMAGE);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_ADD_TEXT) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_add_text), R.id.id_AM_BT_ADD_TEXT);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_RECORD_AUDIO) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.record_audio), R.id.id_AM_BT_RECORD_AUDIO);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_CHOOSE_AUDIO) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.choose_audio), R.id.id_AM_BT_CHOOSE_AUDIO);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_RECORD_VIDEO) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.record_video), R.id.id_AM_BT_RECORD_VIDEO);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_SELECT) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.atb_convert_select_files), R.id.id_AM_BT_SELECT);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_CLEAR) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.hm_clear), R.id.id_AM_BT_CLEAR);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_PASTE) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_paste), R.id.id_AM_BT_PASTE);
                } else if (mMenuItems.get(i) == AnnotMenu.PM_BT_CUT) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_cut), R.id.id_PM_BT_CUT);
                } else if (mMenuItems.get(i) == AnnotMenu.PM_BT_COPY) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_copy), R.id.id_PM_BT_COPY);
                } else if (mMenuItems.get(i) == AnnotMenu.PM_BT_PASTE) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_paste), R.id.id_PM_BT_PASTE);
                } else if (mMenuItems.get(i) == AnnotMenu.PM_BT_DELETE) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_delete), R.id.id_PM_BT_DELETE);
                } else if (mMenuItems.get(i) == AnnotMenu.PM_BT_SELECT_ALL) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.fx_string_select_all), R.id.id_PM_BT_SELECT_ALL);
                } else if (mMenuItems.get(i) == AnnotMenu.AM_BT_INK_RECOGNIZE_TEXT) {
                    addSubMenu(mMenuItems.get(i), AppResource.getString(mContext, R.string.ocr_ink_recognize_text), R.id.id_AM_BT_INK_RECOGNIZE_TEXT);
                }
            }
        }

        if (mExtensoinMenuItems != null && mExtensoinMenuItems.size() > 0) {
            for (int i = 0; i < mExtensoinMenuItems.size(); i++) {

                if (i > 0 || (mMenuItems != null && mMenuItems.size() > 0)) {
                    ImageView separate = new ImageView(mContext);
                    separate.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, AppDisplay.dp2px(1.0f)));
                    separate.setImageResource(R.color.p1);
                    mPopView.addView(separate);
                }

                if (mExtensoinMenuItems.get(i).getType() == 201 || mExtensoinMenuItems.get(i).getType() == AM_BT_RECOGNIZE_TEXT) {
                   if (mMenuItems != null && mMenuItems.size() > 0) {
                       mPopView.removeViewAt(mPopView.getChildCount() - 1);
                       addSubMenu(mExtensoinMenuItems.get(i).getType(), mExtensoinMenuItems.get(i).getText(), 0, 0);
                       ImageView separate = new ImageView(mContext);
                       separate.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, AppDisplay.dp2px(1.0f)));
                       separate.setImageResource(R.color.p1);
                       mPopView.addView(separate, 1);
                   } else {
                            addSubMenu(mExtensoinMenuItems.get(i).getType(), mExtensoinMenuItems.get(i).getText(), 0);
                   }

                } else {
                    addSubMenu(mExtensoinMenuItems.get(i).getType(), mExtensoinMenuItems.get(i).getText(), 0);
                }
            }
        }

        setMenuWidth();

        if (mPopupWindow == null) {
            mPopupWindow = new PopupWindow(mContentView, ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            mPopupWindow.setTouchable(true);
            mPopupWindow.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        }
        setShowAlways(false);
    }

    @Override
    public void setShowAlways(boolean showAlways) {
        mPopupWindow.setFocusable(false);
        mPopupWindow.setOutsideTouchable(false);
    }

    private void addSubMenu(int menuTag, String text, int id) {
        TextView textView = new TextView(mContext);
        textView.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, AppDisplay.dp2px(56.0f)));
        textView.setText(text);
        textView.setTypeface(Typeface.DEFAULT);
        textView.setTextSize(14.0f);
        textView.setTextColor(AppResource.getColor(mContext, R.color.t4));

        if (id != 0) {
            textView.setId(id);
        }

        textView.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
        textView.setPadding(AppDisplay.dp2px(8.0f), AppDisplay.dp2px(5.0f), AppDisplay.dp2px(8.0f), AppDisplay.dp2px(5.0f));
        textView.setBackgroundResource(R.drawable.am_tv_bg_selector);
        textView.setSingleLine(true);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setTag(menuTag);
        textView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                final int tag = (Integer) v.getTag();
                if (mListener != null) {
                    if (tag == AnnotMenu.AM_BT_FLATTEN) {
                        if (mUIExtensionsManager.getPermissionProvider() != null) {
                            mUIExtensionsManager.getPermissionProvider().checkPermission(
                                    IPermissionProvider.FUNCTION_FLATTEN, new IPermissionProvider.IPermissionState() {
                                        @Override
                                        public void onState(int state) {
                                            if (state == IPermissionProvider.PERMISSION_STATE_SHOW) {
                                                mListener.onAMClick(tag);
                                            }
                                        }
                                    }
                            );
                        } else {
                            mListener.onAMClick(tag);
                        }
                    } else {
                        mListener.onAMClick(tag);
                    }
                }
            }
        });


        mPopView.addView(textView);
    }

    public void addSubMenu(int menuTag, String text, int id, int position) {
        TextView textView = new TextView(mContext);
        textView.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, AppDisplay.dp2px(56.0f)));
        textView.setText(text);
        textView.setTypeface(Typeface.DEFAULT);
        textView.setTextSize(14.0f);
        textView.setTextColor(AppResource.getColor(mContext, R.color.t4));

        if (id != 0) {
            textView.setId(id);
        }

        textView.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
        textView.setPadding(AppDisplay.dp2px(8.0f), AppDisplay.dp2px(5.0f), AppDisplay.dp2px(8.0f), AppDisplay.dp2px(5.0f));
        textView.setBackgroundResource(R.drawable.am_tv_bg_selector);
        textView.setSingleLine(true);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setTag(menuTag);
        textView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                final int tag = (Integer) v.getTag();
                if (mListener != null) {
                    if (tag == AnnotMenu.AM_BT_FLATTEN) {
                        if (mUIExtensionsManager.getPermissionProvider() != null) {
                            mUIExtensionsManager.getPermissionProvider().checkPermission(
                                    IPermissionProvider.FUNCTION_FLATTEN, new IPermissionProvider.IPermissionState() {
                                        @Override
                                        public void onState(int state) {
                                            if (state == IPermissionProvider.PERMISSION_STATE_SHOW) {
                                                mListener.onAMClick(tag);
                                            }
                                        }
                                    }
                            );
                        } else {
                            mListener.onAMClick(tag);
                        }
                    } else {
                        mListener.onAMClick(tag);
                    }
                }
            }
        });


        mPopView.addView(textView, position);
    }

    private int getMeunItemCount() {
        int size = 0;
        if (mMenuItems != null) {
            size = mMenuItems.size();
        }

        if (mExtensoinMenuItems != null) {
            size += mExtensoinMenuItems.size();
        }
        return size;
    }

    private void setMenuWidth() {
        int width = getMenuWidth();
        ImageView separate;
        LinearLayout.LayoutParams separateParams;
        TextView textView;
        for (int i = 0; i < getMeunItemCount(); i++) {
            if (i > 0) {
                separate = (ImageView) mPopView.getChildAt(2 * i - 1);
                if (separate != null) {
                    separateParams = (LinearLayout.LayoutParams) separate.getLayoutParams();
                    if (separateParams != null) {
                        separateParams.width = width;
                        separate.setLayoutParams(separateParams);
                    }
                }
            }
            textView = (TextView) mPopView.getChildAt(2 * i);
            if (textView != null) {
                textView.setWidth(width);
                textView.setMaxWidth(mMaxWidth);
            }
        }
    }

    private int getMenuWidth() {
        int realShowWidth = 0;
        TextView textView;
        for (int i = 0; i < getMeunItemCount(); i++) {
            textView = (TextView) mPopView.getChildAt(2 * i);
            if (textView != null) {
                textView.measure(0, 0);
                if (textView.getMeasuredWidth() < mMaxWidth) {
                    if (textView.getMeasuredWidth() > realShowWidth) {
                        realShowWidth = textView.getMeasuredWidth();
                    }
                } else {
                    realShowWidth = mMaxWidth;
                    break;
                }
            }
        }

        if (realShowWidth == 0 || realShowWidth < mMinWidth) {
            realShowWidth = mMinWidth;
        }

        return realShowWidth;
    }


    @Override
    public PopupWindow getPopupWindow() {
        return mPopupWindow;
    }

    @Override
    public void show(RectF rectF) {
        if (mMenuItems != null && mMenuItems.size() > 0 || mExtensoinMenuItems != null && mExtensoinMenuItems.size() > 0) {
            if (mPDFViewCtrl.getCropMode() != PDFViewCtrl.CROPMODE_NONE) {
                Annot curAnnot = mUIExtensionsManager.getDocumentManager().getCurrentAnnot();
                if (curAnnot != null && !curAnnot.isEmpty()) {
                    try {
                        int pageIndex = curAnnot.getPage().getIndex();
                        RectF cropRect = mPDFViewCtrl.getCropRect(pageIndex);
                        if (cropRect != null) {
                            mPDFViewCtrl.convertPdfRectToPageViewRect(cropRect, cropRect, pageIndex);
                            mPDFViewCtrl.convertPageViewRectToDisplayViewRect(cropRect, cropRect, pageIndex);
                            rectF.intersect(cropRect);
                        }
                    } catch (PDFException ignored) {
                    }
                }
            }

            int space = AppDisplay.dp2px(12.0f);
            RelativeLayout view = (RelativeLayout) mUIExtensionsManager.getRootView();
            int height = view.getHeight();
            int width = view.getWidth();

//            int[] location = new int[2];
//            view.getLocationOnScreen(location);
            int x = 0;
            int y = 0;
            if (SystemUiHelper.getInstance().isStatusBarShown(mUIExtensionsManager.getAttachedActivity())) {
                y = SystemUiHelper.getInstance().getStatusBarHeight(mContext);
                rectF.top += y;
                rectF.bottom += y;
            }

            float expandLeft = rectF.left - space + x;
            if (rectF.left > 0 && expandLeft < 0) {
                expandLeft = 0;
            }
            float expandRight = rectF.right + space + x;
            if (rectF.right < 0 && expandRight > 0) {
                expandRight = 0;
            }
            float expandTop = rectF.top - space;
            if (rectF.top > 0 && expandTop < 0) {
                expandTop = 0;
            }
            float expandBottom = rectF.bottom + space;
            if (rectF.bottom < 0 && expandBottom > 0) {
                expandBottom = 0;
            }
            RectF expandRectF = new RectF(expandLeft, expandTop, expandRight, expandBottom);

            if (mPopupWindow != null && !mPopupWindow.isShowing()) {
                int top = 0 + y;
                int left = 0 + x;
                int right = width + x;
                int bottom = height /*+ y*/;
                RectF rectFScreen = new RectF(left, top, right, bottom);
                if (RectF.intersects(expandRectF, rectFScreen)) {
                    mPopupWindow.getContentView().measure(0, 0);
                    if (expandRectF.top >= mPopupWindow.getContentView().getMeasuredHeight() + y) {//top
                        mShowingPosition = SHOWING_TOP;
                        mPopupWindow.showAtLocation(view, Gravity.LEFT | Gravity.TOP,
                                (int) (expandRectF.right - (expandRectF.right - expandRectF.left) / 2 - mPopupWindow.getContentView().getMeasuredWidth() / 2.0f),
                                (int) (expandRectF.top - mPopupWindow.getContentView().getMeasuredHeight()));
                    } else if (height - expandRectF.bottom >= (mPopupWindow.getContentView().getMeasuredHeight())) {//bottom
                        mShowingPosition = SHOWING_BOTTOM;
                        mPopupWindow.showAtLocation(view, Gravity.LEFT | Gravity.TOP,
                                (int) (expandRectF.right - (expandRectF.right - expandRectF.left) / 2 - mPopupWindow.getContentView().getMeasuredWidth() / 2.0f),
                                (int) (expandRectF.bottom));
                    } else if (width - expandRectF.right >= mPopupWindow.getContentView().getMeasuredWidth()) {//right
                        mShowingPosition = SHOWING_RIGHT;
                        mPopupWindow.showAtLocation(view, Gravity.LEFT | Gravity.TOP,
                                (int) (expandRectF.right),
                                (int) (expandRectF.bottom - mPopupWindow.getContentView().getMeasuredHeight() / 2.0f - (expandRectF.bottom - expandRectF.top) / 2.0f));
                    } else if (expandRectF.left >= mPopupWindow.getContentView().getMeasuredWidth()) {//left
                        mShowingPosition = SHOWING_LEFT;
                        mPopupWindow.showAtLocation(view, Gravity.LEFT | Gravity.TOP,
                                (int) (expandRectF.left - mPopupWindow.getContentView().getMeasuredWidth()),
                                (int) (expandRectF.bottom - mPopupWindow.getContentView().getMeasuredHeight() / 2.0f - (expandRectF.bottom - expandRectF.top) / 2));

                    } else {//center
                        mShowingPosition = SHOWING_CENTER;
                        mPopupWindow.showAtLocation(view, Gravity.LEFT | Gravity.TOP,
                                (int) (expandRectF.right - (expandRectF.right - expandRectF.left) / 2 - mPopupWindow.getContentView().getMeasuredWidth() / 2.0f),
                                (int) (expandRectF.bottom - mPopupWindow.getContentView().getMeasuredHeight() / 2.0f - (expandRectF.bottom - expandRectF.top) / 2));
                    }
                }

                if (mPopupWindow.isShowing()) {
                    mShowing = true;
                }
            }
        }
    }

    @Override
    public void show(RectF rectF, int pageWidth, int pageHeight, boolean autoDismiss) {
        if (mMenuItems != null && mMenuItems.size() > 0 || mExtensoinMenuItems != null && mExtensoinMenuItems.size() > 0) {
            if (mPDFViewCtrl.getCropMode() != PDFViewCtrl.CROPMODE_NONE) {
                Annot curAnnot = mUIExtensionsManager.getDocumentManager().getCurrentAnnot();
                if (curAnnot != null && !curAnnot.isEmpty()) {
                    try {
                        int pageIndex = curAnnot.getPage().getIndex();
                        RectF cropRect = mPDFViewCtrl.getCropRect(pageIndex);
                        if (cropRect != null) {
                            mPDFViewCtrl.convertPdfRectToPageViewRect(cropRect, cropRect, pageIndex);
                            mPDFViewCtrl.convertPageViewRectToDisplayViewRect(cropRect, cropRect, pageIndex);
                            rectF.intersect(cropRect);
                        }
                    } catch (PDFException ignored) {
                    }
                }
            }

            int space = AppDisplay.dp2px(12.0f);
            RelativeLayout view = (RelativeLayout) mUIExtensionsManager.getRootView();
            int height = pageHeight;
            int width = pageWidth;

//            int[] location = new int[2];
//            view.getLocationOnScreen(location);
            int x = 0;
            int y = 0;
            if (SystemUiHelper.getInstance().isStatusBarShown(mUIExtensionsManager.getAttachedActivity())) {
                y = SystemUiHelper.getInstance().getStatusBarHeight(mContext);
                rectF.top += y;
                rectF.bottom += y;
            }

            float expandLeft = rectF.left - space + x;
            if (rectF.left > 0 && expandLeft < 0) {
                expandLeft = 0;
            }
            float expandRight = rectF.right + space + x;
            if (rectF.right < 0 && expandRight > 0) {
                expandRight = 0;
            }
            float expandTop = rectF.top - space;
            if (rectF.top > 0 && expandTop < 0) {
                expandTop = 0;
            }
            float expandBottom = rectF.bottom + space;
            if (rectF.bottom < 0 && expandBottom > 0) {
                expandBottom = 0;
            }
            RectF expandRectF = new RectF(expandLeft, expandTop, expandRight, expandBottom);

            if (mPopupWindow != null && !mPopupWindow.isShowing()) {
                int top = y;
                int left = x;
                int right = pageWidth + x;
                int bottom = pageHeight /*+ y*/;
                RectF rectFScreen = new RectF(left, top, right, bottom);
                if (RectF.intersects(expandRectF, rectFScreen) || !autoDismiss) {
                    mPopupWindow.getContentView().measure(0, 0);
                    if (expandRectF.top >= mPopupWindow.getContentView().getMeasuredHeight() + y) {//top
                        mShowingPosition = SHOWING_TOP;
                        mPopupWindow.showAtLocation(view, Gravity.LEFT | Gravity.TOP,
                                (int) (expandRectF.right - (expandRectF.right - expandRectF.left) / 2 - mPopupWindow.getContentView().getMeasuredWidth() / 2.0f),
                                (int) (expandRectF.top - mPopupWindow.getContentView().getMeasuredHeight()));
                    } else if (height - expandRectF.bottom >= mPopupWindow.getContentView().getMeasuredHeight()) {//bottom
                        mShowingPosition = SHOWING_BOTTOM;
                        mPopupWindow.showAtLocation(view, Gravity.LEFT | Gravity.TOP,
                                (int) (expandRectF.right - (expandRectF.right - expandRectF.left) / 2 - mPopupWindow.getContentView().getMeasuredWidth() / 2.0f),
                                (int) (expandRectF.bottom));
                    } else if (width - expandRectF.right >= mPopupWindow.getContentView().getMeasuredWidth()) {//right
                        mShowingPosition = SHOWING_RIGHT;
                        mPopupWindow.showAtLocation(view, Gravity.LEFT | Gravity.TOP,
                                (int) (expandRectF.right),
                                (int) (expandRectF.bottom - mPopupWindow.getContentView().getMeasuredHeight() / 2.0f - (expandRectF.bottom - expandRectF.top) / 2.0f));
                    } else if (expandRectF.left >= mPopupWindow.getContentView().getMeasuredWidth()) {//left
                        mShowingPosition = SHOWING_LEFT;
                        mPopupWindow.showAtLocation(view, Gravity.LEFT | Gravity.TOP,
                                (int) (expandRectF.left - mPopupWindow.getContentView().getMeasuredWidth()),
                                (int) (expandRectF.bottom - mPopupWindow.getContentView().getMeasuredHeight() / 2.0f - (expandRectF.bottom - expandRectF.top) / 2));

                    } else {//center
                        mShowingPosition = SHOWING_CENTER;
                        mPopupWindow.showAtLocation(view, Gravity.LEFT | Gravity.TOP,
                                (int) (expandRectF.right - (expandRectF.right - expandRectF.left) / 2 - mPopupWindow.getContentView().getMeasuredWidth() / 2.0f),
                                (int) (expandRectF.bottom - mPopupWindow.getContentView().getMeasuredHeight() / 2.0f - (expandRectF.bottom - expandRectF.top) / 2));
                    }
                }

                if (mPopupWindow.isShowing()) {
                    mShowing = true;
                }
            }
        }
    }

    @Override
    public void show(RectF rectF, View view) {
        if (mMenuItems != null && mMenuItems.size() > 0 || mExtensoinMenuItems != null && mExtensoinMenuItems.size() > 0) {
            if (mPDFViewCtrl.getCropMode() != PDFViewCtrl.CROPMODE_NONE) {
                Annot curAnnot = mUIExtensionsManager.getDocumentManager().getCurrentAnnot();
                if (curAnnot != null && !curAnnot.isEmpty()) {
                    try {
                        int pageIndex = curAnnot.getPage().getIndex();
                        RectF cropRect = mPDFViewCtrl.getCropRect(pageIndex);
                        if (cropRect != null) {
                            mPDFViewCtrl.convertPdfRectToPageViewRect(cropRect, cropRect, pageIndex);
                            mPDFViewCtrl.convertPageViewRectToDisplayViewRect(cropRect, cropRect, pageIndex);
                            rectF.intersect(cropRect);
                        }
                    } catch (PDFException ignored) {
                    }
                }
            }

            int space = AppDisplay.dp2px(12.0f);
            ViewGroup parent = mUIExtensionsManager.getRootView();
            int height = parent.getHeight();
            int width = parent.getWidth();

//            int[] location = new int[2];
//            view.getLocationOnScreen(location);
            int x = 0;
            int y = 0;
            if (SystemUiHelper.getInstance().isStatusBarShown(mUIExtensionsManager.getAttachedActivity())) {
                y = SystemUiHelper.getInstance().getStatusBarHeight(mContext);
                rectF.top += y;
                rectF.bottom += y;
            }

            float expandLeft = rectF.left - space + x;
            if (rectF.left > 0 && expandLeft < 0) {
                expandLeft = 0;
            }
            float expandRight = rectF.right + space + x;
            if (rectF.right < 0 && expandRight > 0) {
                expandRight = 0;
            }
            float expandTop = rectF.top - space;
            if (rectF.top > 0 && expandTop < 0) {
                expandTop = 0;
            }
            float expandBottom = rectF.bottom + space;
            if (rectF.bottom < 0 && expandBottom > 0) {
                expandBottom = 0;
            }
            RectF expandRectF = new RectF(expandLeft, expandTop, expandRight, expandBottom);

            if (mPopupWindow != null && !mPopupWindow.isShowing()) {
                mPopupWindow.getContentView().measure(0, 0);
                if (expandRectF.top >= mPopupWindow.getContentView().getMeasuredHeight() + y) {
                    mShowingPosition = SHOWING_TOP;
                    mPopupWindow.showAtLocation(view, Gravity.LEFT | Gravity.TOP,
                            (int) (expandRectF.right - (expandRectF.right - expandRectF.left) / 2 - mPopupWindow.getContentView().getMeasuredWidth() / 2.0f),
                            (int) (expandRectF.top - mPopupWindow.getContentView().getMeasuredHeight()));
                } else if (height - expandRectF.bottom >= mPopupWindow.getContentView().getMeasuredHeight()) {
                    mShowingPosition = SHOWING_BOTTOM;
                    mPopupWindow.showAtLocation(view, Gravity.LEFT | Gravity.TOP,
                            (int) (expandRectF.right - (expandRectF.right - expandRectF.left) / 2 - mPopupWindow.getContentView().getMeasuredWidth() / 2.0f),
                            (int) (expandRectF.bottom));
                } else if (width + x - expandRectF.right >= mPopupWindow.getContentView().getMeasuredWidth()) {
                    mShowingPosition = SHOWING_RIGHT;
                    mPopupWindow.showAtLocation(view, Gravity.LEFT | Gravity.TOP,
                            (int) (expandRectF.right),
                            (int) (expandRectF.bottom - mPopupWindow.getContentView().getMeasuredHeight() / 2.0f - (expandRectF.bottom - expandRectF.top) / 2.0f));
                } else if (expandRectF.left >= mPopupWindow.getContentView().getMeasuredWidth()) {
                    mShowingPosition = SHOWING_LEFT;
                    mPopupWindow.showAtLocation(view, Gravity.LEFT | Gravity.TOP,
                            (int) (expandRectF.left - mPopupWindow.getContentView().getMeasuredWidth()),
                            (int) (expandRectF.bottom - mPopupWindow.getContentView().getMeasuredHeight() / 2.0f - (expandRectF.bottom - expandRectF.top) / 2));
                } else {
                    mShowingPosition = SHOWING_CENTER;
                    mPopupWindow.showAtLocation(view, Gravity.LEFT | Gravity.TOP,
                            (int) (expandRectF.right - (expandRectF.right - expandRectF.left) / 2 - mPopupWindow.getContentView().getMeasuredWidth() / 2.0f),
                            (int) (expandRectF.bottom - mPopupWindow.getContentView().getMeasuredHeight() / 2.0f - (expandRectF.bottom - expandRectF.top) / 2));
                }

                if (mPopupWindow.isShowing()) {
                    mShowing = true;
                }
            }
        }
    }

    @Override
    public void update(RectF rectF) {
        if (mMenuItems != null && mMenuItems.size() > 0 || mExtensoinMenuItems != null && mExtensoinMenuItems.size() > 0) {
            if (mPDFViewCtrl.getCropMode() != PDFViewCtrl.CROPMODE_NONE) {
                Annot curAnnot = mUIExtensionsManager.getDocumentManager().getCurrentAnnot();
                if (curAnnot != null && !curAnnot.isEmpty()) {
                    try {
                        int pageIndex = curAnnot.getPage().getIndex();
                        RectF cropRect = mPDFViewCtrl.getCropRect(pageIndex);
                        if (cropRect != null) {
                            mPDFViewCtrl.convertPdfRectToPageViewRect(cropRect, cropRect, pageIndex);
                            mPDFViewCtrl.convertPageViewRectToDisplayViewRect(cropRect, cropRect, pageIndex);
                            rectF.intersect(cropRect);
                        }
                    } catch (PDFException ignored) {
                    }
                }
            }

            int space = AppDisplay.dp2px(12.0f);
            ViewGroup parent = mUIExtensionsManager.getRootView();
            int height = parent.getHeight();
            int width = parent.getWidth();

//            int[] location = new int[2];
//            parent.getLocationOnScreen(location);
            int x = 0;
            int y = 0;
            if (SystemUiHelper.getInstance().isStatusBarShown(mUIExtensionsManager.getAttachedActivity())) {
                y = SystemUiHelper.getInstance().getStatusBarHeight(mContext);
                rectF.top += y;
                rectF.bottom += y;
            }

            float expandRight = rectF.right + space + x;
            if (rectF.right < 0 && expandRight > 0) {
                expandRight = 0;
            }
            float expandLeft = rectF.left - space + x;
            if (rectF.left > 0 && expandLeft < 0) {
                expandLeft = 0;
            }
            float expandTop = rectF.top - space;
            if (rectF.top > 0 && expandTop < 0) {
                expandTop = 0;
            }
            float expandBottom = rectF.bottom + space;
            if (rectF.bottom < 0 && expandBottom > 0) {
                expandBottom = 0;
            }

            RectF expandRectF = new RectF(expandLeft, expandTop, expandRight, expandBottom);
            if (expandRectF.top >= mPopupWindow.getContentView().getMeasuredHeight() + y) {
                mShowingPosition = SHOWING_TOP;
                mPopupWindow.update((int) (expandRectF.right - (expandRectF.right - expandRectF.left) / 2 - mPopupWindow.getContentView().getMeasuredWidth() / 2.0f),
                        (int) (expandRectF.top - mPopupWindow.getContentView().getMeasuredHeight()), -1, -1);
            } else if (height - expandRectF.bottom >= (mPopupWindow.getContentView().getMeasuredHeight())) {
                mShowingPosition = SHOWING_BOTTOM;
                mPopupWindow.update((int) (expandRectF.right - (expandRectF.right - expandRectF.left) / 2 - mPopupWindow.getContentView().getMeasuredWidth() / 2.0f),
                        (int) (expandRectF.bottom), -1, -1);
            } else if (width + x - expandRectF.right >= mPopupWindow.getContentView().getMeasuredWidth()) {
                mShowingPosition = SHOWING_RIGHT;
                mPopupWindow.update((int) (expandRectF.right),
                        (int) (expandRectF.bottom - mPopupWindow.getContentView().getMeasuredHeight() / 2.0f - (expandRectF.bottom - expandRectF.top) / 2), -1, -1);
            } else if (expandRectF.left >= mPopupWindow.getContentView().getMeasuredWidth()) {
                mShowingPosition = SHOWING_LEFT;
                mPopupWindow.update((int) (expandRectF.left - mPopupWindow.getContentView().getMeasuredWidth()),
                        (int) (expandRectF.bottom - mPopupWindow.getContentView().getMeasuredHeight() / 2.0f - (expandRectF.bottom - expandRectF.top) / 2), -1, -1);
            } else {
                mShowingPosition = SHOWING_CENTER;
                mPopupWindow.update((int) (expandRectF.right - (expandRectF.right - expandRectF.left) / 2 - mPopupWindow.getContentView().getMeasuredWidth() / 2.0f),
                        (int) (expandRectF.bottom - mPopupWindow.getContentView().getMeasuredHeight() / 2.0f - (expandRectF.bottom - expandRectF.top) / 2), -1, -1);
            }

            if (mShowing) {
                int top = y;
                int left = x;
                int right = width + x;
                int bottom = height /*+ y*/;
                if (isShowing()) {
                    if (expandRectF.bottom <= top || expandRectF.right <= left || expandRectF.left >= right || expandRectF.top >= bottom) {
                        mPopupWindow.dismiss();
                    }
                } else {
                    RectF screenRectF = new RectF(left, top, right, bottom);
                    if (RectF.intersects(expandRectF, screenRectF)) {
                        boolean showing = mShowing;
                        show(rectF);
                        mShowing = showing;
                    }
                }
            }
        }
    }

    @Override
    public void update(RectF rectF, int pageWidth, int pageHeight, boolean autoDismiss) {
        if (mMenuItems != null && mMenuItems.size() > 0 || mExtensoinMenuItems != null && mExtensoinMenuItems.size() > 0) {
            if (mPDFViewCtrl.getCropMode() != PDFViewCtrl.CROPMODE_NONE) {
                Annot curAnnot = mUIExtensionsManager.getDocumentManager().getCurrentAnnot();
                if (curAnnot != null && !curAnnot.isEmpty()) {
                    try {
                        int pageIndex = curAnnot.getPage().getIndex();
                        RectF cropRect = mPDFViewCtrl.getCropRect(pageIndex);
                        if (cropRect != null) {
                            mPDFViewCtrl.convertPdfRectToPageViewRect(cropRect, cropRect, pageIndex);
                            mPDFViewCtrl.convertPageViewRectToDisplayViewRect(cropRect, cropRect, pageIndex);
                            rectF.intersect(cropRect);
                        }
                    } catch (PDFException ignored) {
                    }
                }
            }

            int space = AppDisplay.dp2px(12.0f);
            ViewGroup parent = mUIExtensionsManager.getRootView();
//            int[] location = new int[2];
//            parent.getLocationOnScreen(location);
            int x = 0;
            int y = 0;
            if (SystemUiHelper.getInstance().isStatusBarShown(mUIExtensionsManager.getAttachedActivity())) {
                y = SystemUiHelper.getInstance().getStatusBarHeight(mContext);
                rectF.top += y;
                rectF.bottom += y;
            }

            float expandLeft = rectF.left - space + x;
            if (rectF.left > 0 && expandLeft < 0) {
                expandLeft = 0;
            }
            float expandRight = rectF.right + space + x;
            if (rectF.right < 0 && expandRight > 0) {
                expandRight = 0;
            }
            float expandTop = rectF.top - space;
            if (rectF.top > 0 && expandTop < 0) {
                expandTop = 0;
            }
            float expandBottom = rectF.bottom + space;
            if (rectF.bottom < 0 && expandBottom > 0) {
                expandBottom = 0;
            }
            RectF expandRectF = new RectF(expandLeft, expandTop, expandRight, expandBottom);

            if (expandRectF.top >= mPopupWindow.getContentView().getMeasuredHeight() + y) {
                mShowingPosition = SHOWING_TOP;
                mPopupWindow.update((int) (expandRectF.right - (expandRectF.right - expandRectF.left) / 2 - mPopupWindow.getContentView().getMeasuredWidth() / 2.0f),
                        (int) (expandRectF.top - mPopupWindow.getContentView().getMeasuredHeight()), -1, -1);
            } else if (pageHeight + y - expandRectF.bottom >= mPopupWindow.getContentView().getMeasuredHeight()) {
                mShowingPosition = SHOWING_BOTTOM;
                mPopupWindow.update((int) (expandRectF.right - (expandRectF.right - expandRectF.left) / 2 - mPopupWindow.getContentView().getMeasuredWidth() / 2.0f),
                        (int) (expandRectF.bottom), -1, -1);
            } else if (pageWidth + x - expandRectF.right >= mPopupWindow.getContentView().getMeasuredWidth()) {
                mShowingPosition = SHOWING_RIGHT;
                mPopupWindow.update((int) (expandRectF.right),
                        (int) (expandRectF.bottom - mPopupWindow.getContentView().getMeasuredHeight() / 2.0f - (expandRectF.bottom - expandRectF.top) / 2), -1, -1);
            } else if (expandRectF.left >= mPopupWindow.getContentView().getMeasuredWidth()) {
                mShowingPosition = SHOWING_LEFT;
                mPopupWindow.update((int) (expandRectF.left - mPopupWindow.getContentView().getMeasuredWidth()),
                        (int) (expandRectF.bottom - mPopupWindow.getContentView().getMeasuredHeight() / 2.0f - (expandRectF.bottom - expandRectF.top) / 2), -1, -1);
            } else {
                mShowingPosition = SHOWING_CENTER;
                mPopupWindow.update((int) (expandRectF.right - (expandRectF.right - expandRectF.left) / 2 - mPopupWindow.getContentView().getMeasuredWidth() / 2.0f),
                        (int) (expandRectF.bottom - mPopupWindow.getContentView().getMeasuredHeight() / 2.0f - (expandRectF.bottom - expandRectF.top) / 2), -1, -1);
            }
            if (autoDismiss) {
                if (mShowing) {
                    int top = y;
                    int left = x;
                    int right = pageWidth + x;
                    int bottom = pageHeight /*+ y*/;
                    if (isShowing()) {
                        if (expandRectF.bottom <= top || expandRectF.right <= left || expandRectF.left >= right || expandRectF.top >= bottom) {
                            mPopupWindow.dismiss();
                        }
                    } else {
                        RectF screenRectF = new RectF(left, top, right, bottom);
                        if (RectF.intersects(expandRectF, screenRectF)) {
                            boolean showing = mShowing;
                            show(rectF, pageWidth, pageHeight, autoDismiss);
                            mShowing = showing;
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean isShowing() {
        if (mPopupWindow != null) {
            return mPopupWindow.isShowing();
        } else {
            return false;
        }
    }

    @Override
    public void dismiss() {
        if (mPopupWindow != null && mPopupWindow.isShowing()) {
            mPopupWindow.dismiss();
            mShowing = false;
        }
    }

    @Override
    public void setListener(ClickListener listener) {
        mListener = listener;
    }

    @Override
    public int getShowingPosition() {
        return mShowingPosition;
    }

    private int[] getViewLocationOnScreen(View view) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        Rect visibleRect = new Rect();
        view.getGlobalVisibleRect(visibleRect);
        if (location[1] != visibleRect.top) {
            location[1] = visibleRect.top;
        }
        return location;
    }
}
