/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.propertybar;

import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.RectF;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import com.foxit.sdk.common.Constants;
import com.foxit.uiextensions.annots.note.NoteConstants;


public interface PropertyBar {
    public interface PropertyChangeListener {
        public void onValueChanged(long property, int value);

        public void onValueChanged(long property, float value);

        public void onValueChanged(long property, String value);
    }

    interface CreatePropertyChangedListener {
        void onCreateValueChanged(long property, Object value);

        int getToolType();

        int getTabPosition();

        void resetToolPropertyBar();
    }

    public interface DismissListener {
        public void onDismiss();
    }

    interface IOnShowListener {
        void onShow(PropertyBar propertyBar);
    }

    long PROPERTY_UNKNOWN = 0x00000000L;
    long PROPERTY_COLOR = 0x00000001L;
    long PROPERTY_OPACITY = 0x00000002L;
    long PROPERTY_LINEWIDTH = 0x00000004L;
    long PROPERTY_MAX_LINEWIDTH = 0x000000041L;
    long PROPERTY_MIN_LINEWIDTH = 0x000000042L;

    long PROPERTY_FONTNAME = 0x00000008L;
    long PROPERTY_FONTSIZE = 0x00000010L;
    long PROPERTY_LINE_STYLE = 0x00000020L;
    long PROPERTY_ANNOT_TYPE = 0x00000040L;
    long PROPERTY_SELF_COLOR = 0x00000080L;
    long PROPERTY_SCALE_PERCENT = 0x00000100L;
    long PROPERTY_SCALE_SWITCH = 0x00000200L;
    long PROPERTY_ROTATION = 0x00000400L;
    long PROPERTY_RADIO_NAME = 0x00000800L;

    long PROPERTY_DISTANCE = 0x00001000L;
    long PROPERTY_DISTANCE_TIP = 0x00001002L;
    long PROPERTY_DISTANCE_VALUE = 0x00001004L;
    long PROPERTY_DISTANCE_TIP_VALUE = 0x0001008L;
    long PROPERTY_DISTANCE_DISPLAY = 0x00002000L;

    long PROPERTY_FILEATTACHMENT = 0x00004000L;
    long PROPERTY_OPTIONS = 0x00008000L;
    long PROPERTY_STAMP = 0x00010000L;
    long PROPERTY_PENCIL_TYPE = 0x00020000L;
    long PROPERTY_OVERLAY_TEXT = 0x00040000L;
    long PROPERTY_FILL_COLOR = 0x00080000L;
    long PROPERTY_AUTO_FONTSIZE = 0x00100000L;
    long PROPERTY_LIST_NUMBER = 0x00200000L;
    long PROPERTY_LIST_SYMBOL = 0x00400000L;
    long PROPERTY_ALIGNMENT = 0x00800000L;
    long PROPERTY_FONTSTYLE = 0x01000000L;
    long PROPERTY_FONTNAME_2 = 0x02000000L;
    long PROPERTY_FONTSIZE_2 = 0x04000000L;
    // font style mask
    long PROPERTY_FONT_BOLD     = 0x08000000L;
    long PROPERTY_FONT_ITALIC   = 0x10000000L;
    long PROPERTY_FONTNAME_LIST   = 0x20000000L;
    long PROPERTY_FONTSIZE_LIST  = 0x40000000L;
    long PROPERTY_LINEWIDTH_2 = 0x80000000L;
    long PROPERTY_ERASERSHAPE = 0x80000001L;
    long PROPERTY_PEN_ONLY = 0x100000000L;
    long PROPERTY_ALL = 0x000003FFL;

    int ARROW_NONE = 0;
    int ARROW_LEFT = 1;
    int ARROW_TOP = 2;
    int ARROW_RIGHT = 3;
    int ARROW_BOTTOM = 4;
    int ARROW_CENTER = 5;

    int[] PB_COLORS_TOOL_DEFAULT = new int[]{Color.argb(255, 254, 0, 0),
            Color.argb(255, 255, 255, 0),
            Color.argb(255, 0, 0, 255),
            Color.argb(255, 102, 204, 51),
            Color.argb(255, 153, 51, 153),
            Color.argb(255, 255, 255, 255),
            Color.argb(255, 0, 0, 0)
    };

    int[] PB_COLORS_TOOL_2 = new int[]{Color.argb(255, 0, 0, 0),
            Color.argb(255, 111, 50, 46),
            Color.argb(255, 33, 89, 104),
            Color.argb(255, 79, 98, 41),
            Color.argb(255, 0, 0, 102),
            Color.argb(255, 96, 74, 123),
            Color.argb(255, 119, 119, 119)
    };

    int[] PB_FILLCOLORS_TOOL_DEFAULT = new int[]{
            Color.argb(0, 0, 0, 0),
            Color.argb(255, 254, 0, 0),
            Color.argb(255, 255, 255, 0),
            Color.argb(255, 0, 0, 255),
            Color.argb(255, 102, 204, 51),
            Color.argb(255, 153, 51, 153),
            Color.argb(255, 255, 255, 255)
    };


    int[] PB_COLORS_SIGN = PB_COLORS_TOOL_2;
    int[] PB_OPACITYS = new int[]{25, 50, 75, 100};
    int[] PB_ROTAIIONS = new int[]{Constants.e_Rotation0, Constants.e_Rotation90, Constants.e_Rotation180, Constants.e_Rotation270};
    float PB_FONTSIZE_DEFAULT = 24.0f;
    float[] PB_FONTSIZES = new float[]{6.0f, 8.0f, 10.0f, 12.0f, 18.0f, PB_FONTSIZE_DEFAULT, 36.0f, 48.0f, 64.0f, 72.0f, 96.0f, 144.0f};

    int[] ICONTYPES = new int[]{NoteConstants.TA_ICON_COMMENT, NoteConstants.TA_ICON_KEY, NoteConstants.TA_ICON_NOTE, NoteConstants.TA_ICON_HELP, NoteConstants.TA_ICON_NEWPARAGRAPH, NoteConstants.TA_ICON_PARAGRAPH, NoteConstants.TA_ICON_INSERT};

    float PB_ALPHA = 0.6f;

    public static final int SYMBOL_NONE = 0;
    public static final int SYMBOL_OVAL = 1;
    public static final int SYMBOL_RECT = 2;
    public static final int SYMBOL_DIAMOND = 3;
    public static final int SYMBOL_CHECK = 4;
    public static final int SYMBOL_STAR = 5;
    public static final int SYMBOL_ARROW = 6;

    public static final int NUMBER_STYLE_NONE = 0;
    public static final int NUMBER_STYLE_1 = 1;
    public static final int NUMBER_STYLE_2 = 2;
    public static final int NUMBER_STYLE_3 = 3;
    public static final int NUMBER_STYLE_4 = 4;
    public static final int NUMBER_STYLE_5 = 5;

    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_MID = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_JUSTIFY = 3;

    void setColors(int[] colors);

    void setFillColors(int[] colors);

    void setProperty(long property, int value);

    int getInt(long property);

    void setProperty(long property, float value);

    void setProperty(long property, float[] values);

    void setProperty(long property, String value);

    String getString(long property);

    void clearPropertyTitle();

    void setPropertyTitle(long property, String title);

    void setArrowColor(int color);

    void setArrowVisible(boolean visible);

    void setPhoneFullScreen(boolean fullScreen);

    void reset(long items);

    void reset(long items, boolean clearCustomProperty);

    long getProperties();

    void setTitleVisible(boolean visible);

    void setSubTitleVisible(boolean visible);

    void addTab(String title, int index);

    void addTab(String topTitle, int resid_img, String title, int index);

    int getItemIndex(long item);

    void addCustomItem(long item, View itemView, int tabIndex, int index);

    void addContentView(View contentView);

    LinearLayout getContentView();

    ViewGroup getRootView();

    int getCurrentTabIndex();

    void setCurrentTab(int currentTab);

    void show(RectF rectF, boolean showMask);

    void show(RectF rectF, boolean showMask, int arrowPosition);

    void show(ViewGroup anchor, RectF rectF, boolean showMask);

    void show(ViewGroup anchor, RectF rectF, boolean showMask, int arrowPosition);

    void show(ViewGroup anchor, RectF rectF, int width, int height, int arrowPosition);

    void update();

    void update(RectF rectF);

    void update(RectF rectF, int arrowPosition);

    void update(ViewGroup parent, RectF rectF);

    void dismiss();

    boolean isShowing();

    PropertyChangeListener getPropertyChangeListener();

    void setPropertyChangeListener(PropertyChangeListener listener);

    void setCustomPropertyChangeListener(PropertyChangeListener listener);

    PropertyChangeListener getCustomPropertyChangeListener();

    void setDismissListener(DismissListener dismissListener);

    void scaleFromUnit(int index);

    void scaleFromValue(float value);

    void scaleToUnit(int index);

    void scaleToValue(float value);

    void setDistanceScale(String[] distanceScale);

    void setEditable(boolean canEdit);

    void requestLayout();

    void setShowOnKeyboard(boolean value);

    void setDismissWithResetProperties(boolean reset);

    void setScrollingEnabled(boolean enabled);

    void updateTheme();

    void setAutoResetSystemUiOnDismiss(boolean auto);

    void setAutoResetSystemUiOnShow(boolean auto);

    void setMaxHeight(int height); //for pad

    void setShowWidth(int width);//for pad

    int getShowWidth();

    void resetContentHeight();

    void setOnKeyListener(DialogInterface.OnKeyListener onKeyListener); // for full screen mode

    void setOnShowListener(IOnShowListener showListener);

    Object getTag();

    void setTag(Object tag);
}
