/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.propertybar;

import android.graphics.RectF;
import android.view.View;
import android.widget.PopupWindow;

import java.util.ArrayList;

public interface AnnotMenu {
    public static final int SHOWING_TOP = 1;
    public static final int SHOWING_LEFT = 2;
    public static final int SHOWING_BOTTOM = 3;
    public static final int SHOWING_RIGHT = 4;
    public static final int SHOWING_CENTER = 5;

    public static interface ClickListener {
        public void onAMClick(int btType);
    }

    public static final int AM_BT_COPY = 1;
    public static final int AM_BT_DELETE = 2;
    public static final int AM_BT_COMMENT = 3;
    public static final int AM_BT_REPLY = 4;
    public static final int AM_BT_EDIT = 5;
    public static final int AM_BT_STYLE = 6;

    public static final int AM_BT_HIGHLIGHT = 7;
    public static final int AM_BT_UNDERLINE = 8;
    public static final int AM_BT_STRIKEOUT = 9;
    public static final int AM_BT_SQUIGGLY = 10;
    public static final int AM_BT_NOTE = 11;
    public static final int AM_BT_TYPEWRITER = 12;

    public static final int AM_BT_SIGN_LIST = 13;
    public static final int AM_BT_SIGN = 14;
    public static final int AM_BT_CANCEL = 15;
    public static final int AM_BT_VERIFY_SIGNATURE = 16;

    public static final int AM_BT_PALY = 17;
    public static final int AM_BT_FLATTEN = 18;
    public static final int AM_BT_REDACT = 19;
    public static final int AM_BT_SIGNATURE = 20;
    public static final int AM_BT_APPLY = 21;

    public static final int AM_BT_TTS = 22;
    public static final int AM_BT_TTS_STRING = 23;
    public static final int AM_BT_TTS_START = 24;

    public static final int AM_BT_GROUP = 25;
    public static final int AM_BT_UNGROUP = 26;

    public static final int AM_BT_SELECT_ALL = 27;
    public static final int AM_BT_ROTATE = 28;
    public static final int AM_BT_REPLACE = 29;
    public static final int AM_BT_EXPORT = 30;
    public static final int AM_BT_ROTATE_CLOCKWISE = 31;
    public static final int AM_BT_ROTATE_COUNTERCLOCKWISE = 32;
    public static final int AM_BT_GALERY = 33;
    public static final int AM_BT_CAMERA = 34;
    public static final int AM_BT_ADD_IMAGE = 35;
    public static final int AM_BT_ADD_TEXT = 36;
    public static final int AM_BT_RECORD_AUDIO = 37;
    public static final int AM_BT_CHOOSE_AUDIO = 38;
    public static final int AM_BT_RECORD_VIDEO = 39;
    public static final int AM_BT_SELECT = 40;
    public static final int AM_BT_PASTE = 41;
    public static final int AM_BT_PENCIL = 42;
    public static final int AM_BT_CLEAR = 43;
    public static final int AM_BT_FILE = 44;
    public static final int AM_BT_INK_RECOGNIZE_TEXT = 45;

    public static final int AM_BT_RECOGNIZE_TEXT = 101;

    public static final int PM_BT_CUT = 901;
    public static final int PM_BT_COPY = 902;
    public static final int PM_BT_PASTE = 903;
    public static final int PM_BT_DELETE = 904;
    public static final int PM_BT_SELECT_ALL = 905;
    public static final int PM_BT_INDEX_OFFSET = 900;

    public PopupWindow getPopupWindow();

    public void setMenuItems(ArrayList<Integer> menuItems);

    public void setExtensionMenuItems(ArrayList<MenuItem> menuItems);

    public void setShowAlways(boolean showAlways);

    public void show(RectF rectF);

    public void show(RectF rectF, int pageWidth, int pageHeight, boolean autoDismiss);

    public void show(RectF rectF, View view);

    public void update(RectF rectF);

    public void update(RectF rectF, int pageWidth, int pageHeight, boolean autoDismiss);

    public void dismiss();

    public boolean isShowing();

    public void setListener(ClickListener listener);

    public int getShowingPosition();
}
