/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.dialog.sheetmenu;


import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;

public interface IActionMenu {
    interface OnActionMenuDismissListener {
        /**
         * This method will be invoked when the dialog is dismissed.
         *
         * @param actionMenu the dialog that was dismissed will be passed into the
         *                   method
         */
        void onDismiss(IActionMenu actionMenu);
    }


    void show(ViewGroup parent, Rect rect, int arrowPos, int arrowDist);

    public void update(ViewGroup parent, Rect rect, int width, int height);

    public void update(ViewGroup parent, Rect rect, int width, int height, int arrowPos);

    public void update(ViewGroup parent, int x, int y, int width, int height);

    void dismiss();

    int getSliderHeight();

    boolean isShowing();

    void setWidth(int width);

    void setHeight(int height);

    void setOnDismissListener(OnActionMenuDismissListener dismissListener);

    void setContentView(View view);

    void setShowOnKeyboard(boolean show);

    void setScrollingEnabled(boolean enabled);

    void setAutoResetSystemUiOnDismiss(boolean auto);

    void setAutoResetSystemUiOnShow(boolean auto);

    void setArrowColor(int color); //for pad

}
