/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnCancelListener;
import android.content.DialogInterface.OnDismissListener;
import android.view.View;
import android.view.ViewGroup.LayoutParams;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppUtil;
import com.foxit.uiextensions.utils.SystemUiHelper;
import com.foxit.uiextensions.utils.UIMarqueeTextView;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.IntDef;


public class UIDialog {
    public static final int NO_INPUT = 0;
    public static final int WITH_INPUT = 1;

    @IntDef({
            NO_INPUT,
            WITH_INPUT})
    @Retention(RetentionPolicy.SOURCE)
    public @interface ShowType {
    }

    Activity mAct;
    protected Dialog mDialog;
    protected View mContentView;
    protected UIMarqueeTextView mTitleView;
    private OnDismissListener mOnDismissListener;

    public UIDialog(Context context, int layoutId, int theme, int width) {
        mAct = (Activity) context;
        mDialog = new Dialog(context, theme);
        mContentView = View.inflate(context.getApplicationContext(), layoutId, null);
        mTitleView = (UIMarqueeTextView) mContentView.findViewById(R.id.fx_dialog_title);

        mDialog.setContentView(mContentView, new LayoutParams(width, LayoutParams.WRAP_CONTENT));
        mDialog.setCanceledOnTouchOutside(true);
        mDialog.setOnDismissListener(new OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialog) {
                if (SystemUiHelper.getInstance().isFullScreen()
                        && SystemUiHelper.getInstance().isAllowedHideSystemUI()) {
                    SystemUiHelper.getInstance().hideSystemUI(mAct);
                }
                if (mOnDismissListener != null)
                    mOnDismissListener.onDismiss(dialog);
            }
        });
        mDialog.setOnShowListener(new DialogInterface.OnShowListener() {
            @Override
            public void onShow(DialogInterface dialog) {
                if (SystemUiHelper.getInstance().isFullScreen()) {
                    if (AppDisplay.isPad())
                        SystemUiHelper.getInstance().hideSystemUI(getDialog().getWindow());
                    else
                        SystemUiHelper.getInstance().hideStatusBar(getDialog().getWindow());
                    mContentView.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            SystemUiHelper.getInstance().hideSystemUI(mAct);
                        }
                    }, 60);
                }
            }
        });
        AppUtil.fixBackgroundRepeat(mContentView);
    }

    public UIDialog(Context context, int layoutId, int theme) {
        mDialog = new Dialog(context, theme);
        mContentView = View.inflate(context.getApplicationContext(), layoutId, null);
        mTitleView = (UIMarqueeTextView) mContentView.findViewById(R.id.fx_dialog_title);

        mDialog.setContentView(mContentView, new LayoutParams(AppDisplay.getDialogWidth(), LayoutParams.WRAP_CONTENT));
        mDialog.setCanceledOnTouchOutside(true);
        AppUtil.fixBackgroundRepeat(mContentView);
    }

    public Dialog getDialog() {
        return mDialog;
    }

    public View getTitleView() {
        return mTitleView;
    }

    public View getContentView() {
        return mContentView;
    }

    public void setTitle(String title) {
        if (null != title) {
            mTitleView.setText(title);
        }
    }

    public void setTitle(int title) {
        mTitleView.setText(title);
    }

    public void show() {
        AppDialogManager.getInstance().showAllowManager(mDialog, null);
    }

    public void dismiss() {
        AppDialogManager.getInstance().dismiss(mDialog);
    }

    public void setOnDismissListener(OnDismissListener listener) {
        this.mOnDismissListener = listener;
    }

    public void setOnCancelListener(OnCancelListener listener) {
        mDialog.setOnCancelListener(listener);
    }
}
