/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.browser.adapter.SuperAdapter;
import com.foxit.uiextensions.browser.adapter.viewholder.SuperViewHolder;
import com.foxit.uiextensions.modules.panel.bean.BaseBean;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppDisplay;

import java.util.ArrayList;

public class RoundCornerDialog {
    private Dialog mDialog;
    private ArrayList<ItemBean> mItems = new ArrayList<>();
    private IDialogItemClickListener mListener;
    private int[] mSelectedIndexArray;
    public RoundCornerDialog(Activity activity, @NonNull CharSequence[] items, IDialogItemClickListener listener) {
        mDialog = new Dialog(activity);
        View mContentView = View.inflate(activity.getApplicationContext(), R.layout.round_coner_dialog_layout, null);
        for (CharSequence item : items) {
            ItemBean itemBean = new ItemBean();
            itemBean.mInfo = item;
            mItems.add(itemBean);
        }

        mListener = listener;
        RecyclerView recyclerView = mContentView.findViewById(R.id.rv_round_coner_list);
        recyclerView.setLayoutManager(new LinearLayoutManager(activity.getApplicationContext(), LinearLayoutManager.VERTICAL, false));
        recyclerView.setItemAnimator(new DefaultItemAnimator());
        RoundCornerAdpater adapter = new RoundCornerAdpater(activity.getApplicationContext());
        recyclerView.setAdapter(adapter);

        int width = -1;
        if (AppDisplay.isPad()) {
            width = Math.min(AppDisplay.getActivityHeight(), AppDisplay.getActivityWidth()) * 2 / 5;
        } else {
            if (AppDisplay.isLandscape()) {
                width = AppDisplay.getActivityHeight() * 2 / 3;
            } else {
                width = AppDisplay.getActivityWidth() * 2 / 3;
            }
        }
        mDialog.getWindow().setBackgroundDrawableResource(android.R.color.transparent);
        mDialog.setContentView(mContentView, new ViewGroup.LayoutParams(width, ViewGroup.LayoutParams.WRAP_CONTENT));
        mDialog.setCanceledOnTouchOutside(true);
    }

    public void show() {
        mDialog.show();
    }

    public void dismiss() {
        mDialog.dismiss();
    }

    //should call before #show
    public void setSelectedItems(int[] indexArray) {
        mSelectedIndexArray = indexArray;
    }

    class RoundCornerAdpater extends SuperAdapter {
        public RoundCornerAdpater(Context context) {
            super(context);
        }

        @Override
        public void notifyUpdateData() {
            notifyDataSetChanged();
        }

        @Override
        public BaseBean getDataItem(int position) {
            return mItems.get(position);
        }

        @NonNull
        @Override
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new ItemViewHolder(LayoutInflater.from(getContext()).inflate(R.layout.setting_list_layout, parent, false));
        }

        @Override
        public int getItemCount() {
            return mItems.size();
        }
    }

    class ItemViewHolder extends SuperViewHolder {
        private View mItemContainer;
        private TextView mInfo;
        private ImageView mSelectedIcon;
        public ItemViewHolder(View itemView) {
            super(itemView);
            mItemContainer = itemView.findViewById(R.id.setting_list_container);

            mInfo = itemView.findViewById(R.id.setting_list_text);
            mSelectedIcon = itemView.findViewById(R.id.setting_list_selected);
            ThemeUtil.setTintList(mSelectedIcon, ThemeUtil.getPrimaryIconColor(context));

            mItemContainer.setOnClickListener(this);
        }

        @Override
        public void bind(BaseBean data, int position) {
            mInfo.setText(((ItemBean) data).mInfo);
            int visible = View.INVISIBLE;
            if (mSelectedIndexArray != null) {
                for (int i = 0; i < mSelectedIndexArray.length; i++) {
                    if (position == mSelectedIndexArray[i]) {
                       visible = View.VISIBLE;
                       mSelectedIcon.setSelected(true);
                       break;
                    }
                }
            }

            mSelectedIcon.setVisibility(visible);
        }

        @Override
        public void onClick(View v) {
            if (mListener != null) {
                mListener.onClick(RoundCornerDialog.this, getAdapterPosition());
            }
        }
    }

    class ItemBean extends BaseBean {
        CharSequence mInfo;
    }

    public interface IDialogItemClickListener {
        void onClick(RoundCornerDialog dialog, int which);
    }
}
