/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.config.optimizations;


import com.foxit.uiextensions.config.Config;
import com.foxit.uiextensions.utils.JsonUtil;

import org.json.JSONException;
import org.json.JSONObject;

public class OptimizationsConfig {
    private static final String KEY_OPTIMIZE_EMBEDDED_FONTS = "optimizeEmbeddedFontsForAnnots";

    public boolean optimizeEmbeddedFontsForAnnots = false;

    public void parseConfig(JSONObject jsonObject) {
        try {
            JSONObject object = jsonObject.getJSONObject(Config.KEY_OPTIMIZATIONS);
            optimizeEmbeddedFontsForAnnots = JsonUtil.getBoolean(object, KEY_OPTIMIZE_EMBEDDED_FONTS, false);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

