/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.config;


import android.content.Context;

import com.foxit.sdk.common.Constants;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.annots.fileattachment.FileAttachmentUtil;
import com.foxit.uiextensions.annots.ink.InkConstants;
import com.foxit.uiextensions.annots.line.DistanceMeasurement;
import com.foxit.uiextensions.annots.note.NoteUtil;
import com.foxit.uiextensions.config.uisettings.annotations.AnnotationsConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.AreaHighlightConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.ArrowConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.AttachmentConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.CalloutConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.CloudConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.HighlightConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.ImageConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.InsertConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.LineConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.MeasureConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.NoteConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.OvalConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.PencilConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.PolygonConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.PolylineConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.RectangleConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.ReplaceConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.SquigglyConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.StrikeoutConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.TextboxConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.TypewriterConfig;
import com.foxit.uiextensions.config.uisettings.annotations.annots.UnderlineConfig;
import com.foxit.uiextensions.controls.propertybar.PropertyBar;
import com.foxit.uiextensions.controls.toolbar.ToolConstants;
import com.foxit.uiextensions.controls.toolbar.ToolProperty;
import com.foxit.uiextensions.utils.AppDmUtil;
import com.foxit.uiextensions.utils.AppResource;

import java.util.ArrayList;

public class ConfigUtils {

    public static ToolProperty config2ToolBean(UIExtensionsManager uiExtensionsManager, @ToolConstants.ToolType int toolType) {
        Context context = uiExtensionsManager.getAttachedActivity().getApplicationContext();
        AnnotationsConfig annotationsConfig = uiExtensionsManager.getConfig().uiSettings.annotations;

        ToolProperty property = null;
        if (toolType == ToolConstants.Note) {
            property = new ToolProperty();
            property.type = toolType;

            NoteConfig config = annotationsConfig.note;
            property.color = config.color;
            property.opacity = (int) (config.opacity * 100);
            property.style = NoteUtil.getIconByIconName(config.icon);

        } else if (toolType == ToolConstants.Attachments) {
            property = new ToolProperty();
            property.type = toolType;

            AttachmentConfig config = annotationsConfig.attachment;
            property.color = config.color;
            property.opacity = (int) (config.opacity * 100);
            property.style = FileAttachmentUtil.getIconType(config.icon);

        } else if (toolType == ToolConstants.Stamp) {
            property = new ToolProperty();
            property.type = toolType;
            property.style = 0;
            property.color = AppResource.getColor(context, R.color.p3);

        } else if (toolType == ToolConstants.Typewriter) {
            property = new ToolProperty();
            property.type = toolType;

            TypewriterConfig config = annotationsConfig.typewriter;
            property.color = config.textColor;
            property.opacity = (int) (config.opacity * 100);
            property.fontName = getFontName(context, config.textFace);
            property.fontSize = config.textSize;

        } else if (toolType == ToolConstants.Callout) {
            property = new ToolProperty();
            property.type = toolType;

            CalloutConfig config = annotationsConfig.callout;
            property.color = config.textColor;
            property.opacity = (int) (config.opacity * 100);
            property.fontName = getFontName(context, config.textFace);
            property.fontSize = config.textSize;

        } else if (toolType == ToolConstants.Textbox) {
            property = new ToolProperty();
            property.type = toolType;

            TextboxConfig config = annotationsConfig.textbox;
            property.color = config.textColor;
            property.opacity = (int) (config.opacity * 100);
            property.fontName = getFontName(context, config.textFace);
            property.fontSize = config.textSize;

        } else if (toolType == ToolConstants.Highlight) {
            property = new ToolProperty();
            property.type = toolType;

            HighlightConfig config = annotationsConfig.highlight;
            property.color = config.color;
            property.opacity = AppDmUtil.opacity100To255((int) (config.opacity * 100));

        } else if (toolType == ToolConstants.Area_Highlight) {
            property = new ToolProperty();
            property.type = toolType;

            AreaHighlightConfig config = annotationsConfig.areaHighlight;
            property.color = config.color;
            property.opacity = AppDmUtil.opacity100To255((int) (config.opacity * 100));

        } else if (toolType == ToolConstants.Underline) {
            property = new ToolProperty();
            property.type = toolType;

            UnderlineConfig config = annotationsConfig.underline;
            property.color = config.color;
            property.opacity = AppDmUtil.opacity100To255((int) (config.opacity * 100));

        } else if (toolType == ToolConstants.Squiggly) {
            property = new ToolProperty();
            property.type = toolType;

            SquigglyConfig config = annotationsConfig.squiggly;
            property.color = config.color;
            property.opacity = AppDmUtil.opacity100To255((int) (config.opacity * 100));

        } else if (toolType == ToolConstants.Strikeout) {
            property = new ToolProperty();
            property.type = toolType;

            StrikeoutConfig config = annotationsConfig.strikeout;
            property.color = config.color;
            property.opacity = AppDmUtil.opacity100To255((int) (config.opacity * 100));

        } else if (toolType == ToolConstants.Replace_Text) {
            property = new ToolProperty();
            property.type = toolType;

            ReplaceConfig config = annotationsConfig.replace;
            property.color = config.color;
            property.opacity = (int) (config.opacity * 100);

        } else if (toolType == ToolConstants.Insert_Text) {
            property = new ToolProperty();
            property.type = toolType;

            InsertConfig config = annotationsConfig.insert;
            property.color = config.color;
            property.opacity = (int) (config.opacity * 100);

        } else if (toolType == ToolConstants.Image_Annotation) {
            property = new ToolProperty();
            property.type = toolType;

            ImageConfig config = annotationsConfig.image;
            int[] rotations = new int[]{0, 90, 180, 270};
            int rotation = Constants.e_Rotation0;
            for (int i = 0; i < rotations.length; i++) {
                if (rotations[i] == config.rotation) {
                    rotation = i;
                    break;
                }
            }
            property.rotation = rotation;
            property.opacity = (int) (config.opacity * 100);
            property.color = AppResource.getColor(context, R.color.p3);

        } else if (toolType == ToolConstants.Pencil) {
            property = new ToolProperty();
            property.type = toolType;

            PencilConfig config = annotationsConfig.pencil;
            property.color = config.color;
            property.opacity = (int) (config.opacity * 100);
            property.lineWidth = config.thickness;
            property.style = InkConstants.PENCIL_WITH_PEN;

        } else if (toolType == ToolConstants.Highlighter) {
            property = new ToolProperty();
            property.type = toolType;
            property.color = PropertyBar.PB_COLORS_TOOL_DEFAULT[1];
            property.opacity = 50;
            property.lineWidth = 12f;
            property.style = InkConstants.PENCIL_WITH_PEN;

        } else if (toolType == ToolConstants.Eraser) {
            property = new ToolProperty();
            property.type = toolType;
            property.color = PropertyBar.PB_COLORS_TOOL_DEFAULT[1];
            property.lineWidth = 18f;
            property.color = AppResource.getColor(context, R.color.p3);
            property.eraserShape = InkConstants.ERASER_SHAPE_PARTIAL;

        } else if (toolType == ToolConstants.Rectangle) {
            property = new ToolProperty();
            property.type = toolType;

            RectangleConfig config = annotationsConfig.rectangle;
            property.color = config.color;
            property.opacity = (int) (config.opacity * 100);
            property.lineWidth = config.thickness;

        } else if (toolType == ToolConstants.Oval) {
            property = new ToolProperty();
            property.type = toolType;

            OvalConfig config = annotationsConfig.oval;
            property.color = config.color;
            property.opacity = (int) (config.opacity * 100);
            property.lineWidth = config.thickness;

        } else if (toolType == ToolConstants.Measure) {
            property = new ToolProperty();
            property.type = toolType;

            MeasureConfig config = annotationsConfig.measure;
            property.color = config.color;
            property.opacity = (int) (config.opacity * 100);
            property.lineWidth = config.thickness;
            ArrayList<String> unitStrings = fakeDate();
            if (unitStrings.contains(config.scaleFromUnit))
                property.scaleFromUnitIndex = unitStrings.indexOf(config.scaleFromUnit);
            if (unitStrings.contains(config.scaleToUnit))
                property.scaleToUnitIndex = unitStrings.indexOf(config.scaleToUnit);
            property.scaleFromValue = config.scaleFromValue;
            property.scaleToValue = config.scaleToValue;

        } else if (toolType == ToolConstants.Line) {
            property = new ToolProperty();
            property.type = toolType;

            LineConfig config = annotationsConfig.line;
            property.color = config.color;
            property.opacity = (int) (config.opacity * 100);
            property.lineWidth = config.thickness;

        } else if (toolType == ToolConstants.Arrow) {
            property = new ToolProperty();
            property.type = toolType;

            ArrowConfig config = annotationsConfig.arrow;
            property.color = config.color;
            property.opacity = (int) (config.opacity * 100);
            property.lineWidth = config.thickness;

        } else if (toolType == ToolConstants.PolyLine) {
            property = new ToolProperty();
            property.type = toolType;

            PolylineConfig config = annotationsConfig.polyline;
            property.color = config.color;
            property.opacity = (int) (config.opacity * 100);
            property.lineWidth = config.thickness;

        } else if (toolType == ToolConstants.Polygon) {
            property = new ToolProperty();
            property.type = toolType;

            PolygonConfig config = annotationsConfig.polygon;
            property.color = config.color;
            property.opacity = (int) (config.opacity * 100);
            property.lineWidth = config.thickness;

        } else if (toolType == ToolConstants.Cloud) {
            property = new ToolProperty();
            property.type = toolType;

            CloudConfig config = annotationsConfig.cloud;
            property.color = config.color;
            property.opacity = (int) (config.opacity * 100);
            property.lineWidth = config.thickness;
        }
        return property;
    }

    private static ArrayList<String> fakeDate() {
        ArrayList<String> list = new ArrayList<>();
        for (DistanceMeasurement rest : DistanceMeasurement.values()) {
            list.add(rest.getName());
        }
        return list;
    }

    private static String getFontName(Context context, String configName) {
        String fontName = "Courier";
        String[] fontNames = new String[]{AppResource.getString(context, R.string.fx_font_courier),
                AppResource.getString(context, R.string.fx_font_helvetica),
                AppResource.getString(context, R.string.fx_font_times)};
        for (String name : fontNames) {
            if (name.equals(configName)) {
                fontName = name;
                break;
            }
        }
        return fontName;
    }

}
