/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.browser;


import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.browser.behavior.NestedHeaderBehavior;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppUtil;

import androidx.annotation.Nullable;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.recyclerview.widget.RecyclerView;

public class PullRecyclerView extends CoordinatorLayout {

    private final LinearLayout mHeaderView;
    private final RecyclerView mContentRV;
    private int mHeaderHeight;

    public PullRecyclerView(Context context) {
        this(context, null);
    }

    public PullRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);

        View view = LayoutInflater.from(context).inflate(R.layout.nested_scroll_behavior_layout, this);
        mHeaderView = view.findViewById(R.id.pull_header_layout);
        mContentRV = view.findViewById(R.id.pull_recycler_layout);
        mContentRV.setTag(NestedHeaderBehavior.SHOW);
        mHeaderHeight = AppDisplay.dp2px(45);
    }

    public void addHeaderView(View view) {
        AppUtil.removeViewFromParent(view);
        mHeaderView.addView(view, 0);
        mHeaderView.post(new Runnable() {
            @Override
            public void run() {
                mHeaderHeight = mHeaderView.getMeasuredHeight();
            }
        });
        mHeaderView.setAlpha(0);
        mContentRV.setTranslationY(-mHeaderHeight);
    }

    public void hideHeaderView() {
        mHeaderView.setAlpha(0);
        mContentRV.setTranslationY(-mHeaderHeight);
    }

    public void setHeaderState(@NestedHeaderBehavior.Type int state) {
        mContentRV.setTag(state);
        if (state == NestedHeaderBehavior.HIDE) {
            if (mContentRV.getTranslationY() == -mHeaderHeight) return;

            ObjectAnimator contentAnimator = ObjectAnimator.ofFloat(mContentRV,
                    "translationY", 0, -mHeaderHeight).setDuration(500);
            ObjectAnimator headerAnimator = ObjectAnimator.ofFloat(mHeaderView,
                    "alpha", 1, 0).setDuration(500);

            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.playTogether(contentAnimator, headerAnimator);
            animatorSet.start();
        } else if (state == NestedHeaderBehavior.FIXED) {
            if (mContentRV.getTranslationY() == 0) return;
            mContentRV.setTranslationY(0);
        }
    }

    public RecyclerView getContentRV() {
        return mContentRV;
    }

}
