/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.stamp.adapter;


import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.annots.stamp.IStampItemClickListener;
import com.foxit.uiextensions.browser.adapter.SuperAdapter;
import com.foxit.uiextensions.browser.adapter.viewholder.SuperViewHolder;
import com.foxit.uiextensions.modules.panel.bean.BaseBean;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.utils.AppResource;

import java.util.List;

import androidx.annotation.NonNull;

public class CommonStampAdapter extends SuperAdapter<CommonStampAdapter.CommonStampItemBean> {

    private final List<CommonStampItemBean> mStampItems;
    private IStampItemClickListener<CommonStampItemBean> mItemClickListener;
    private int mSelectedPosition = -1;

    public CommonStampAdapter(Context context, List<CommonStampItemBean> items) {
        super(context);
        mStampItems = items;
    }

    @Override
    public void notifyUpdateData() {
        notifyDataSetChanged();
    }

    @Override
    public CommonStampItemBean getDataItem(int position) {
        return mStampItems.get(position);
    }

    @NonNull
    @Override
    public SuperViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.fx_stamp_normal_item_layout, parent, false);
        return new CommonStampViewHolder(itemView);
    }

    @Override
    public int getItemCount() {
        return mStampItems.size();
    }

    class CommonStampViewHolder extends SuperViewHolder {
        ImageView mIconView;
        View mItemView;

        public CommonStampViewHolder(View itemView) {
            super(itemView);
            mItemView = itemView.findViewById(R.id.stamp_item_view);
            mIconView = itemView.findViewById(R.id.stamp_icon_iv);

            mItemView.setOnClickListener(this);
        }

        @Override
        public void bind(BaseBean data, int position) {
            CommonStampItemBean itemBean = (CommonStampItemBean) data;
            mIconView.setImageResource(itemBean.resId);

            if (itemBean.selected) {
                GradientDrawable drawable = new GradientDrawable();
                drawable.setCornerRadius(AppResource.getDimensionPixelSize(getContext(), R.dimen.ux_margin_4dp));
                drawable.setColor(ThemeConfig.getInstance(getContext()).getB2());
                drawable.setStroke(AppResource.getDimensionPixelSize(getContext(), R.dimen.ux_list_divider_height),
                        ThemeConfig.getInstance(getContext()).getPrimaryColor());
                mItemView.setBackground(drawable);
            } else {
                mItemView.setBackground(null);
            }
        }

        @Override
        public void onClick(View v) {
            int position = getAdapterPosition();
            if (position == -1) return;

            int id = v.getId();
            if (id == R.id.stamp_item_view) {
//                if (mSelectedPosition == position) return;
                if (mSelectedPosition >= 0) {
                    CommonStampItemBean lastSelectedBean = mStampItems.get(mSelectedPosition);
                    lastSelectedBean.selected = false;
                    notifyItemChanged(mSelectedPosition);
                }
                CommonStampItemBean selectedBean = mStampItems.get(position);
                selectedBean.selected = true;
                notifyItemChanged(position);
                mSelectedPosition = position;

                if (mItemClickListener != null)
                    mItemClickListener.onItemClick(false, position, selectedBean);
            }
        }
    }

    public void setSelectedPosition(int position) {
        if (mSelectedPosition >= 0) {
            CommonStampItemBean itemBean = mStampItems.get(mSelectedPosition);
            if (itemBean.selected) {
                itemBean.selected = false;
                notifyItemChanged(mSelectedPosition);
            }
        }

        if (position >= mStampItems.size() || position < 0) {
            for (int i = 0; i < mStampItems.size(); i++) {
                CommonStampItemBean itemBean = mStampItems.get(i);
                if (itemBean.selected) {
                    itemBean.selected = false;
                    notifyItemChanged(i);
                    break;
                }
            }

            mSelectedPosition = -1;
        } else {
            CommonStampItemBean itemBean = mStampItems.get(position);
            if (!itemBean.selected) {
                itemBean.selected = true;
                notifyItemChanged(position);
            }
            mSelectedPosition = position;
        }
    }

    public int getSelectedPosition() {
        return mSelectedPosition;
    }

    public void setItemClickListener(IStampItemClickListener<CommonStampItemBean> itemClickListener) {
        mItemClickListener = itemClickListener;
    }

    public static class CommonStampItemBean extends BaseBean {
        int type;
        int resId;
        boolean selected;

        public CommonStampItemBean(int type, int resId) {
            this.type = type;
            this.resId = resId;
        }
    }

}
