/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.stamp;


import com.foxit.uiextensions.R;

public class StampConstants {
    public static final int CUSTOM_TEXT_STAMP = 10000;
    public static final int CUSTOM_IMAGE_STAMP = 10001;

    public static final int[] Custom_Colors = {0xffcd4d32,
            0xff4ea882,
            0xff216ab9,
            0xff923094};

    public static final int ADD_STAMP = 0;
    public static final int MODIFY_STAMP = 1;

    static final int Standard_Stamps = 0;
    static final int SignHere_Stamps = 1;
    static final int Dynamic_Stamps = 2;
    static final int Custom_Stamps = 3;

    static final int[] Custom_Colors_ResIds = {R.drawable.custom_stamp_text_color1,
            R.drawable.custom_stamp_text_color2,
            R.drawable.custom_stamp_text_color3,
            R.drawable.custom_stamp_text_color4};

    static final String SP_NAME = "custom_stamps";
    static final String SP_KEY_TEXT_STAMPS = "sp_custom_text_stamps";
    static final String SP_KEY_IMAGE_STAMPS = "sp_custom_image_stamps";

    static final String[] Dynamic_Stamp_Names = {"APPROVED", "CONFIDENTIAL", "RECEIVED",
            "REVIEWED", "REVISED"};

    static final String[] Dynamic_Stamp_JP_Names = {"承認済", "極秘", "受領済", "レビュー済", "改訂"};

    static final int EDIT_NONE = 0;
    static final int EDIT_STATE = 1;
}
