/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.redaction;


import com.foxit.uiextensions.config.uisettings.annotations.annots.RedactConfig;
import com.foxit.uiextensions.controls.toolbar.ToolProperty;
import com.foxit.uiextensions.utils.AppUtil;

import androidx.annotation.NonNull;

public class RedactProperty extends ToolProperty {
    public int applyFillColor;
    public int fontColor;

    public RedactProperty() {
    }

    public RedactProperty(String property) {
        if (AppUtil.isEmpty(property)) return;

        String[] item = property.split(",");
        applyFillColor = Integer.parseInt(item[0]);
        fontColor = Integer.parseInt(item[1]);
        fontSize = Float.parseFloat(item[2]);
        fontName = item[3];
    }

    public RedactProperty(RedactConfig property) {
        if (property == null) return;

        applyFillColor = property.fillColor;
        fontColor = property.textColor;
        fontSize = property.textSize;
        fontName = property.textFace;
    }

    @NonNull
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(applyFillColor);
        sb.append(",");
        sb.append(fontColor);
        sb.append(",");
        sb.append(fontSize);
        sb.append(",");
        sb.append(fontName);
        return sb.toString();
    }
}
