/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.link;


import android.graphics.PointF;

import com.foxit.sdk.PDFException;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.actions.Destination;

class LinkUtil {
    static PointF getDestinationPoint(PDFDoc doc, Destination destination) {
        if (doc == null || destination == null || destination.isEmpty()) {
            return null;
        }

        PointF pt = new PointF(0, 0);
        try {
            switch (destination.getZoomMode()) {
                case Destination.e_ZoomXYZ:
                    pt.x = destination.getLeft();
                    pt.y = destination.getTop();
                    break;
                case Destination.e_ZoomFitHorz:
                case Destination.e_ZoomFitBHorz:
                    pt.y = destination.getTop();
                    break;
                case Destination.e_ZoomFitVert:
                case Destination.e_ZoomFitBVert:
                    pt.x = destination.getLeft();
                    break;
                case Destination.e_ZoomFitRect:
                    pt.x = (destination.getLeft() + destination.getRight()) / 2;
                    pt.y = (destination.getTop() + destination.getBottom()) / 2;
                    break;
                default:
                    pt = null;
                    break;
            }
        } catch (PDFException e) {
            e.printStackTrace();
        }
        return pt;
    }
}
