/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.ink.ocr;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.uiextensions.IThemeEventListener;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.controls.dialog.UIMatchDialog;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.AppSharedPreferences;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.mlkit.vision.digitalink.recognition.DigitalInkRecognitionModelIdentifier;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;


public class InkLanguagesDialog extends UIMatchDialog implements StrokeManager.DownloadedModelsChangedListener {

    private Context mContext;
    private PDFViewCtrl mPdfViewCtrl;
    private UIExtensionsManager mUIExtensionsManager;
    private ViewGroup mContentView;
    private RecyclerView mRecyclerView;
    private LinearLayoutManager mLayoutManager;
    private List<ModelLanguageContainer> mLanguagesList = new ArrayList<>();
    private InkLanguagesAdapter mAdapter;
    private LanguagesCallback mLanguagesCallback;
    StrokeManager mStrokeManager;
    private int mSelectPosition = 0;
    private int mLanguageCount;

    public InkLanguagesDialog(Context context,
                              UIExtensionsManager uIExtensionsManager,
                              StrokeManager strokeManager
    ) {
        super(context);
        mContext = context.getApplicationContext();
        mUIExtensionsManager = uIExtensionsManager;
        mStrokeManager = strokeManager;
        initStyle();
        initView();

        setOnDLDismissListener(new DismissListener() {
            @Override
            public void onDismiss() {
                mUIExtensionsManager.unregisterThemeEventListener(mThemeColorChangedListener);
            }
        });
    }

    private void initStyle() {
        setBackButtonTintList(ThemeUtil.getItemIconColor(mContext));
        setTitle(AppResource.getString(mContext, R.string.ocr_ink_current_languages));
        setTitlePosition(BaseBar.TB_Position.Position_CENTER);
        setStyle(DLG_TITLE_STYLE_BG_DEFAULT);
        setListener(new DialogListener() {
            @Override
            public void onResult(long btType) {
            }

            @Override
            public void onBackClick() {
                mLanguagesCallback.onDismiss(mSelectPosition, mLanguagesList.get(mSelectPosition));
                dismiss();
            }

            @Override
            public void onTitleRightButtonClick() {

            }
        });
    }

    @Override
    public void onBackPressed() {
        mLanguagesCallback.onDismiss(mSelectPosition, mLanguagesList.get(mSelectPosition));
        dismiss();
    }

    private void initView() {
        mContentView = (ViewGroup) View.inflate(mContext, R.layout.ink_languages_layout, null);
        mRecyclerView = mContentView.findViewById(R.id.ink_languages_rv);
        setContentView(mContentView);
        mLayoutManager = new LinearLayoutManager(mContext, LinearLayoutManager.VERTICAL, false);
        mRecyclerView.setLayoutManager(mLayoutManager);
        mAdapter = new InkLanguagesAdapter(mContext, mUIExtensionsManager);
    }

    int i = 0;
    public void loadData() {
        mUIExtensionsManager.registerThemeEventListener(mThemeColorChangedListener);
        mStrokeManager.setDownloadedModelsChangedListener(this);
        mAdapter.setOnItemClickCallback(onItemClickCallback);
        i = 0;
        mLanguageCount = 12;

        for (DigitalInkRecognitionModelIdentifier modelIdentifier :
                DigitalInkRecognitionModelIdentifier.allModelIdentifiers()) {
            if (DigitalInkRecognitionModelIdentifier.EN_US.getLanguageTag().equals(modelIdentifier.getLanguageTag())
                    || DigitalInkRecognitionModelIdentifier.DE_DE.getLanguageTag().equals(modelIdentifier.getLanguageTag())
                    || DigitalInkRecognitionModelIdentifier.PT_BR.getLanguageTag().equals(modelIdentifier.getLanguageTag())
                    || DigitalInkRecognitionModelIdentifier.IT_IT.getLanguageTag().equals(modelIdentifier.getLanguageTag())
                    || DigitalInkRecognitionModelIdentifier.FR_FR.getLanguageTag().equals(modelIdentifier.getLanguageTag())
                    || DigitalInkRecognitionModelIdentifier.KO.getLanguageTag().equals(modelIdentifier.getLanguageTag())
                    || DigitalInkRecognitionModelIdentifier.ZH_HANI_CN.getLanguageTag().equals(modelIdentifier.getLanguageTag())
                    || DigitalInkRecognitionModelIdentifier.ZH_HANI_TW.getLanguageTag().equals(modelIdentifier.getLanguageTag())
                    || DigitalInkRecognitionModelIdentifier.ES.getLanguageTag().equals(modelIdentifier.getLanguageTag())
                    || DigitalInkRecognitionModelIdentifier.RU.getLanguageTag().equals(modelIdentifier.getLanguageTag())
                    || DigitalInkRecognitionModelIdentifier.NL_NL.getLanguageTag().equals(modelIdentifier.getLanguageTag())
                    || DigitalInkRecognitionModelIdentifier.JA.getLanguageTag().equals(modelIdentifier.getLanguageTag())) {
                final ModelLanguageContainer languageContainer = new ModelLanguageContainer(ModelLanguageContainer.getLanguagesId(modelIdentifier.getLanguageTag()), modelIdentifier.getLanguageTag());
                languageContainer.setSelector(false);
                mLanguagesList.add(languageContainer);
                mStrokeManager.modelManager.checkIsModelDownloaded(modelIdentifier)
                        .addOnSuccessListener(new OnSuccessListener<Boolean>() {
                            @Override
                            public void onSuccess(Boolean aBoolean) {
                                int download = aBoolean ? 1 : 0;
                                languageContainer.setDownloadStatus(download);
                                addData();
                            }
                        })
                        .addOnFailureListener(new OnFailureListener() {
                            @Override
                            public void onFailure(@NonNull Exception e) {
                                languageContainer.setDownloadStatus(0);
                                addData();
                            }
                        });
            }
        }

    }

    public void setPosition(int position) {
        mSelectPosition = position;
    }

    private void addData() {
        i++;
        if (i == mLanguageCount) {
            List<ModelLanguageContainer> list = new ArrayList();
            ModelLanguageContainer languageContainer = new ModelLanguageContainer(DigitalInkRecognitionModelIdentifier.ZH_HANI_CN.getLanguageTag());
            ModelLanguageContainer languageContainer1 = new ModelLanguageContainer(DigitalInkRecognitionModelIdentifier.ZH_HANI_TW.getLanguageTag());
            ModelLanguageContainer languageContainer2 = new ModelLanguageContainer(DigitalInkRecognitionModelIdentifier.NL_NL.getLanguageTag());
            ModelLanguageContainer languageContainer3 = new ModelLanguageContainer(DigitalInkRecognitionModelIdentifier.EN_US.getLanguageTag());
            ModelLanguageContainer languageContainer4 = new ModelLanguageContainer(DigitalInkRecognitionModelIdentifier.FR_FR.getLanguageTag());
            ModelLanguageContainer languageContainer5 = new ModelLanguageContainer(DigitalInkRecognitionModelIdentifier.DE_DE.getLanguageTag());
            ModelLanguageContainer languageContainer6 = new ModelLanguageContainer(DigitalInkRecognitionModelIdentifier.IT_IT.getLanguageTag());
            ModelLanguageContainer languageContainer7 = new ModelLanguageContainer(DigitalInkRecognitionModelIdentifier.JA.getLanguageTag());
            ModelLanguageContainer languageContainer8 = new ModelLanguageContainer(DigitalInkRecognitionModelIdentifier.KO.getLanguageTag());
            ModelLanguageContainer languageContainer9 = new ModelLanguageContainer(DigitalInkRecognitionModelIdentifier.PT_BR.getLanguageTag());
            ModelLanguageContainer languageContainer10 = new ModelLanguageContainer(DigitalInkRecognitionModelIdentifier.RU.getLanguageTag());
            ModelLanguageContainer languageContainer11 = new ModelLanguageContainer(DigitalInkRecognitionModelIdentifier.ES.getLanguageTag());
            list.add(languageContainer);
            list.add(languageContainer1);
            list.add(languageContainer2);
            list.add(languageContainer3);
            list.add(languageContainer4);
            list.add(languageContainer5);
            list.add(languageContainer6);
            list.add(languageContainer7);
            list.add(languageContainer8);
            list.add(languageContainer9);
            list.add(languageContainer10);
            list.add(languageContainer11);
            List<ModelLanguageContainer> tempList = new ArrayList();
            for (int k = 0; k < list.size(); k++) {
                for (int j = 0; j < list.size(); j++) {
                    ModelLanguageContainer obj1 = list.get(k);
                    ModelLanguageContainer obj2 = mLanguagesList.get(j);
                    if(obj1.getLanguageTag().equals(obj2.getLanguageTag())){
                        tempList.add(obj2);
                    }
                }
            }
            mLanguagesList.clear();
            mLanguagesList.addAll(tempList);

            String language = ModelLanguageContainer.getCurrentRegionalLanguage();
            int index = 0;
            ModelLanguageContainer temp = null;
            for (int j = 0; j < mLanguagesList.size(); j++) {
                if (mLanguagesList.get(j).getLanguageTag().equals(language) && j != 0) {
                    index = j;
                    if(index != 0) {
                        temp = mLanguagesList.get(index);
                        mLanguagesList.remove(index);
                    }
                }
            }
            if (index != 0 && temp != null) {
                mLanguagesList.add(0,temp);
            }
            String inkLanguages = AppSharedPreferences.getInstance(mContext).getString(mContext.getPackageName(),"InkLanguages","");
            if(!inkLanguages.isEmpty()){
                for (int j = 0; j < mLanguagesList.size(); j++) {
                    if (mLanguagesList.get(j).getLanguageTag().equals(inkLanguages)) {
                        mSelectPosition = j;
                    }
                }
            }

            mLanguagesList.get(mSelectPosition).setSelector(true);
            mAdapter.setLanguagesList(mLanguagesList);
            mRecyclerView.setAdapter(mAdapter);
            mAdapter.notifyUpdateData();
        }
    }

    public void setLanguagesCallback(LanguagesCallback languagesCallback) {
        mLanguagesCallback = languagesCallback;
    }

    public interface LanguagesCallback {
        void onDismiss(int position, ModelLanguageContainer item);
    }


    private InkLanguagesAdapter.OnItemClickCallback onItemClickCallback = new InkLanguagesAdapter.OnItemClickCallback() {
        @Override
        public void onItemClick(int position, ModelLanguageContainer item) {
            mStrokeManager.setActiveModel(item.getLanguageTag());
            AppSharedPreferences.getInstance(mContext).setString(mContext.getPackageName(),"InkLanguages", item.getLanguageTag());
            mSelectPosition = position;
            for (int j = 0; j < mLanguagesList.size(); j++) {
                if (j == position) {
                    mLanguagesList.get(j).setSelector(true);
                    mAdapter.notifyItemChanged(j);
                } else {
                    if (mLanguagesList.get(j).isSelector()) {
                        mLanguagesList.get(j).setSelector(false);
                        mAdapter.notifyItemChanged(j);
                    }
                }
            }

        }

        @Override
        public void onItemDownLoadClick(int position, ModelLanguageContainer item) {
            item.setDownloadStatus(ModelLanguageContainer.downLoading);
            mAdapter.notifyItemChanged(position);
            mStrokeManager.download(item.getLanguageTag());
        }

        @Override
        public void onItemDeleteClick(int position, ModelLanguageContainer item) {
            mStrokeManager.deleteActiveModel(item.getLanguageTag());
            item.setDownloadStatus(ModelLanguageContainer.downLoad);
            mAdapter.notifyItemChanged(position);
        }
    };


    @Override
    public void onDownloadedModelsChanged(Set<String> downloadedLanguageTags) {
        for (int j = 0; j < mLanguagesList.size(); j++) {
            for (String downloadedLanguageTag : downloadedLanguageTags) {
                if (mLanguagesList.get(j).getLanguageTag().equals(downloadedLanguageTag)
                        && mLanguagesList.get(j).getDownloadStatus() == ModelLanguageContainer.downLoading
                ) {
                    mLanguagesList.get(j).setDownloadStatus(ModelLanguageContainer.downloaded);
                    mAdapter.notifyItemChanged(j);
                    break;
                }
            }
        }
    }

    private IThemeEventListener mThemeColorChangedListener = new IThemeEventListener() {
        @Override
        public void onThemeColorChanged(String type, int color) {
            dismiss();
        }
    };


}
