/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.ink;

import com.foxit.sdk.PDFException;
import com.foxit.sdk.PDFViewCtrl;
import com.foxit.sdk.common.Constants;
import com.foxit.sdk.pdf.PDFPage;
import com.foxit.sdk.pdf.annots.BorderInfo;
import com.foxit.sdk.pdf.annots.Ink;
import com.foxit.sdk.pdf.annots.Markup;
import com.foxit.sdk.pdf.objects.PDFArray;
import com.foxit.sdk.pdf.objects.PDFDictionary;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.annots.common.EditAnnotEvent;
import com.foxit.uiextensions.utils.AppDmUtil;

import java.util.List;

public class InkEvent extends EditAnnotEvent {

    public InkEvent(int eventType, InkUndoItem undoItem, Ink ink, PDFViewCtrl pdfViewCtrl) {
        mType = eventType;
        mUndoItem = undoItem;
        mAnnot = ink;
        mPdfViewCtrl = pdfViewCtrl;
    }

    @Override
    public boolean add() {
        if (mAnnot == null || !(mAnnot instanceof Ink)) {
            return false;
        }
        Ink annot = (Ink) mAnnot;
        try {
            InkAddUndoItem addUndoItem = (InkAddUndoItem) mUndoItem;
            annot.setBorderColor(addUndoItem.mColor);
            annot.setOpacity(addUndoItem.mOpacity);
            annot.setFlags(addUndoItem.mFlags);
            if (addUndoItem.mContents != null)
                annot.setContent(addUndoItem.mContents);
            if (addUndoItem.mCreationDate != null && AppDmUtil.isValidDateTime(addUndoItem.mCreationDate))
                annot.setCreationDateTime(addUndoItem.mCreationDate);
            if (addUndoItem.mModifiedDate != null && AppDmUtil.isValidDateTime(addUndoItem.mModifiedDate))
                annot.setModifiedDateTime(addUndoItem.mModifiedDate);
            if (addUndoItem.mAuthor != null)
                annot.setTitle(addUndoItem.mAuthor);
            if (addUndoItem.mIntent != null)
                annot.setIntent(addUndoItem.mIntent);
            if (addUndoItem.mSubject != null)
                annot.setSubject(addUndoItem.mSubject);
            if (addUndoItem.mPath != null)
                annot.setInkList(addUndoItem.mPath);
            if (addUndoItem.mPencilType == InkConstants.PENCIL_WITH_BRUSH) {
                PDFDictionary dict = annot.getDict();
                dict.setAtString(InkConstants.PSINK_DICT_KEY, InkConstants.PSINK_DICT_VALUE);
//                List<Float> pressures = addUndoItem.mPSIPressures;
//                if (pressures != null) {
//                    PDFArray pdfArray = PDFArray.create();
//                    if (pdfArray != null) {
//                        for (Float f: pressures) {
//                            pdfArray.addFloat(f);
//                        }
//                        dict.setAt("FxPList", pdfArray);
//                    }
//                }
            }

            BorderInfo borderInfo = new BorderInfo();
            borderInfo.setWidth(addUndoItem.mLineWidth);
            annot.setBorderInfo(borderInfo);
            annot.setUniqueID(addUndoItem.mNM);
            if (addUndoItem.mReplys != null)
                addUndoItem.mReplys.addReply(annot, addUndoItem.mReplys);
            annot.resetAppearanceStream();
            ((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getDocumentManager().setDocModified(true);
            return true;
        } catch (PDFException e) {
            if (e.getLastError() == Constants.e_ErrOutOfMemory) {
                mPdfViewCtrl.recoverForOOM();
            }
        }
        return false;
    }

    @Override
    public boolean modify() {
        if (mAnnot == null || !(mAnnot instanceof Ink)) {
            return false;
        }
        Ink annot = (Ink) mAnnot;
        try {
            if (mUndoItem.mModifiedDate != null) {
                annot.setModifiedDateTime(mUndoItem.mModifiedDate);
            }
            if (!useOldValue) {
                annot.setBorderColor(mUndoItem.mColor);
                annot.setOpacity(mUndoItem.mOpacity);
                BorderInfo borderInfo = new BorderInfo();
                borderInfo.setWidth(mUndoItem.mLineWidth);
                annot.setBorderInfo(borderInfo);
                if (((InkModifyUndoItem) mUndoItem).mPath != null) {
                    annot.setInkList(((InkModifyUndoItem) mUndoItem).mPath);
                }
                if (mUndoItem.mContents != null) {
                    annot.setContent(mUndoItem.mContents);
                } else {
                    annot.setContent("");
                }
            } else {
                annot.setBorderColor(mUndoItem.mOldColor);
                annot.setOpacity(mUndoItem.mOldOpacity);
                BorderInfo borderInfo = new BorderInfo();
                borderInfo.setWidth(mUndoItem.mOldLineWidth);
                annot.setBorderInfo(borderInfo);
                if (((InkModifyUndoItem) mUndoItem).mOldPath != null) {
                    annot.setInkList(((InkModifyUndoItem) mUndoItem).mOldPath);
                }
                if (mUndoItem.mOldContents != null) {
                    annot.setContent(mUndoItem.mOldContents);
                } else {
                    annot.setContent("");
                }
            }

            annot.resetAppearanceStream();
            ((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getDocumentManager().setDocModified(true);
            return true;
        } catch (PDFException e) {
            if (e.getLastError() == Constants.e_ErrOutOfMemory) {
                mPdfViewCtrl.recoverForOOM();
            }
        }
        return false;
    }

    @Override
    public boolean delete() {
        if (mAnnot == null || !(mAnnot instanceof Ink)) {
            return false;
        }

        try {
            ((Markup) mAnnot).removeAllReplies();
            PDFPage page = mAnnot.getPage();
            page.removeAnnot(mAnnot);
            ((UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager()).getDocumentManager().setDocModified(true);
            return true;
        } catch (PDFException e) {
            e.printStackTrace();
        }
        return false;
    }
}
