/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.ink;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;

class FSPageDisplayMatrix {

    private final Matrix matrix;

    FSPageDisplayMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    PointF convertPdfPtToPageViewPt(PointF point) {
        float[] pts = new float[]{
                point.x, point.y,
        };

        matrix.mapPoints(pts);
        return new PointF(pts[0], pts[1]);
    }

    float convertPdfToViewLength(float value) {
        RectF rectF = new RectF(0, value, value, 0);
        matrix.mapRect(rectF);
        return Math.abs(rectF.width());
    }
}
