/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.ink;

import android.content.Context;
import android.view.ScaleGestureDetector;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.uiextensions.IThemeEventListener;
import com.foxit.uiextensions.Module;
import com.foxit.uiextensions.ToolHandler;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.controls.toolbar.ToolConstants;
import com.foxit.uiextensions.controls.toolbar.drag.UIToolBaseBar;


public class EraserModule implements Module {

    private final EraserToolHandler mToolHandler;
    private final PDFViewCtrl.UIExtensionsManager mUiExtensionsManager;

    public EraserModule(Context context, PDFViewCtrl pdfViewCtrl, PDFViewCtrl.UIExtensionsManager uiExtensionsManager) {
        mUiExtensionsManager = uiExtensionsManager;
        mToolHandler = new EraserToolHandler(context, pdfViewCtrl);
    }

    @Override
    public String getName() {
        return Module.MODULE_NAME_ERASER;
    }

    @Override
    public boolean loadModule() {
        mToolHandler.initUiElements();
        if (mUiExtensionsManager != null && mUiExtensionsManager instanceof UIExtensionsManager) {
            UIExtensionsManager uiExtensionsManager = (UIExtensionsManager) mUiExtensionsManager;
            uiExtensionsManager.registerToolHandler(mToolHandler);
            uiExtensionsManager.registerThemeEventListener(mThemeEventListener);
            uiExtensionsManager.registerModule(this);
            uiExtensionsManager.getPDFViewCtrl().registerScaleGestureEventListener(mScaleGestureEventListener);

            uiExtensionsManager.getToolsManager()
                    .addToolItem(UIToolBaseBar.USAGE_TYPE_HOME, ToolConstants.Eraser, mToolHandler.getToolSupply());
            uiExtensionsManager.getToolsManager()
                    .addToolItem(UIToolBaseBar.USAGE_TYPE_DRAW, ToolConstants.Eraser, mToolHandler.getToolSupply());
        }
        return false;
    }

    @Override
    public boolean unloadModule() {
        if (mUiExtensionsManager != null && mUiExtensionsManager instanceof UIExtensionsManager) {
            UIExtensionsManager uiExtensionsManager = (UIExtensionsManager) mUiExtensionsManager;
            uiExtensionsManager.unregisterToolHandler(mToolHandler);
            uiExtensionsManager.unregisterThemeEventListener(mThemeEventListener);
            uiExtensionsManager.getPDFViewCtrl().unregisterScaleGestureEventListener(mScaleGestureEventListener);
        }
        return true;
    }

    private final IThemeEventListener mThemeEventListener = new IThemeEventListener() {
        @Override
        public void onThemeColorChanged(String type, int color) {
            if ( ((UIExtensionsManager) mUiExtensionsManager).getCurrentToolHandler() == mToolHandler) {
                mToolHandler.resetPropertyBar();
            }
        }
    };

    private final PDFViewCtrl.IScaleGestureEventListener mScaleGestureEventListener = new PDFViewCtrl.IScaleGestureEventListener() {

        @Override
        public boolean onScale(ScaleGestureDetector detector) {
            mToolHandler.onScaleBegin(detector);
            return false;
        }

        @Override
        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return false;
        }

        @Override
        public void onScaleEnd(ScaleGestureDetector detector) {
            mToolHandler.onScaleEnd(detector);
        }
    };

    public ToolHandler getToolHandler() {
        return mToolHandler;
    }

}
