/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.form;


import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.ListView;

import androidx.annotation.RequiresApi;

public class FormOptionsListView extends ListView {

    public FormOptionsListView(Context context) {
        super(context);
    }

    public FormOptionsListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FormOptionsListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public FormOptionsListView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (pointToPosition((int)ev.getX(), (int) ev.getY()) == -1 && ev.getAction() == MotionEvent.ACTION_DOWN) {
            if (mBlankClickListener != null)
                mBlankClickListener.onBlankClicked();
        }
        return super.dispatchTouchEvent(ev);
    }

    public void setOnBlankClickListener(OnBlankClickListener listener) {
        mBlankClickListener = listener;
    }

    private OnBlankClickListener mBlankClickListener;

    interface OnBlankClickListener {
        void onBlankClicked();
    }

}
