/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots.fillsign;


import android.graphics.RectF;

import androidx.annotation.NonNull;


public class FormObject implements Cloneable {

    long mJniAddr;
    int mTag;
    int mPageIndex;
    RectF mBBox;
    String mContent;
    float mFontSize;
    float mCharspace;
    float mSpacing;

    FormObject(int tag, int pageIndex, RectF bbox) {
        mTag = tag;
        mPageIndex = pageIndex;
        mBBox = bbox;
    }

    @SuppressWarnings({"MethodDoesntCallSuperMethod"})
    @NonNull
    @Override
    public FormObject clone() {
        FormObject newObj = new FormObject(mTag, mPageIndex, new RectF(mBBox));
        newObj.mContent = mContent;
        newObj.mJniAddr = mJniAddr;
        newObj.mFontSize = mFontSize;
        newObj.mCharspace = mCharspace;
        newObj.mSpacing = mSpacing;
        return newObj;
    }

}
