/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots;


import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.PDFPage;
import com.foxit.sdk.pdf.annots.Annot;

/**
 * interface definition for a callback to be invoked when redact annotation.apply.
 */
public abstract class IRedactionEventListener {

    /**
     * Called when redact annotation.will be applied.
     *
     * @param page  The {@link PDFPage} which apply a redact annotation.
     * @param annot The specified redact annotation will be applied
     */
    public void onAnnotWillApply(PDFPage page, Annot annot) {

    }

    /**
     * Called when redact annotation has.applied.
     *
     * @param page  The {@link PDFPage} which apply a redact annotation.
     * @param annot The specified redact annotation has applied
     */
    public void onAnnotApplied(PDFPage page, Annot annot) {

    }

    /**
     * Called when redact annotations.will be applied.
     *
     * @param doc The {@link PDFDoc} which apply redact annotations.
     */
    public void onAnnotsWillApply(PDFDoc doc) {
    }

    /**
     * Called when redact annotations has.applied.
     *
     * @param doc The {@link PDFDoc} which apply redact annotations.
     */
    public void onAnnotsApplied(PDFDoc doc) {

    }

    /**
     * Called when redact annotations.added.
     *
     * @param doc The {@link PDFDoc} which add redact annotations.
     */
    public void onAnnotsAdded(PDFDoc doc) {

    }

    /**
     * Called when redact annotations.deleted.
     *
     * @param doc The {@link PDFDoc} which delete redact annotations.
     */
    public void onAnnotsDeleted(PDFDoc doc) {

    }
}
