/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.annots;


import com.foxit.sdk.pdf.PDFPage;
import com.foxit.sdk.pdf.annots.Annot;

import java.util.List;

/**
 * interface definition for a callback to be invoked when group or ungroup annotations.
 */
public interface IGroupEventListener {

    /**
     * Called when group annotations.
     *
     * @param page        The {@link PDFPage} which group annotations.
     * @param groupAnnots An array of Markup objects that specifies markup annotations which are to be grouped together.
     *                    This array should contains at least 2 markup annotations, and all the markup annotations
     *                    in this array should be different from others. All the markup annotations in this array should be in current page.
     */
    void onAnnotGrouped(PDFPage page, List<Annot> groupAnnots);

    /**
     * Called when ungroup annotations.
     *
     * @param page          The {@link PDFPage} which group annotations.
     * @param unGroupAnnots An array of markup objects to be ungrouped.
     */
    void onAnnotUnGrouped(PDFPage page, List<Annot> unGroupAnnots);
}
