/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions;

import androidx.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface IPermissionProvider {

    interface IPermissionState {
        void onState(@PermissionState int state);
    }

    int PERMISSION_STATE_SHOW = 0;
    int PERMISSION_STATE_NO = 1;
    int PERMISSION_STATE_HIDE = 2;
    @IntDef({PERMISSION_STATE_SHOW, PERMISSION_STATE_NO, PERMISSION_STATE_HIDE})
    @Retention(RetentionPolicy.SOURCE)
    @interface PermissionState {
    }

    //Features
    int FUNCTION_DOC_INFO_EDIT = 1;
    int FUNCTION_EDIT = 2;
    int FUNCTION_REDUCE = 3;
    int FUNCTION_PDF_DIGITAL_SIGN_ADD = 4;
    int FUNCTION_THUMBNAIL_EDIT = 5;
    int FUNCTION_EDIT_ANNOT = 6;
    int FUNCTION_FORMFILLER = 7;
    int FUNCTION_ANNOTATION = 8;
    int FUNCTION_CERT_VERITY = 9;
    int FUNCTION_REDUCE_FILE_SIZE = 10;
    int FUNCTION_FILE_ENCRYPTION = 11;
    int FUNCTION_REDACTION = 12;
    int FUNCTION_FLATTEN = 13;
    int FUNCTION_FORM_DESIGN = 14;
    int FUNCTION_ATTACHMENT_MODIFY = 15;
    int FUNCTION_INK_RECOGNIZE = 16;
    @IntDef({
            FUNCTION_DOC_INFO_EDIT, FUNCTION_EDIT, FUNCTION_REDUCE,
            FUNCTION_PDF_DIGITAL_SIGN_ADD, FUNCTION_THUMBNAIL_EDIT, FUNCTION_EDIT_ANNOT, FUNCTION_FORMFILLER,
            FUNCTION_ANNOTATION, FUNCTION_CERT_VERITY, FUNCTION_REDUCE_FILE_SIZE, FUNCTION_FILE_ENCRYPTION,
            FUNCTION_REDACTION, FUNCTION_FLATTEN, FUNCTION_FORM_DESIGN, FUNCTION_ATTACHMENT_MODIFY,FUNCTION_INK_RECOGNIZE
    })
    @Retention(RetentionPolicy.SOURCE)
    @interface Function {
    }


    void checkPermission(@Function int function, IPermissionState state);
}
