/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions;


import android.app.Activity;
import android.view.KeyEvent;

/**
 * Interface that defines the interaction event listener.
 */
public interface IInteractionEventListener {

    /**
     * Called when a key down event has occurred.
     *
     * @param act     The current activity.
     * @param keyCode The value in event.getKeyCode().
     * @param event   The key event.
     * @return true if the event is handled, false otherwise.
     * @see android.view.KeyEvent
     */
    boolean onKeyDown(Activity act, int keyCode, KeyEvent event);
}
