/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.views.util;

public class UilPhoto {
    private int id;
    private String originalPath;
    private String thumbnailPath;
    private int orientation;

    public UilPhoto() {
    }

    public UilPhoto(int id, String origPath, String thumbPath, int orientation) {
        this.id = id;
        this.originalPath = origPath;
        this.thumbnailPath = thumbPath;
        this.orientation = orientation;
    }

    public String getOriginalPath() {
        return originalPath;
    }

    public String getOriginalUri() {
        return "file://" + originalPath;
    }

    public String getThumbnailUri() {
        return "file://" + thumbnailPath;
    }

    public int getOrientation() {
        return orientation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof UilPhoto)) return false;

        UilPhoto photo = (UilPhoto) o;
        return id == photo.id;
    }

    @Override
    public int hashCode() {
        return id;
    }
}
