/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.views.util;

import android.content.Context;
import android.os.Bundle;

import com.foxit.pdfscan.utils.AppUtils;

import java.util.ArrayList;
import java.util.List;

import androidx.fragment.app.FragmentActivity;

public class UilLocalImageHelper {
    private static UilLocalImageHelper mInstance;

    final List<UilPhotoDirectory> mFolders = new ArrayList<>();
    final List<UilPhoto> mCheckedItems = new ArrayList<>();
    private int mCurrentSize;
    private boolean mResultOk;

    public static UilLocalImageHelper getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new UilLocalImageHelper(context);
        }
        return mInstance;
    }

    private UilLocalImageHelper(Context context) {
    }

    public int getCurrentSize() {
        return mCurrentSize;
    }

    public void setCurrentSize(int mCurrentSize) {
        this.mCurrentSize = mCurrentSize;
    }

    public List<UilPhotoDirectory> getFolders() {
        return mFolders;
    }

    public List<UilPhoto> getCheckedItems() {
        return mCheckedItems;
    }

    public boolean isResultOk() {
        return mResultOk;
    }

    public void setResultOk(boolean ok) {
        mResultOk = ok;
    }

    public synchronized void loadImages(FragmentActivity act, final Runnable runnable) {
        Bundle args = new Bundle();
        args.putBoolean(UilMediaStoreHelper.EXTRA_SHOW_GIF, false);
        UilMediaStoreHelper.getPhotoDirs(act, args, new UilMediaStoreHelper.PhotosLoaderCallback() {
            @Override
            public void onLoadFinished(List<UilPhotoDirectory> directories) {
                mFolders.clear();
                mFolders.addAll(directories);

                if (runnable != null) {
                    runnable.run();
                }
            }
        });
    }

    public List<UilPhoto> getFolder(String folder) {
        for (UilPhotoDirectory dir : mFolders) {
            if (AppUtils.isEqual(dir.getPath(), folder)) {
                return dir.getPhotos();
            }
        }
        return new ArrayList<>();
    }

    public void clear() {
        mCheckedItems.clear();
        mCurrentSize = 0;
    }

}
