/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.views.util;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.viewpager.widget.ViewPager;

import com.foxit.pdfscan.R;
import com.foxit.pdfscan.ScannerSession;
import com.foxit.pdfscan.utils.AppUtils;
import com.foxit.pdfscan.utils.DisplayUtils;
import com.foxit.pdfscan.utils.ResourceUtils;
import com.foxit.uiextensions.theme.BaseThemeAdapter;
import com.foxit.uiextensions.theme.IThemeChangeObserver;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.UIToast;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.display.SimpleBitmapDisplayer;
import com.nostra13.universalimageloader.core.imageaware.ImageViewAware;
import com.nostra13.universalimageloader.core.listener.SimpleImageLoadingListener;

import java.util.ArrayList;
import java.util.List;

public class UilLocalAlbumDetail extends UilBaseActivity
        implements IThemeChangeObserver, View.OnClickListener, CompoundButton.OnCheckedChangeListener {
    String mFolderName;
    String mFolderPath;
    List<UilPhoto> mPhotoList = null;
    List<UilPhoto> mCheckedItems = new ArrayList<>();

    GridView mGridView;
    TextView mTitle;
    View mTitleBar;
    View mPagerContainer;
    TextView mFinishTv;
    TextView mHeaderFinishtv;
    UilAlbumViewPager mViewPager;
    TextView mCountView;
    MyAdapter mAdapter;
    ImageView mBackView;
    View mHeaderBar;
    CheckBox mCheckBox;
    UilLocalImageHelper mImageHelper;
    UilFilterImageView mBackButton;
    LinearLayout mLlRoot;
    View mTitleBarDivider;
    private int mNightMode = -1;
    private boolean mSingleChoose;
    private int MAX_COUNT = 9;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.fx_photo2pdf_local_album_detail);
        mNightMode = getResources().getConfiguration().uiMode & Configuration.UI_MODE_NIGHT_MASK;
        mLlRoot = findViewById(R.id.scanner_album_details_ll_root);
        mTitle = (TextView) findViewById(R.id.album_title);
        mFinishTv = (TextView) findViewById(R.id.album_finish);
        mHeaderFinishtv = (TextView) findViewById(R.id.header_finish);
        mGridView = (GridView) findViewById(R.id.gridview);
        mTitleBar = findViewById(R.id.album_title_bar);
        mTitleBarDivider = findViewById(R.id.album_details_title_bar_divider);
        mViewPager = (UilAlbumViewPager) findViewById(R.id.albumviewpager);
        mPagerContainer = findViewById(R.id.pagerview);
        mCountView = (TextView) findViewById(R.id.header_bar_photo_count);
        mViewPager.addOnPageChangeListener(pageChangeListener);
        mBackView = (ImageView) findViewById(R.id.header_bar_photo_back);
        ThemeUtil.setTintList(mBackView, ThemeUtil.getItemIconColor(this));
        mHeaderBar = findViewById(R.id.album_item_header_bar);
        mCheckBox = (CheckBox) findViewById(R.id.checkbox);
        mCheckBox.setOnCheckedChangeListener(this);
        ThemeUtil.setTintList(mCheckBox, ThemeUtil.getCheckboxColor(this));
        mBackView.setOnClickListener(this);
        mFinishTv.setOnClickListener(this);
        ThemeUtil.setTintList(mFinishTv, ThemeUtil.getPrimaryTextColor(this));
        mHeaderFinishtv.setOnClickListener(this);

        ThemeUtil.setTintList(mHeaderFinishtv, ThemeUtil.getPrimaryTextColor(this));
        mBackButton = findViewById(R.id.scanner_local_album_back_button);
        mBackButton.setOnClickListener(this);
        ThemeUtil.setTintList(mBackButton, ThemeUtil.getItemIconColor(this));
        mFinishTv.setContentDescription(ResourceUtils.getString(getApplicationContext(), R.string.scan_string_done));

        mFolderPath = getIntent().getExtras().getString(UilLocalAlbum.LOCAL_FOLDER_PATH);
        mFolderName = getIntent().getExtras().getString(UilLocalAlbum.LOCAL_FOLDER_NAME);
        mSingleChoose = getIntent().getBooleanExtra(ScannerSession.EXTRA_SINGLE_CHOOSE, false);
        if (mSingleChoose)
            MAX_COUNT = 1;

        mImageHelper = UilLocalImageHelper.getInstance(getApplicationContext());
        final List<UilPhoto> photoList = mImageHelper.getFolder(mFolderPath);
        mCheckedItems = mImageHelper.getCheckedItems();
        if (photoList != null) {
            mPhotoList = photoList;
            mAdapter = new MyAdapter(getApplicationContext(), photoList);
            mTitle.setText(mFolderName);
            mGridView.setAdapter(mAdapter);
            String str = ResourceUtils.getString(getApplicationContext(), R.string.scan_string_done);
            if (mCheckedItems.size() > 0) {
                mFinishTv.setText(str + "(" + (mCheckedItems.size()) + "/" + MAX_COUNT + ")");
                mFinishTv.setEnabled(true);
                mHeaderFinishtv.setText(str + "(" + (mCheckedItems.size()) + "/" + MAX_COUNT + ")");
                mHeaderFinishtv.setEnabled(true);
                ThemeUtil.setTintList(mHeaderFinishtv, ThemeUtil.getPrimaryTextColor(this));
                ThemeUtil.setTintList(mFinishTv, ThemeUtil.getPrimaryTextColor(this));
            } else {
                mHeaderFinishtv.setEnabled(false);
                mFinishTv.setEnabled(false);
                mFinishTv.setText(str);
                mHeaderFinishtv.setText(str);
//                mHeaderFinishtv.setTextColor(getResources().getColor(R.color.scan_color_2E2E2E));
//                mFinishTv.setTextColor(getResources().getColor(R.color.scan_color_2E2E2E));
            }
        }
        UilLocalImageHelper.getInstance(getApplicationContext()).setResultOk(false);
        if (ThemeConfig.getInstance(this).getAdapter() == null) {
            ThemeConfig.getInstance(this).setAdapter(new BaseThemeAdapter());
        }
        ThemeConfig.getInstance(this).getAdapter().registerThemeChangeObserver(this);
    }

    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (mNightMode != (newConfig.uiMode & Configuration.UI_MODE_NIGHT_MASK)) {
            mNightMode = newConfig.uiMode & Configuration.UI_MODE_NIGHT_MASK;
            setDarkModeColor();
        }
    }

    public void setDarkModeColor() {
        ThemeUtil.setTintList(mBackButton, ThemeUtil.getItemIconColor(this));
        ThemeUtil.setTintList(mFinishTv, ThemeUtil.getPrimaryTextColor(this));
        ThemeUtil.setTintList(mHeaderFinishtv, ThemeUtil.getPrimaryTextColor(this));
        ThemeUtil.setTintList(mBackView, ThemeUtil.getItemIconColor(this));
        ThemeUtil.setTintList(mCheckBox, ThemeUtil.getCheckboxColor(this));
        mLlRoot.setBackgroundColor(getResources().getColor(R.color.b1));
        mTitleBar.setBackgroundColor(getResources().getColor(R.color.b2));
        mTitle.setTextColor(getResources().getColor(R.color.t4));
        mTitleBarDivider.setBackgroundColor(getResources().getColor(R.color.p1));
        mHeaderBar.setBackgroundColor(getResources().getColor(R.color.b2));
        mCountView.setTextColor(getResources().getColor(R.color.t4));
        mAdapter.notifyDataSetChanged();
    }

    @Override
    public void onDestroy() {
        ThemeConfig.getInstance(this).getAdapter().unregisterThemeChangeObserver(this);
        super.onDestroy();
    }

    @Override
    public void onThemeChanged(String type, int color) {
        setDarkModeColor();
    }

    private void showViewPager(int index) {
        mPagerContainer.setVisibility(View.VISIBLE);
        mGridView.setVisibility(View.GONE);
        findViewById(R.id.album_title_bar).setVisibility(View.GONE);
        mViewPager.setAdapter(mViewPager.new LocalViewPagerAdapter(mPhotoList));
        mViewPager.setCurrentItem(index);
        mCountView.setText((index + 1) + "/" + mPhotoList.size());
        if (index == 0) {
            mCheckBox.setTag(mPhotoList.get(index));
            mCheckBox.setChecked(mCheckedItems.contains(mPhotoList.get(index)));
        }
    }

    private void hideViewPager() {
        mPagerContainer.setVisibility(View.GONE);
        mGridView.setVisibility(View.VISIBLE);
        findViewById(R.id.album_title_bar).setVisibility(View.VISIBLE);
        ((BaseAdapter) mGridView.getAdapter()).notifyDataSetChanged();
    }

    private ViewPager.OnPageChangeListener pageChangeListener = new ViewPager.OnPageChangeListener() {

        @Override
        public void onPageSelected(int position) {
            if (mViewPager.getAdapter() != null) {
                String text = (position + 1) + "/" + mViewPager.getAdapter().getCount();
                mCountView.setText(text);
                mCheckBox.setTag(mPhotoList.get(position));
                mCheckBox.setChecked(mCheckedItems.contains(mPhotoList.get(position)));
            } else {
                mCountView.setText("0/0");
            }
        }

        @Override
        public void onPageScrolled(int arg0, float arg1, int arg2) {
        }

        @Override
        public void onPageScrollStateChanged(int arg0) {
        }
    };

    @Override
    public void onClick(View view) {
        int id = view.getId();
        if (id == R.id.header_bar_photo_back) {
            hideViewPager();
        } else if (id == R.id.album_finish || id == R.id.header_finish) {
            if (AppUtils.isFastDoubleClick())
                return;
            mFinishTv.setEnabled(false);
            mHeaderFinishtv.setEnabled(false);
//            UilAppManager.getAppManager().finishActivity(UilLocalAlbum.class);
            UilLocalImageHelper.getInstance(getApplicationContext()).setResultOk(true);
            this.setResult(Activity.RESULT_OK);
            finish();
        } else if (id == R.id.scanner_local_album_back_button) {
            finish();
        }
    }

    @Override
    public void onBackPressed() {
        if (mPagerContainer.getVisibility() == View.VISIBLE) {
            hideViewPager();
        } else {
            super.onBackPressed();
        }
    }

    @Override
    public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
        if (!b) {
            if (mCheckedItems.contains(compoundButton.getTag())) {
                mCheckedItems.remove(compoundButton.getTag());
            }
        } else {
            if (mSingleChoose) {
                mCheckedItems.clear();
                mCheckedItems.add((UilPhoto) compoundButton.getTag());
                mAdapter.notifyDataSetChanged();
            } else {
                if (!mCheckedItems.contains(compoundButton.getTag())) {
                    if (mCheckedItems.size() >= MAX_COUNT && !mSingleChoose) {
                        UIToast.getInstance(this).show(getString(R.string.scan_select_photo_most));
                        compoundButton.setChecked(false);
                        return;
                    }
                    mCheckedItems.add((UilPhoto) compoundButton.getTag());
                }
            }
        }
        String str = ResourceUtils.getString(getApplicationContext(), R.string.scan_string_done);
        if (mCheckedItems.size() + UilLocalImageHelper.getInstance(getApplicationContext()).getCurrentSize() > 0) {
            mFinishTv.setText(str + "(" + (mCheckedItems.size()) + "/" + MAX_COUNT + ")");
            mFinishTv.setEnabled(true);
            mHeaderFinishtv.setText(str + "(" + (mCheckedItems.size()) + "/" + MAX_COUNT + ")");
            mHeaderFinishtv.setEnabled(true);
            ThemeUtil.setTintList(mHeaderFinishtv, ThemeUtil.getPrimaryTextColor(this));
            ThemeUtil.setTintList(mFinishTv, ThemeUtil.getPrimaryTextColor(this));
        } else {
            mFinishTv.setText(str);
            mFinishTv.setEnabled(false);
            mHeaderFinishtv.setText(str);
            mHeaderFinishtv.setEnabled(false);
//            mFinishTv.setTextColor(getResources().getColor(R.color.scan_color_2E2E2E));
//            mHeaderFinishtv.setTextColor(getResources().getColor(R.color.scan_color_2E2E2E));
        }
    }

    public class MyAdapter extends BaseAdapter {
        private Context mContext;
        DisplayImageOptions options;
        List<UilPhoto> paths;

        public MyAdapter(Context context, List<UilPhoto> paths) {
            mContext = context;
            this.paths = paths;

            options = new DisplayImageOptions.Builder()
                    .cacheInMemory(true)
                    .cacheOnDisk(false)
                    .showImageForEmptyUri(R.drawable.fx_photo2pdf_file_type_pdf)
                    .showImageOnFail(R.drawable.fx_photo2pdf_file_type_pdf)
                    .showImageOnLoading(R.drawable.fx_photo2pdf_file_type_pdf)
                    .bitmapConfig(Bitmap.Config.RGB_565)
                    .displayer(new SimpleBitmapDisplayer()).build();
        }

        @Override
        public int getCount() {
            return paths.size();
        }

        @Override
        public UilPhoto getItem(int i) {
            return paths.get(i);
        }

        @Override
        public long getItemId(int i) {
            return i;
        }

        @Override
        public View getView(final int i, View convertView, ViewGroup viewGroup) {
            ViewHolder viewHolder;
            if (convertView == null || convertView.getTag() == null) {
                viewHolder = new ViewHolder();
                LayoutInflater inflater = getLayoutInflater();
                convertView = inflater.inflate(R.layout.fx_photo2pdf_simple_list_item, null);
                viewHolder.imageView = (ImageView) convertView.findViewById(R.id.fx_photo2pdf_simple_list_item_imageView);
                viewHolder.checkBox = (CheckBox) convertView.findViewById(R.id.fx_photo2pdf_simple_list_item_checkbox);
                viewHolder.checkBox.setOnCheckedChangeListener(UilLocalAlbumDetail.this);
                convertView.setTag(viewHolder);
            } else {
                viewHolder = (ViewHolder) convertView.getTag();
            }
            UilPhoto localFile = paths.get(i);
            ImageLoader.getInstance().displayImage(
                    localFile.getThumbnailUri(),
                    new ImageViewAware(viewHolder.imageView),
                    options,
                    new ImageSize(DisplayUtils.getInstance(mContext).getScreenWidth() / 4, 0),
                    loadingListener,
                    null);
            viewHolder.checkBox.setTag(localFile);
            viewHolder.checkBox.setChecked(mCheckedItems.contains(localFile));
            viewHolder.checkBox.getBackground().setColorFilter(
                    new PorterDuffColorFilter(AppResource.getColor(mContext, com.foxit.uiextensions.R.color.b1), PorterDuff.Mode.SRC_IN));
            ThemeUtil.setTintList(viewHolder.checkBox, ThemeUtil.getCheckboxColor(mContext));
            viewHolder.imageView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    showViewPager(i);
                }
            });
            return convertView;
        }

        private class ViewHolder {
            ImageView imageView;
            CheckBox checkBox;
        }
    }

    SimpleImageLoadingListener loadingListener = new SimpleImageLoadingListener() {
        @Override
        public void onLoadingComplete(String imageUri, View view, final Bitmap bm) {
            if (TextUtils.isEmpty(imageUri)) {
                return;
            }
            try {
                ((ImageView) view).getDrawable().setColorFilter(Color.argb(0xff, 0xee, 0xee, 0xee), PorterDuff.Mode.MULTIPLY);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
}