/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.views.util;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;

import com.foxit.pdfscan.R;
import com.foxit.pdfscan.utils.ResourceUtils;

import androidx.appcompat.widget.AppCompatImageView;


public class UilFilterImageView extends AppCompatImageView {

    public UilFilterImageView(Context context) {
        super(context);
    }

    public UilFilterImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public UilFilterImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case MotionEvent.ACTION_DOWN:
                setFilter();
                break;
            case MotionEvent.ACTION_UP:
                performClick();
            case MotionEvent.ACTION_CANCEL:
                removeFilter();
                break;
            default:
                break;
        }
        return true;
    }

    private void setFilter() {
        Drawable drawable = getDrawable();
        if (drawable == null) {
            drawable = getBackground();
        }
        if (drawable != null) {
            drawable.setColorFilter(ResourceUtils.getColor(getContext(), R.color.scan_color_btn_item_pressed, null), PorterDuff.Mode.MULTIPLY);
        }
    }

    private void removeFilter() {
        Drawable drawable = getDrawable();
        if (drawable == null) {
            drawable = getBackground();
        }
        if (drawable != null) {
            drawable.clearColorFilter();
        }
    }

}
