/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.views.util;

import android.app.Activity;

import java.util.Stack;

public class UilAppManager {
    private static Stack<Activity> mActStack;
    private static UilAppManager mInst;

    private UilAppManager() {
    }

    public static UilAppManager getAppManager() {
        if (mInst == null) {
            mInst = new UilAppManager();
        }
        return mInst;
    }

    public void addActivity(Activity activity) {
        if (mActStack == null) {
            mActStack = new Stack<>();
        }
        mActStack.add(activity);
    }

    public void finishActivity(Activity activity) {
        if (activity != null) {
            mActStack.remove(activity);
            activity.finish();
        }
    }

    public void finishActivity(Class<?> cls) {
        if (mActStack != null && mActStack.size() > 0) {
            for (int i = mActStack.size() - 1; i >= 0; i--) {
                Activity activity = mActStack.get(i);
                if (activity.getClass().equals(cls)) {
                    finishActivity(activity);
                }
            }
        }
    }
}