/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.views.util;


import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.foxit.pdfscan.R;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.display.SimpleBitmapDisplayer;
import com.nostra13.universalimageloader.core.imageaware.ImageViewAware;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.core.listener.ImageLoadingProgressListener;

import java.util.List;

import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;

public class UilAlbumViewPager extends ViewPager {
    DisplayImageOptions mLocalOptions;

    class ProcressListener implements ImageLoadingProgressListener {
        private View mView = null;

        public ProcressListener(View view) {
            this.mView = view;
        }

        @Override
        public void onProgressUpdate(String arg0, View view, int current, int total) {
            TextView loadText = (TextView) mView.findViewById(R.id.fx_photo2pdf_item__album_current_procress);
            loadText.setText(String.valueOf(100 * current / total) + "%");
            loadText.bringToFront();
        }
    }

    ImageLoadingListener mLoadingListener = new ImageLoadingListener() {

        @Override
        public void onLoadingCancelled(String arg0, View arg1) {
        }

        @Override
        public void onLoadingComplete(String arg0, View view, Bitmap arg2) {
            view.setVisibility(View.VISIBLE);
            view.getParent().bringChildToFront(view);
        }

        @Override
        public void onLoadingFailed(String arg0, View view, FailReason arg2) {
        }

        @Override
        public void onLoadingStarted(String arg0, View arg1) {
        }

    };

    public UilAlbumViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        mLocalOptions = new DisplayImageOptions.Builder()
                .cacheInMemory(true)
                .cacheOnDisk(false)
                .bitmapConfig(Bitmap.Config.RGB_565)
                .imageScaleType(ImageScaleType.EXACTLY)
                .displayer(new SimpleBitmapDisplayer()).build();
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent arg0) {
        return super.onInterceptTouchEvent(arg0);
    }

    public class LocalViewPagerAdapter extends PagerAdapter {
        private List<UilPhoto> paths;

        public LocalViewPagerAdapter(List<UilPhoto> paths) {
            this.paths = paths;
        }

        @Override
        public int getCount() {
            return paths.size();
        }

        @Override
        public Object instantiateItem(ViewGroup viewGroup, int position) {
            View imageLayout = inflate(getContext(), R.layout.fx_photo2pdf_item_album_pager, null);
            viewGroup.addView(imageLayout);
            assert imageLayout != null;
            ImageView imageView =  imageLayout.findViewById(R.id.fx_photo2pdf_item__album_image);
            UilPhoto path = paths.get(position);
            ImageLoader.getInstance().displayImage(path.getOriginalUri(), new ImageViewAware(imageView), mLocalOptions, null, mLoadingListener, new ProcressListener(imageLayout));
            return imageLayout;
        }

        @Override
        public int getItemPosition(Object object) {
            return POSITION_NONE;
        }

        @Override
        public void destroyItem(ViewGroup container, int arg1, Object object) {
            container.removeView((View) object);
        }

        @Override
        public boolean isViewFromObject(View arg0, Object arg1) {
            return arg0 == arg1;
        }
    }
}