/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;

import com.foxit.pdfscan.R;
import com.foxit.pdfscan.utils.DisplayUtils;
import com.foxit.pdfscan.utils.ResourceUtils;

import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;

public class UnderlineTextView extends AppCompatTextView {

    public UnderlineTextView(Context context) {
        super(context);
    }

    public UnderlineTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public UnderlineTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    Paint paint = new Paint();

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        int w = canvas.getWidth();
        int h = canvas.getHeight();

        paint.setStyle(Paint.Style.STROKE);
        paint.setAntiAlias(true);
        paint.setDither(true);
        paint.setColor(ResourceUtils.getColor(getContext(), R.color.t4, null));
        paint.setStrokeWidth(DisplayUtils.getInstance(getContext()).dp2px(2));

        canvas.drawLine(0, h, w, h, paint);
    }
}
