/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.views;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;

import com.foxit.pdfscan.R;
import com.foxit.pdfscan.utils.ResourceUtils;
import com.luratech.android.appframework.DetectionResult;

import androidx.appcompat.widget.AppCompatTextView;

public class ResultMessageView extends AppCompatTextView {

    public ResultMessageView(Context context) {
        super(context);
        initComponent();
    }

    public ResultMessageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initComponent();
    }

    protected void initComponent() {
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    public void setDetectionResult(DetectionResult result) {
        Integer hintID = null;
        if (result == null) {
            return;
        } else if (!result.isValid()) {
            hintID = R.string.scanner_message_no_detection;
        } else if (result.isTooDark())
            hintID = R.string.scanner_message_too_dark;
        else if (!result.isLargeEnough())
            hintID = R.string.scanner_message_move_closer;
        else if (result.hasGlare())
            hintID = R.string.scanner_message_glare;
        else
            hintID = R.string.scanner_message_hold_still;

        setText(ResourceUtils.getString(getContext(), hintID));
    }
}
