/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.views;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;

import com.foxit.pdfscan.R;

public class ProgressBarView extends FrameLayout {

    public ProgressBarView(Context context) {
        super(context);
        initComponent(context);
    }

    public ProgressBarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initComponent(context);
    }

    private void initComponent(Context context) {
        LayoutInflater.from(context).inflate(R.layout.fx_photo2pdf_fragment_progress_bar, this, true);
        setClickable(true);
        setVisibility(View.INVISIBLE);
    }

    private ProgressDialog mProgressDlg;
    private CircleProgressDialog mCircleProgressDlg;

    @TargetApi(Build.VERSION_CODES.JELLY_BEAN)
    public void start(Activity act, boolean haveText) {
        if (haveText) {
            if (mProgressDlg == null) {
                mProgressDlg = new ProgressDialog(act);
                mProgressDlg.setProgressStyle(ProgressDialog.STYLE_SPINNER);
                mProgressDlg.setCancelable(false);
                mProgressDlg.setIndeterminate(false);
            }
            mProgressDlg.setMessage("");
            mProgressDlg.show();
        } else {
            if (mCircleProgressDlg == null) {
                mCircleProgressDlg = new CircleProgressDialog(act);
                mCircleProgressDlg.setCancelable(false);
                mCircleProgressDlg.setIndeterminate(false);
            }
            mCircleProgressDlg.show();
        }
    }

    @TargetApi(Build.VERSION_CODES.JELLY_BEAN)
    public void progress(String message) {
        if (mProgressDlg != null) {
            mProgressDlg.setMessage(message);
        } else {
            if (mCircleProgressDlg != null)
                mCircleProgressDlg.setMessage(message);
        }
    }

    public void end() {
        if (mProgressDlg != null && mProgressDlg.isShowing()) {
            mProgressDlg.dismiss();
        }
        if (mCircleProgressDlg != null && mCircleProgressDlg.isShowing()) {
            mCircleProgressDlg.dismiss();
        }
    }

    public boolean isShowing() {
        if (mProgressDlg != null)
            return mProgressDlg.isShowing();
        if (mCircleProgressDlg != null)
            return mCircleProgressDlg.isShowing();
        return false;
    }

}
