/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;

import com.foxit.pdfscan.R;
import com.foxit.pdfscan.editimage.ColorspaceItem;
import com.foxit.pdfscan.editimage.EditImageGroupItem;
import com.foxit.pdfscan.editimage.EditImageListener;
import com.foxit.pdfscan.utils.ResourceUtils;
import com.luratech.android.appframework.ImageProcessor;

import java.util.ArrayList;

public class EditImageListView extends ExpandableListView implements AdapterView.OnItemSelectedListener {


    private ArrayList<EditImageGroupItem> mEditImageGroupItem;
    private ArrayList<String> mColorList;
    private EditImageListAdapter mAdapter;
    private int brightnessProgress = 10, contrastProgress = 10;
    private boolean colorChanged;

    private EditImageListener editImageListener;

    public EditImageListView(Context context) {
        super(context);
        initList();
        initExpandableListView();
    }

    public EditImageListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initList();
        initExpandableListView();
    }

    private void initList() {
        colorChanged = false;
        mEditImageGroupItem = new ArrayList<>();
        mColorList = new ArrayList<>();
        mColorList.add(ResourceUtils.getString(getContext(), R.string.photo2pdf_editimage_color_none));
        mColorList.add(ResourceUtils.getString(getContext(), R.string.photo2pdf_editimage_color_colours));
        mColorList.add(ResourceUtils.getString(getContext(), R.string.photo2pdf_editimage_color_blackandwhite));
        mColorList.add(ResourceUtils.getString(getContext(), R.string.photo2pdf_editimage_color_Gray));
        mEditImageGroupItem.add(new EditImageGroupItem(ResourceUtils.getString(getContext(), R.string.photo2pdf_editimage_color), mColorList));
        mEditImageGroupItem.add(new EditImageGroupItem(ResourceUtils.getString(getContext(), R.string.photo2pdf_editimage_brightness), mColorList));
        mEditImageGroupItem.add(new EditImageGroupItem(ResourceUtils.getString(getContext(), R.string.photo2pdf_editimage_contrast), mColorList));
    }

    private void initExpandableListView() {
        this.setGroupIndicator(null);
        mAdapter = new EditImageListAdapter();
        this.setAdapter(mAdapter);
        for (int i = 0; i < mAdapter.getGroupCount(); i++) {
            this.collapseGroup(i);
        }

    }

    public void setEditImageListener(EditImageListener listener) {
        this.editImageListener = listener;
    }

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {
    }
//
//    @Override
//    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
//        editImageListener.seekBarChanged(seekBar, progress, fromUser);
//    }
//
//    @Override
//    public void onStartTrackingTouch(SeekBar seekBar) {
//
//    }
//
//    @Override
//    public void onStopTrackingTouch(SeekBar seekBar) {
//
//    }

    static class GroupViewHolder {
        TextView name;
        ImageView arror;
    }

    static class ChildViewHolder {
        TextView colorStyle;
        SeekBar seekBar;
    }


    class EditImageListAdapter extends BaseExpandableListAdapter {

        private boolean itemOpen = false;

        @Override
        public int getGroupCount() {
            return mEditImageGroupItem.size();
        }

        @Override
        public int getChildrenCount(int groupPosition) {
            if (groupPosition == 0) {
                return 4;
            } else {
                return 1;
            }
        }

        @Override
        public Object getGroup(int groupPosition) {
            return mEditImageGroupItem.get(groupPosition);
        }

        @Override
        public Object getChild(int groupPosition, int childPosition) {
            return mEditImageGroupItem.get(groupPosition).mChildList.get(childPosition);
        }

        @Override
        public long getGroupId(int groupPosition) {
            return mEditImageGroupItem.get(groupPosition).mId;
        }

        @Override
        public long getChildId(int groupPosition, int childPosition) {
            return childPosition;
        }

        @Override
        public boolean hasStableIds() {
            return false;
        }

        @Override
        public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
            final GroupViewHolder gHolder;

            gHolder = new GroupViewHolder();
            convertView = View.inflate(getContext(), R.layout.fx_photo2pdf_editimage_listview_item, null);
            gHolder.name = (TextView) convertView.findViewById(R.id.photo2pdf_editimage_listview_item_tv);
            gHolder.arror = (ImageView) convertView.findViewById(R.id.photo2pdf_editimage_listview_item_iv);

            final EditImageGroupItem gItem = (EditImageGroupItem) getGroup(groupPosition);
            gHolder.name.setText(gItem.mName);

            if (isExpanded) {
                gHolder.arror.setImageResource(R.mipmap.fx_photo2pdf_editimage_listview_downarror);
            } else {
                gHolder.arror.setImageResource(R.mipmap.fx_photo2pdf_editimage_listview_uparror);
            }
            return convertView;
        }

        @Override
        public View getChildView(final int groupPosition, final int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
            ChildViewHolder cHolder;
            final EditImageGroupItem gItem = (EditImageGroupItem) getGroup(groupPosition);
            convertView = View.inflate(getContext(), R.layout.fx_photo2pdf_editimage_listview_childitem, null);
            cHolder = new ChildViewHolder();
            cHolder.colorStyle = (TextView) convertView.findViewById(R.id.photo2pdf_editimage_listview_childitem_tv);
            cHolder.seekBar = (SeekBar) convertView.findViewById(R.id.photo2pdf_editimage_listview_childitem_sb);
            if (groupPosition == 0) {
                cHolder.seekBar.setVisibility(INVISIBLE);
                cHolder.colorStyle.setVisibility(VISIBLE);
                cHolder.colorStyle.setText(gItem.mChildList.get(childPosition));
                cHolder.colorStyle.setTextSize(15);
                final String colorSpace = gItem.mChildList.get(childPosition);
                ColorspaceItem colorspaceItem = new ColorspaceItem(ImageProcessor.Colorspace.UNDEFINED, "undefined");
                if (colorSpace.equals(ResourceUtils.getString(getContext(), R.string.photo2pdf_editimage_color_none))) {
                    colorspaceItem = new ColorspaceItem(ImageProcessor.Colorspace.UNDEFINED, "undefined");
                } else if (colorSpace.equals(ResourceUtils.getString(getContext(), R.string.photo2pdf_editimage_color_colours))) {
                    colorspaceItem = new ColorspaceItem(ImageProcessor.Colorspace.RGBA_WB, "white_balance");
                } else if (colorSpace.equals(ResourceUtils.getString(getContext(), R.string.photo2pdf_editimage_color_blackandwhite))) {
                    colorspaceItem = new ColorspaceItem(ImageProcessor.Colorspace.BITONAL, "black_white");
                } else if (colorSpace.equals(ResourceUtils.getString(getContext(), R.string.photo2pdf_editimage_color_Gray))) {
                    colorspaceItem = new ColorspaceItem(ImageProcessor.Colorspace.GRAYSCALE, "grayscale");
                }
                final ColorspaceItem mColorspaceItem = colorspaceItem;
                //cHolder.colorStyle.setOnClickListener(new OnClickListener() {
                cHolder.colorStyle.setClickable(false);
                convertView.setOnClickListener(new OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        editImageListener.onItemSelected(colorSpace, mColorspaceItem);
                        setSelectedItem(childPosition);
                        notifyDataSetChanged();
                    }
                });
                if (childPosition == mSeletedItem) {
                    convertView.findViewById(R.id.photo2pdf_editimage_listview_childitem_select).setVisibility(View.VISIBLE);
                } else {
                    convertView.findViewById(R.id.photo2pdf_editimage_listview_childitem_select).setVisibility(View.INVISIBLE);
                }
            } else {
                cHolder.colorStyle.setVisibility(INVISIBLE);
                cHolder.seekBar.setVisibility(VISIBLE);
                if (colorChanged) {
                    if (groupPosition == 1) {
                        cHolder.seekBar.setProgress(brightnessProgress);
                    } else if (groupPosition == 2) {
                        cHolder.seekBar.setProgress(contrastProgress);
                    }
                }
                cHolder.seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
                    @Override
                    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                        colorChanged = true;
                        if (groupPosition == 1) {
                            brightnessProgress = progress;
                        } else if (groupPosition == 2) {
                            contrastProgress = progress;
                        }
                        editImageListener.seekBarChanged(seekBar, progress, fromUser, (groupPosition == 1) ? "brightness" : "contrast");
                    }

                    @Override
                    public void onStartTrackingTouch(SeekBar seekBar) {

                    }

                    @Override
                    public void onStopTrackingTouch(SeekBar seekBar) {

                    }
                });
            }
            return convertView;
        }

        @Override
        public boolean isChildSelectable(int groupPosition, int childPosition) {
            return true;
        }

        int mSeletedItem = 0;

        void setSelectedItem(int pos) {
            mSeletedItem = pos;
        }
    }
}

