/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.views;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.foxit.pdfscan.R;

public class CircleProgressDialog extends AlertDialog {

    private ProgressBar mProgress;
    private TextView mMessageView;

    private CharSequence mMessage;
    private boolean mIndeterminate;

    private Context mActivity;

    public CircleProgressDialog(Activity act) {
        super(act, R.style.fx_photo2pdf_loading_dialog_style);
        mActivity = act;

        setCancelable(false);
        setIndeterminate(false);
    }

    public CircleProgressDialog(Activity act, int theme) {
        super(act, theme);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        LayoutInflater inflater = LayoutInflater.from(mActivity);
        View view = inflater.inflate(R.layout.fx_photo2pdf_progress_dialog, null);
        mProgress =  view.findViewById(R.id.progress);
        mMessageView = view.findViewById(R.id.message);
        mMessageView.setVisibility(View.GONE);
        setView(view);

        if (mMessage != null)
            setMessage(mMessage);
        setIndeterminate(mIndeterminate);
        super.onCreate(savedInstanceState);
    }

    public void setIndeterminate(boolean indeterminate) {
        if (mProgress != null) {
            mProgress.setIndeterminate(indeterminate);
        } else {
            mIndeterminate = indeterminate;
        }
    }

    public boolean isIndeterminate() {
        if (mProgress != null) {
            return mProgress.isIndeterminate();
        }
        return mIndeterminate;
    }

    //@Override
    public void setMessage(CharSequence message) {
        if (mProgress != null) {
            if (mMessageView != null)
                mMessageView.setText(message);
        } else {
            mMessage = message;
        }
    }

}
