/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.viewpdf;

import android.os.Bundle;

import com.foxit.pdfscan.fragment.DocumentViewerPageFragment;
import com.foxit.pdfscan.utils.SessionIntentUtils;
import com.foxitsoftware.mobile.scanning.DocumentSession;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;

public class DocumentViewerPagerAdapter extends FragmentPagerAdapter {
    private DocumentSession session;
    private int pageCount;

    public DocumentViewerPagerAdapter(DocumentSession session,
                                      FragmentManager fm) {
        super(fm);
        this.session = session;
        this.pageCount = session.getPageCount();
    }

    @Override
    public Fragment getItem(int position) {
        DocumentViewerPageFragment documentViewerPageFragment = new DocumentViewerPageFragment();
        Bundle bundle = new Bundle();
        SessionIntentUtils.saveSessionId(bundle, session);
        bundle.putInt("position", position);
        documentViewerPageFragment.setArguments(bundle);
        return documentViewerPageFragment;
    }

    @Override
    public int getCount() {
        return pageCount;
    }
}