/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.fragment;

import android.app.Activity;
import android.app.Service;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Vibrator;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.foxit.pdfscan.ActRequestCode;
import com.foxit.pdfscan.IPDFScanManagerListener;
import com.foxit.pdfscan.PDFScanManager;
import com.foxit.pdfscan.PDFScanSingleton;
import com.foxit.pdfscan.R;
import com.foxit.pdfscan.ScannerSession;
import com.foxit.pdfscan.ToolBarManager;
import com.foxit.pdfscan.UIActionViewBuilder;
import com.foxit.pdfscan.UIContentViewBuilder;
import com.foxit.pdfscan.activity.EditImageActivity;
import com.foxit.pdfscan.activity.EditPDFActivity;
import com.foxit.pdfscan.activity.ScannerCameraActivity;
import com.foxit.pdfscan.editpdf.EditThumbAdapter;
import com.foxit.pdfscan.editpdf.ScanPDFPage;
import com.foxit.pdfscan.editpdf.ThumbItemTouchHelper;
import com.foxit.pdfscan.utils.AppUtils;
import com.foxit.pdfscan.utils.DisplayUtils;
import com.foxit.pdfscan.utils.FileUtils;
import com.foxit.pdfscan.utils.IResultCallback;
import com.foxit.pdfscan.utils.ResourceUtils;
import com.foxit.pdfscan.utils.SessionIntentUtils;
import com.foxit.pdfscan.utils.ThreadManager;
import com.foxit.pdfscan.views.ProgressBarView;
import com.foxit.uiextensions.controls.dialog.MatchDialog;
import com.foxit.uiextensions.controls.dialog.UIDialog;
import com.foxit.uiextensions.controls.dialog.UITextEditDialog;
import com.foxit.uiextensions.controls.dialog.fileselect.UISaveAsDialog;
import com.foxit.uiextensions.controls.dialog.saveas.UIDocSaveAsDialog;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.controls.toolbar.IBaseItem;
import com.foxit.uiextensions.controls.toolbar.impl.BaseItemImpl;
import com.foxit.uiextensions.theme.BaseThemeAdapter;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.AppStorageManager;
import com.foxit.uiextensions.utils.AppUtil;
import com.foxit.uiextensions.utils.UIToast;
import com.foxitsoftware.mobile.scanning.DocumentEditingSession;
import com.foxitsoftware.mobile.scanning.DocumentSession;
import com.foxitsoftware.mobile.scanning.DocumentSessionManager;
import com.foxitsoftware.mobile.scanning.DocumentSessionManagerFactory;
import com.luratech.android.appframework.BitmapWithMetadata;
import com.luratech.android.appframework.Document;
import com.luratech.android.appframework.DocumentManager;
import com.luratech.android.appframework.DocumentManagerListener;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;

import static com.foxit.pdfscan.ToolBarManager.EDIT_ADD;
import static com.foxit.pdfscan.ToolBarManager.FS_PDF_SCAN_TOOLBAR_TYPE_BOTTOM_BAR;
import static com.foxit.uiextensions.controls.dialog.MatchDialog.TEXT_BACK;

public class EditPDFFragment extends Fragment implements
        DocumentManagerListener, DocumentSessionManager.ProgressListener, DocumentEditingSession.EditListener, View.OnClickListener {

    private static final String OPER_MODE = "OPER_MODE";
    private static final int OPER_NORMAL = 0;
    private static final int OPER_EDIT_DOC = 1;
    private static final int OPER_RENAME_DOC = 2;
    private static final int OPER_LOADING_DOC = 3;
    private static final int OPER_SAVEING_IMAGE = 4;
    private static final int OPER_SAVEING_PDF = 5;

    private static final int SAVE_AS_IMAGE = 0;
    private static final int SAVE_AS_PDF = 1;

    private int mSpanCount;
    private int mVerSpacing;
    private static final int GRID_THUMB_ITEM_SPACE = 4;
    private static final int GRID_THUMB_WIDTH = 100;
    private static final int GRID_THUMB_HEIGHT = 145;
    private static final String TAG = EditPDFFragment.class.getSimpleName();
    public static final String RESULT_SCAN_UPDATE = "isUpdate";
    public static final int RESULT_SCAN_EDIT_PDF = 1011;
    private List<ScanPDFPage> mSelectedPageList = new ArrayList<>();
    private List<ScanPDFPage> mPageList = new ArrayList<>();

    private Document mSourceDocument;
    private DocumentEditingSession editingSession;

    private RecyclerView mThumbGridView;
    private EditThumbAdapter mThumbAdapter;
    private GridLayoutManager mGridLayoutManager;

    //normal title
    private RelativeLayout mNormalTopBar;
    private LinearLayout mNormalBottomBar;
    private LinearLayout mCustomBottomBar;
    private ImageView mBackButton;
    private TextView mNormalEditButton;
    private ImageView mAddPageButton;
    private ImageView mSaveButton;
    private TextView mNormalTopBarTitleView;
    private TextView mTvPromptAddDoc;

    //edit title
    private RelativeLayout mEditTopBar;
    private LinearLayout mEditBottomBar;
    private TextView mSelectCountTextView;
    private TextView mEditDoneButton, mSelectAllButton;
    private ImageView mDeleteButton;
    private ImageView mRemakeButton;
    private ProgressBarView mProgressView;
    private RelativeLayout mProgressBackground;

    private UISaveAsDialog mSaveAsDialog;
    private DOC_OPERATION mCurOperation = DOC_OPERATION.NONE;
    private Context mContext;
    private Bundle mSavedInstanceState;

    private int mSaveType = SAVE_AS_IMAGE;
    private int mLastOper = OPER_NORMAL;
    private boolean mBackButtonClicked = false;
    private String mSaveAsPath;
    private String mCurOpStep = "0";
    private String mOrigDocName;
    private String mDocName;
    private String mFileNameOnlyForAddPage;
    private PDFScanManager mPDFScanManager;
    private boolean mSetToolBarData = false;
    private View view;
    private UITextEditDialog mReNameDialog;
    private int mNightMode = -1;

    private boolean mIsUpDate=false;
    private Intent intent;
    enum DOC_OPERATION {
        NONE,
        SAVE_TO_LOCAL,
    }


    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(false);
        mPDFScanManager = PDFScanManager.instance();
        if (ThemeConfig.getInstance(getContext()).getAdapter() == null) {
            ThemeConfig.getInstance(getContext()).setAdapter(new BaseThemeAdapter());
        }
        mPDFScanManager.setOnCloseEditPDFCallBack(new PDFScanManager.CloseEditPDFCallBack() {
            @Override
            public Activity getEditPDFActivity() {
                return getActivity();
            }

            @Override
            public void closeEditPDFActivity() {
                if (getActivity() != null) {
                    getActivity().setResult(EditPDFActivity.RESULT_CODE);
                    getActivity().finish();
                }
            }
        });
    }


    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(OPER_MODE, mLastOper);
    }

    @Override
    public void onDestroy() {
        try {
            View mBottomToolBarView = mPDFScanManager.getToolBarManager(getContext()).
                    getToolBar(FS_PDF_SCAN_TOOLBAR_TYPE_BOTTOM_BAR).getContentView();
            AppUtil.removeViewFromParent(mBottomToolBarView);
        } catch (Exception e) {
            e.printStackTrace();
        }
        DocumentManager.get().removeDocumentManagerListener(this);
        super.onDestroy();
    }


    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        mContext = getActivity().getApplicationContext();
        mNightMode = mContext.getResources().getConfiguration().uiMode & Configuration.UI_MODE_NIGHT_MASK;
        mSavedInstanceState = savedInstanceState;
        // Create new or just restore editing session in case the orientation was changed
        editingSession = (DocumentEditingSession) SessionIntentUtils.tryGetSession(getActivity().getIntent());
        editingSession.setEditListener(this);
        DocumentManager.get().setDocumentManagerListener(this);
        intent = getActivity().getIntent();
        mDocName = mOrigDocName = intent.getStringExtra("FILENAME");
        mFileNameOnlyForAddPage = intent.getStringExtra("mFileNameForEditPhoto");
        ((EditPDFActivity) getActivity()).setFragment(this);

        view = inflater.inflate(R.layout.fx_photo2pdf_fragment_editpdf, container, false);
        computeSpanCount();
        mThumbAdapter = new EditThumbAdapter(mContext, mPageList, mSelectedPageList);
        mThumbGridView = (RecyclerView) view.findViewById(R.id.scanner_edit_grid_view);

        mThumbGridView.setHasFixedSize(true);
        mThumbGridView.setAdapter(mThumbAdapter);
        mGridLayoutManager = new GridLayoutManager(mContext, mSpanCount);
        mThumbGridView.setLayoutManager(mGridLayoutManager);
        ThumbItemTouchHelper.OnDragListener dragListener = new ThumbItemTouchHelper.OnDragListener() {
            @Override
            public void onFinishDrag() {
                ThreadManager.getInstance().getMainThreadHandler().post(new Runnable() {
                    @Override
                    public void run() {
                        mIsUpDate=true;
                        mThumbAdapter.notifyDataSetChanged();
                    }
                });
            }
        };

        final ItemTouchHelper itemTouchHelper = new ItemTouchHelper(new ThumbItemTouchHelper(mThumbAdapter).setOnDragListener(dragListener));
        itemTouchHelper.attachToRecyclerView(mThumbGridView);
        SpacesItemDecoration spacesItemDecoration = new SpacesItemDecoration();
        mThumbGridView.addItemDecoration(spacesItemDecoration);

        mThumbAdapter.setOnItemClickListener(new EditThumbAdapter.ThumbItemTouchListener() {
            @Override
            public void onItemClick(View v, int position, RecyclerView.ViewHolder viewHolder) {

                if (mLastOper == OPER_NORMAL) {
                    if (AppUtils.isFastDoubleClick())
                        return;
                    Intent intent = new Intent(getActivity(), EditImageActivity.class);
                    SessionIntentUtils.saveSessionId(intent, editingSession);
                    intent.putExtra(EditImageFragment.EXTRA_PAGE, position);
                    startActivityForResult(intent, 0);
                } else {
                    mDeleteButton.setEnabled(mSelectedPageList.size() > 0);
                    if (mDeleteButton.isEnabled()) {
                        mDeleteButton.setColorFilter(mContext.getResources().getColor(R.color.i3));
                    }
                    mRemakeButton.setEnabled(mSelectedPageList.size() == 1);
                    if (mRemakeButton.isEnabled()) {
                        mRemakeButton.setColorFilter(mContext.getResources().getColor(R.color.i3));
                    }
                    if (mSelectedPageList.size() > 0 && mSelectedPageList.size() == editingSession.getPageCount()) {
                        mThumbAdapter.setSelectedAll(true);
                        mSelectAllButton.setText(R.string.scan_string_deselect_all);
                        mSelectCountTextView.setText(AppResource.getString(mContext, com.foxit.uiextensions.R.string.fx_selected_count, editingSession.getPageCount()));
                        mSelectCountTextView.setContentDescription(String.format(ResourceUtils.getString(mContext, R.string.atb_filecount_tips), mSelectedPageList.size()));
                    } else if (mSelectedPageList.size() == 0) {
                        mThumbAdapter.setSelectedAll(false);
                        mSelectAllButton.setText(R.string.scan_string_select_all);
                        mSelectCountTextView.setText(AppResource.getString(mContext, com.foxit.uiextensions.R.string.fx_selected_count, 0));
                        mSelectCountTextView.setContentDescription(String.format(ResourceUtils.getString(mContext, R.string.atb_filecount_tips), 0));
                    } else {
                        mThumbAdapter.setSelectedAll(false);
                        mSelectAllButton.setText(R.string.scan_string_select_all);
                        mSelectCountTextView.setText(AppResource.getString(mContext, com.foxit.uiextensions.R.string.fx_selected_count, mSelectedPageList.size()));
                        mSelectCountTextView.setContentDescription(String.format(ResourceUtils.getString(mContext, R.string.atb_filecount_tips), mSelectedPageList.size()));
                    }
                }
            }

            @Override
            public void onItemLongClick(View v, int position, RecyclerView.ViewHolder viewHolder) {
                if (mLastOper == OPER_NORMAL) {
                    startEditMode();
                    mThumbAdapter.setEditMode(true);
                }
                Vibrator vib = (Vibrator) getActivity().getSystemService(Service.VIBRATOR_SERVICE);
                vib.vibrate(70);
            }
        });
        mNormalTopBar = (RelativeLayout) view.findViewById(R.id.scanner_edit_tool_bar_normal);
        mNormalTopBar.setVisibility(View.VISIBLE);
        mNormalBottomBar = view.findViewById(R.id.scanner_normal_bottom_bar);
        mCustomBottomBar = view.findViewById(R.id.scanner_custom_bottom_bar);
        mAddPageButton = (ImageView) view.findViewById(R.id.scan_edit_add_page_button);
        mAddPageButton.setOnClickListener(this);
        mAddPageButton.setColorFilter(mContext.getResources().getColor(R.color.i3));

        mSaveButton = (ImageView) view.findViewById(R.id.scanner_edit_save_button);
        mSaveButton.setColorFilter(mContext.getResources().getColor(R.color.i3));
        mSaveButton.setOnClickListener(this);
        setToolBar();

        mBackButton = (ImageView) view.findViewById(R.id.scan_edit_back_button_normal);
        mBackButton.setOnClickListener(this);
        ThemeUtil.setTintList(mBackButton, ThemeUtil.getItemIconColor(getContext()));

        mNormalTopBarTitleView = (TextView) view.findViewById(R.id.scanner_edit_top_bar_title_normal);
        mNormalTopBarTitleView.setOnClickListener(this);
        if (mDocName != null && !mDocName.equals("")) {
            mNormalTopBarTitleView.setText(mDocName);
        } else {
            if (editingSession.getPageCount() != 0) {
                if (mFileNameOnlyForAddPage != null && !mFileNameOnlyForAddPage.equals("")) {
                    mNormalTopBarTitleView.setText(mFileNameOnlyForAddPage);
                    mDocName = mFileNameOnlyForAddPage;
                } else {
                    String str = FileUtils.generateNewDocName();
                    mNormalTopBarTitleView.setText(str);
                    mDocName = str;
                }
            }
        }
        if (mPDFScanManager.mObtainDocumentNameCallBackListener != null) {
            mPDFScanManager.mObtainDocumentNameCallBackListener.onDocumentName(mDocName);
        }
        mNormalEditButton = view.findViewById(R.id.scanner_edit_edit_button_normal);
        mNormalEditButton.setOnClickListener(this);
        ThemeUtil.setTintList(mNormalEditButton, ThemeUtil.getPrimaryTextColor(mContext));
        if (DisplayUtils.getInstance(mContext).isPad()) {
            LinearLayout.LayoutParams rl = (LinearLayout.LayoutParams) mAddPageButton.getLayoutParams();
            rl.rightMargin = ResourceUtils.getDimensionPixelSize(mContext, R.dimen.scan_bottombar_button_space_pad);
        }

        if (editingSession.getPageCount() == 0) {
            mNormalTopBarTitleView.setEnabled(false);
            mNormalEditButton.setEnabled(false);
            mSaveButton.setEnabled(false);
        }

        //edit mode
        mEditTopBar = (RelativeLayout) view.findViewById(R.id.scanner_edit_top_bar_edit);
        mEditTopBar.setVisibility(View.INVISIBLE);
        mEditBottomBar = view.findViewById(R.id.scanner_edit_bottom_bar);
        mEditBottomBar.setVisibility(View.INVISIBLE);


        mSelectCountTextView = (TextView) view.findViewById(R.id.scanner_edit_select_photo_count);
        mSelectCountTextView.setContentDescription(String.format(ResourceUtils.getString(mContext, R.string.atb_filecount_tips), 0));
        mSelectCountTextView.setText(AppResource.getString(mContext, com.foxit.uiextensions.R.string.fx_selected_count, 0));

        mEditDoneButton = (TextView) view.findViewById(R.id.scanner_edit_edit_done_button);
        mEditDoneButton.setContentDescription(ResourceUtils.getString(mContext, R.string.scan_string_done));
        mEditDoneButton.setOnClickListener(this);
        ThemeUtil.setTintList(mEditDoneButton, ThemeUtil.getPrimaryTextColor(mContext));

        mSelectAllButton = view.findViewById(R.id.scanner_edit_select_all_button);
        mSelectAllButton.setMaxWidth(AppDisplay.getActivityWidth() / 3 - AppDisplay.dp2px(16));
        mSelectAllButton.setOnClickListener(this);
        ThemeUtil.setTintList(mSelectAllButton, ThemeUtil.getPrimaryTextColor(mContext));


        mDeleteButton = (ImageView) view.findViewById(R.id.scanner_edit_delete_button);
        mDeleteButton.setOnClickListener(this);
        mDeleteButton.setEnabled(mSelectedPageList.size() > 0);
        ThemeUtil.setTintList(mDeleteButton, ThemeUtil.getPrimaryIconColor(getContext()));
        mRemakeButton = (ImageView) view.findViewById(R.id.scanner_edit_remake_button);
        mRemakeButton.setOnClickListener(this);
        mRemakeButton.setEnabled(mSelectedPageList.size() == 1);
        ThemeUtil.setTintList(mRemakeButton, ThemeUtil.getPrimaryIconColor(getContext()));
        mRemakePageIndex = -1;
        mProgressView = (ProgressBarView) view.findViewById(R.id.scanner_edit_progress_bar_view);
        mProgressBackground = (RelativeLayout) view.findViewById(R.id.photo2pdf_edit_progress_background);
        mProgressBackground.setVisibility(View.INVISIBLE);
        mTvPromptAddDoc = view.findViewById(R.id.scanner_edit_prompt_add_document);


        mRlContentNormal = view.findViewById(R.id.scanner_edit_content_normal);
        mViewTitleDivider = view.findViewById(R.id.scanner_view_title_divider);
        mRlEditBottomBarNormal = view.findViewById(R.id.scanner_edit_bottom_bar_normal);
        mViewEditTopBarDivider = view.findViewById(R.id.scanner_view_edit_top_bar_divider);
        mViewEditBottomBar = view.findViewById(R.id.scanner_view_edit_bottom_bar);
        return view;
    }

    private RelativeLayout mRlContentNormal;
    private RelativeLayout mRlEditBottomBarNormal;
    private View mViewTitleDivider;
    private View mViewEditTopBarDivider;
    private View mViewEditBottomBar;

    private void setToolBar() {
        mSetToolBarData = mPDFScanManager != null
                && mPDFScanManager.getToolBarManager(getContext()).getToolBar(FS_PDF_SCAN_TOOLBAR_TYPE_BOTTOM_BAR) != null;
        if (mSetToolBarData) {
            BaseBar mBottomToolBar = mPDFScanManager.getToolBarManager(getContext()).
                    getToolBar(FS_PDF_SCAN_TOOLBAR_TYPE_BOTTOM_BAR);
            IBaseItem iBaseItem = mBottomToolBar.getItem(BaseBar.TB_Position.Position_CENTER, EDIT_ADD);
            if (iBaseItem != null) {
                iBaseItem.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        addPage();
                    }
                });
            }
            BaseItemImpl baseDoneItem = (BaseItemImpl) mBottomToolBar.getItem(BaseBar.TB_Position.Position_CENTER, ToolBarManager.EDIT_SAVE);
            if (baseDoneItem != null) {
                baseDoneItem.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (editingSession.getPageCount() != 0) {
                            exportToPdfDoc();
                        }
                    }
                });
            }
            mBottomToolBar.getContentView().setBackgroundColor(getActivity().getResources().getColor(R.color.b2));
            mCustomBottomBar.setVisibility(View.VISIBLE);
            mNormalBottomBar.setVisibility(View.INVISIBLE);
            mCustomBottomBar.addView(mBottomToolBar.getContentView());

        } else {
            mNormalBottomBar.setVisibility(View.VISIBLE);
            mCustomBottomBar.setVisibility(View.INVISIBLE);
        }
    }

    private class SpacesItemDecoration extends RecyclerView.ItemDecoration {
        @Override
        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            if (mSpanCount > 0) {
                int position = parent.getChildAdapterPosition(view);
                int spanIndex = position % mSpanCount;

                outRect.left = mVerSpacing - spanIndex * mVerSpacing / mSpanCount;
                outRect.right = (spanIndex + 1) * mVerSpacing / mSpanCount;

                int horSpace = DisplayUtils.getInstance(mContext).dp2px(GRID_THUMB_ITEM_SPACE);
                outRect.top = horSpace;
                outRect.bottom = horSpace;
            } else {
                outRect.setEmpty();
            }
        }
    }

    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (mNightMode != (newConfig.uiMode & Configuration.UI_MODE_NIGHT_MASK)) {
            mNightMode = newConfig.uiMode & Configuration.UI_MODE_NIGHT_MASK;
            if (mSaveAsDialog != null) {
                mSaveAsDialog.dismiss();
                mSaveAsDialog = null;
            }
            if (mDocSaveAsDialog != null) {
                mDocSaveAsDialog.dismiss();
                mDocSaveAsDialog = null;
            }
            if (mReNameDialog != null) {
                mReNameDialog.dismiss();
                mReNameDialog = null;
            }
            setDarkModeColor();
            return;
        }

        computeSpanCount();
        if (mGridLayoutManager != null) {
            mGridLayoutManager.setSpanCount(mSpanCount);
            mGridLayoutManager.requestLayout();
        }


        if (mSaveAsDialog != null && mSaveAsDialog.isShowing()) {
            mSaveAsDialog.resetWH();
            mSaveAsDialog.showDialog(true, mDocSaveAsDialog.getFileName());
        }
        if (mDocSaveAsDialog != null && mDocSaveAsDialog.isShowing()) {
            mDocSaveAsDialog.resetWH();
            mDocSaveAsDialog.showDialog();
            ThreadManager.getInstance().getMainThreadHandler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    mDocSaveAsDialog.setFileName(mDocSaveAsDialog.getFileName());
                }
            }, 200);
        }

    }

    private void setDarkModeColor() {
        view.setBackgroundColor(getResources().getColor(R.color.b1));
        mRlContentNormal.setBackgroundColor(getResources().getColor(R.color.b1));
        mNormalTopBar.setBackgroundColor(getResources().getColor(R.color.b2));
        mNormalTopBarTitleView.setTextColor(getResources().getColor(R.color.t4));
        ThemeUtil.setTintList(mNormalEditButton, ThemeUtil.getPrimaryTextColor(mContext));
        mViewTitleDivider.setBackgroundColor(getResources().getColor(R.color.p1));
        mEditTopBar.setBackgroundColor(getResources().getColor(R.color.b2));
        mSelectCountTextView.setTextColor(getResources().getColor(R.color.t4));
        mTvPromptAddDoc.setTextColor(getResources().getColor(R.color.t2));
        mRlEditBottomBarNormal.setBackgroundColor(getResources().getColor(R.color.b2));
        mViewEditTopBarDivider.setBackgroundColor(getResources().getColor(R.color.p1));
        mThumbAdapter.notifyDataSetChanged();
        mSelectedPageList.clear();
        mSelectCountTextView.setText(AppResource.getString(mContext, com.foxit.uiextensions.R.string.fx_selected_count, 0));
        mDeleteButton.setEnabled(mSelectedPageList.size() > 0);
        mRemakeButton.setEnabled(mSelectedPageList.size() == 1);
        if (mSetToolBarData) {
            BaseBar mBottomToolBar = mPDFScanManager.getToolBarManager(getContext()).
                    getToolBar(FS_PDF_SCAN_TOOLBAR_TYPE_BOTTOM_BAR);
            mBottomToolBar.getContentView().setBackgroundColor(getActivity().getResources().getColor(R.color.b2));
            IBaseItem iBaseItem = mBottomToolBar.getItem(BaseBar.TB_Position.Position_CENTER, EDIT_ADD);
            if (iBaseItem != null) {
                iBaseItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
            }
            BaseItemImpl baseDoneItem = (BaseItemImpl) mBottomToolBar.getItem(BaseBar.TB_Position.Position_CENTER, ToolBarManager.EDIT_SAVE);
            if (baseDoneItem != null) {
                baseDoneItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
            }
        }

        mAddPageButton.setColorFilter(mContext.getResources().getColor(R.color.i3));
        mSaveButton.setColorFilter(mContext.getResources().getColor(R.color.i3));
        mViewEditBottomBar.setBackgroundColor(mContext.getResources().getColor(R.color.p1));
        ThemeUtil.setTintList(mEditDoneButton, ThemeUtil.getPrimaryTextColor(mContext));
        ThemeUtil.setTintList(mSelectAllButton, ThemeUtil.getPrimaryTextColor(mContext));
        ThemeUtil.setTintList(mBackButton, ThemeUtil.getItemIconColor(mContext));
        ThemeUtil.setTintList(mDeleteButton, ThemeUtil.getPrimaryIconColor(mContext));
        ThemeUtil.setTintList(mRemakeButton, ThemeUtil.getPrimaryIconColor(mContext));
    }


    private void computeSpanCount() {
        int screenWidth = DisplayUtils.getInstance(mContext).getActivityWidth(getActivity());
        int horSpace = DisplayUtils.getInstance(mContext).dp2px(GRID_THUMB_ITEM_SPACE);
        int gridWidth = DisplayUtils.getInstance(mContext).dp2px(GRID_THUMB_WIDTH);
        mSpanCount = Math.max(1, (screenWidth - horSpace) / (gridWidth + horSpace + 2));
        mVerSpacing = (screenWidth - gridWidth * mSpanCount) / (mSpanCount + 1);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (editingSession.getPageCount() == 0) {
            mNormalEditButton.setEnabled(false);
            mSaveButton.setEnabled(false);
            mNormalTopBarTitleView.setEnabled(false);
        }
        mThumbAdapter.clear();
        new CreateThumbnailsOperation().execute();

        if (mDocName != null && !mDocName.equals("")) {
            mNormalTopBarTitleView.setText(mDocName);
        } else {
            if (editingSession.getPageCount() != 0) {
                if (mFileNameOnlyForAddPage != null && !mFileNameOnlyForAddPage.equals("")) {
                    mNormalTopBarTitleView.setText(mFileNameOnlyForAddPage);
                    mDocName = mFileNameOnlyForAddPage;
                } else {
                    String str = FileUtils.generateNewDocName();
                    mNormalTopBarTitleView.setText(str);
                    mDocName = str;
                }
            }
        }
        if (mPDFScanManager.mObtainDocumentNameCallBackListener != null) {
            mPDFScanManager.mObtainDocumentNameCallBackListener.onDocumentName(mDocName);
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == Activity.RESULT_OK) {
            if (requestCode == ActRequestCode.REQ_SCAN_PHOTO_LIBRARY) {
                try {
                    if (getActivity() != null && data != null && data.getData() != null) {
                        Uri selectedImageUri = data.getData();
                        ContentResolver contentResolver = getActivity().getContentResolver();
                        String type = contentResolver.getType(selectedImageUri);

                        String fileExt = mimetypeToFileExt(type);
                        int orientation = getCameraPhotoOrientationUsingTempFile(selectedImageUri, contentResolver, fileExt);
                        Bitmap rotatedBitmap = rotateBitmap(selectedImageUri, contentResolver, orientation);
                        BitmapWithMetadata bm = new BitmapWithMetadata();
                        bm.setBitmap(rotatedBitmap);
                        editingSession.addPage(bm);
                        rotatedBitmap.recycle();
                        rotatedBitmap = null;
                    }
                } catch (Exception e) {
                    Log.d(TAG, e.getMessage());
                }
            } else if (requestCode == AppStorageManager.getOpenTreeRequestCode()) {
                if (getActivity() == null || data == null || data.getData() == null) return;
                Uri uri = data.getData();
                int modeFlags = data.getFlags() & (Intent.FLAG_GRANT_READ_URI_PERMISSION | Intent.FLAG_GRANT_WRITE_URI_PERMISSION);
                getActivity().getContentResolver().takePersistableUriPermission(uri, modeFlags);
            } else if (requestCode == ActRequestCode.REQ_SCAN_CAMERA_REMAKE) {
            }
        }
        if (resultCode == EditImageFragment.RESULT_SCAN_IMAGE) {
            mIsUpDate = data.getBooleanExtra(EditPDFFragment.RESULT_SCAN_UPDATE, false);
        }
    }

    private void changeUIState() {
        if (mLastOper == OPER_NORMAL) {
            mThumbAdapter.notifyDataSetChanged();
            if (editingSession.getPageCount() > 0) {
                mThumbGridView.setVisibility(View.VISIBLE);
                mTvPromptAddDoc.setVisibility(View.GONE);
            } else {
                mNormalEditButton.setEnabled(false);
                mSaveButton.setEnabled(false);
                mNormalTopBarTitleView.setEnabled(false);
                mThumbGridView.setVisibility(View.GONE);
                mTvPromptAddDoc.setVisibility(View.VISIBLE);
            }
        }
    }

    private void saveToImages() {
        mSaveType = SAVE_AS_IMAGE;
        if (editingSession.getPageCount() != 0 && editingSession.hasChanges()) {
            mBackButtonClicked = true;
            Document doc = DocumentManager.get().findDocument(mDocName);
            if (doc == null) {
                mCurOpStep = "1.0";
                saveToImagesFlow(null, null);
            } else {
                if (AppUtils.isEqual(mDocName, mOrigDocName))
                    mOrigDocName = "";
                mDocName = getSaveDocName(mDocName);
                mCurOpStep = "1.0";
                saveToImagesFlow(null, null);
            }
        } else if (editingSession.getPageCount() == 0 && editingSession.hasChanges()) {
            if (mSourceDocument != null)
                DocumentManager.get().deleteDocument(mSourceDocument);
            if (getActivity() != null)
                getActivity().finish();
        } else {
            if (mSourceDocument != null
                    && !AppUtils.isEqual(mSourceDocument.getDocumentName(), mDocName)) {
                mBackButtonClicked = true;
                mCurOpStep = "3.0";
                saveToImagesFlow(null, null);
            } else {
                if (getActivity() != null)
                    getActivity().finish();
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////
    // *** CREATE A NEW DOC OR MODIFY AND RENMAE
    // 1.0 start
    // 1.1 save new doc
    // 1.2 add new doc
    // (1.3) delete doc before rename
    // *
    // *** MODIFY ONLY
    // 2.0 start
    // 2.1 save to temp doc
    // 2.2 add temp doc
    // 2.3 delete original doc
    // 2.4 rename temp to original name
    // *
    // *** RENAME ONLY
    // 3.0 start
    // 3.1 rename
    void saveToImagesFlow(DocumentSession session, Document document) {

        switch (mCurOpStep) {
            case "1.0": {
                mCurOpStep = "1.1";
                mLastOper = OPER_SAVEING_IMAGE;
                DocumentSessionManagerFactory.getInstance().
                        saveSessionAsDocument(editingSession, mDocName, Document.DocumentType.ImageSeries, this);

                break;
            }
            case "1.1": {
                mCurOpStep = "1.2";
                DocumentManager.get().addDocument(document);
                break;
            }
            case "1.2": {
                if (!AppUtils.isEmpty(mOrigDocName) && !AppUtils.isEqual(mOrigDocName, mDocName)) {
                    Document doc = DocumentManager.get().findDocument(mOrigDocName);
                    if (doc != null) {
                        mCurOpStep = "1.3";
                        DocumentManager.get().deleteDocument(doc);
                        break;
                    }
                }
            }
            case "1.3": {
                mProgressView.end();
                closeActAndRefreshDocList();
                break;
            }
            case "2.0": {
                mCurOpStep = "2.1";
                mLastOper = OPER_SAVEING_IMAGE;
                DocumentSessionManagerFactory.getInstance().
                        saveSessionAsDocument(editingSession, ScannerSession.TEMP_SAVE_IMAGE_NAME, Document.DocumentType.ImageSeries, this);
                break;
            }
            case "2.1": {
                mCurOpStep = "2.2";
                DocumentManager.get().addDocument(document);
                break;
            }
            case "2.2": {
                Document origDoc = DocumentManager.get().findDocument(mOrigDocName);
                if (origDoc != null) {
                    mCurOpStep = "2.3";
                    DocumentManager.get().deleteDocument(origDoc);
                    break;
                }
            }
            case "2.3": {
                Document tmpDoc = DocumentManager.get().findDocument(ScannerSession.TEMP_SAVE_IMAGE_NAME);
                if (tmpDoc != null) {
                    mCurOpStep = "2.4";
                    DocumentManager.get().renameDocument(tmpDoc, mOrigDocName);
                    break;
                }
            }
            case "2.4": {
                mProgressView.end();
                closeActAndRefreshDocList();
                break;
            }
            case "3.0": {
                mCurOpStep = "3.1";
                DocumentManager.get().renameDocument(mSourceDocument, mDocName);
                break;
            }
            case "3.1": {
                mProgressView.end();
                closeActAndRefreshDocList();
                break;
            }
            default:
                break;
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////
    // *** CREATE A NEW DOC OR MODIFY AND RENMAE
    // 1.0 start
    // 1.1 save new doc
    // 1.2 add new doc
    // (1.3) delete doc before rename
    // *
    // *** MODIFY ONLY
    // 2.0 start
    // 2.1 save to temp doc
    // 2.2 add temp doc
    // 2.3 delete original doc
    // 2.4 rename temp to original name
    // *
    // *** RENAME ONLY
    // 3.0 start
    // 3.1 rename
    // *
    // *** SAVE TO TEMP PDF FILE
    // a.0 reload document
    // a.1 save to tmp pdf
    // a.2 copy tmp pdf to dest path
    // a.4 delete tmp pdf
    void saveToPdfFlow(DocumentSession session, final Document document) {
        switch (mCurOpStep) {
            case "1.0":
            case "1.1":
            case "2.0":
            case "2.1":
            case "2.2":
            case "2.3":
            case "3.0":
                saveToImagesFlow(session, document);
                break;

            case "1.2": {
                if (!AppUtils.isEmpty(mOrigDocName) && !AppUtils.isEqual(mOrigDocName, mDocName)) {
                    Document doc = DocumentManager.get().findDocument(mOrigDocName);
                    if (doc != null) {
                        mCurOpStep = "1.3";
                        DocumentManager.get().deleteDocument(doc);
                        break;
                    }
                }
            }
            case "1.3":
            case "2.4":
            case "3.1": {
                mCurOpStep = "a.0";
                //mDocSession.destroy();
                Document doc = DocumentManager.get().findDocument(mDocName);
                if (doc != null) {
                    try {
                        mLastOper = OPER_LOADING_DOC;
                        DocumentSessionManagerFactory.getInstance().
                                getViewingSessionForDocument(doc, this);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break;
            }
            case "a.0": {
                mCurOpStep = "a.1";
                mLastOper = OPER_SAVEING_PDF;
                DocumentSessionManagerFactory.getInstance().saveSessionAsDocument(editingSession, ScannerSession.TEMP_SAVE_PDF_NAME, Document.DocumentType.PDF, this);
                UIToast.getInstance(mContext).show(getString(R.string.scan_save_successfully));
                break;
            }
            case "a.1": {
                if (mCurOperation == DOC_OPERATION.SAVE_TO_LOCAL) {
                    mCurOpStep = "a.2";
                    FileUtils.copyFile(document.getFilename(), mSaveAsPath, true, new IResultCallback() {
                        @Override
                        public void onResult(boolean success) {
                            mProgressView.end();
                            mCurOpStep = "a.4";
                            String path = document.getFilename();
                            boolean ret = FileUtils.deleteFile(path);
                            onDocumentMgrEvent(document);
                        }
                    });
                } else {
                    mProgressView.end();
                }
                break;
            }
            case "a.3": {
                mCurOpStep = "a.4";
                DocumentManager.get().deleteDocument(document);
                break;
            }
            case "a.4": {
                mAddPageButton.setClickable(false);
                mSaveButton.setClickable(false);
                mBackButton.setClickable(false);
                mNormalTopBarTitleView.setClickable(false);
                mNormalEditButton.setClickable(false);

                if (getActivity() != null) {
                    getActivity().setResult(EditPDFActivity.RESULT_CODE);
                    getActivity().finish();
                }

                if (mCurOperation == DOC_OPERATION.SAVE_TO_LOCAL) {
                    int errorCode = IPDFScanManagerListener.e_ErrUnknown;
                    if (FileUtils.isFileExist(mSaveAsPath))
                        errorCode = IPDFScanManagerListener.e_ErrSuccess;

                    List<IPDFScanManagerListener> listeners = PDFScanSingleton.getInstance().getManagerListeners();
                    for (IPDFScanManagerListener listener : listeners) {
                        listener.onDocumentAdded(errorCode, mSaveAsPath);
                    }
                }
                break;
            }
            default:
                break;
        }
    }

    Runnable saveDocRun = new Runnable() {
        @Override
        public void run() {
            if (editingSession.getPageCount() != 0 && editingSession.hasChanges()) {
                Document doc = DocumentManager.get().findDocument(mDocName);
                if (doc == null) {
                    mCurOpStep = "1.0";
                    saveToPdfFlow(null, null);
                } else {
                    if (AppUtils.isEqual(mDocName, mOrigDocName)) {
                        mOrigDocName = "";
                    }
                    mDocName = getSaveDocName(mDocName);
                    mCurOpStep = "1.0";
                    saveToPdfFlow(null, null);
                }
            } else {
                if (mSourceDocument != null
                        && !AppUtils.isEqual(mSourceDocument.getDocumentName(), mDocName)) {
                    String origDocName = mSourceDocument.getDocumentName();
                    mCurOpStep = "3.0";
                    saveToPdfFlow(null, null);
                } else {
                    mCurOpStep = "a.0";
                    saveToPdfFlow(null, null);
                }
            }
        }
    };

    private UIDocSaveAsDialog mDocSaveAsDialog;

    private void exportToPdfDoc() {
        mDocSaveAsDialog = new UIDocSaveAsDialog(getActivity());
        setScanManagerView();
        mDocSaveAsDialog.setFileName(mDocName);
        mDocSaveAsDialog.setFormatItems(UIDocSaveAsDialog.FORMAT_ORIGINAL);
        mDocSaveAsDialog.showDialog();
        mDocSaveAsDialog.setListener(new MatchDialog.DialogListener() {
            @Override
            public void onResult(long btType) {

            }

            @Override
            public void onBackClick() {
            }

            @Override
            public void onTitleRightButtonClick() {
                String fileName = mDocSaveAsDialog.getFileName();

//                if (mPDFScanManager != null && mPDFScanManager.getContentView(PDFScanManager.PDF_CONTENT_VIEW) != null) {
//                    mPDFScanManager.getContentView(PDFScanManager.PDF_CONTENT_VIEW)
//                            .getViewBuilder().addCloseViewCallback(new UIContentViewBuilder.ICloseViewCallback() {
//                        @Override
//                        public void onClosed() {
//                            mSaveAsDialog.dismiss();
//                        }
//                    });
//                }
//                if (mPDFScanManager != null && mPDFScanManager.getContentView(PDFScanManager.PDF_CONTENT_VIEW) != null) {
//                    mSaveAsDialog = new UISaveAsDialog(getActivity(), mPDFScanManager.getContentView(PDFScanManager.PDF_CONTENT_VIEW).getViewBuilder().getContentView()
//                            , fileName, "pdf",
//                            new UISaveAsDialog.ISaveAsOnOKClickCallBack() {
//                                public void onOkClick(final String newFilePath) {
//                                    mSaveType = SAVE_AS_PDF;
//                                    mCurOperation = DOC_OPERATION.SAVE_TO_LOCAL;
//
//                                    mSaveAsPath = newFilePath;
//                                    // save document to image first
//                                    saveDocRun.run();
//                                }
//
//                                @Override
//                                public void onCancelClick() {
//                                }
//                            });
//                } else {
                mSaveAsDialog = new UISaveAsDialog(getActivity(), fileName, "pdf",
                        new UISaveAsDialog.ISaveAsOnOKClickCallBack() {
                            public void onOkClick(final String newFilePath) {
                                mSaveType = SAVE_AS_PDF;
                                mCurOperation = DOC_OPERATION.SAVE_TO_LOCAL;

                                mSaveAsPath = newFilePath;
                                // save document to image first
                                saveDocRun.run();
                            }

                            @Override
                            public void onCancelClick() {
                            }
                        });
//                }
                mSaveAsDialog.setHeight(mSaveAsDialog.getDialogHeight());
                mSaveAsDialog.showDialog(true, fileName);
                ThreadManager.getInstance().getMainThreadHandler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        mDocSaveAsDialog.dismiss();
                    }
                }, 300);
            }
        });
    }


    private void setScanManagerView() {
        if (mPDFScanManager != null) {
            if (mPDFScanManager.getContentView(PDFScanManager.PDF_SAVE_AS_CONTENT_VIEW) != null) {
                mDocSaveAsDialog.setView(mPDFScanManager.getContentView(PDFScanManager.PDF_SAVE_AS_CONTENT_VIEW).getViewBuilder().getContentView(), UIDocSaveAsDialog.CONTENT_VIEW);
                mPDFScanManager.getContentView(PDFScanManager.PDF_SAVE_AS_CONTENT_VIEW)
                        .getViewBuilder().addCloseViewCallback(new UIContentViewBuilder.ICloseViewCallback() {
                    @Override
                    public void onClosed() {
                        mDocSaveAsDialog.dismiss();
                    }
                });
            } else {
                mDocSaveAsDialog.setTitle(mContext.getApplicationContext().getString(com.foxit.uiextensions.R.string.fx_string_saveas));
                mDocSaveAsDialog.setTitlePosition(BaseBar.TB_Position.Position_CENTER);
                mDocSaveAsDialog.setTitleTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimensionPixelSize(mContext, com.foxit.uiextensions.R.dimen.ux_text_size_16sp));
                mDocSaveAsDialog.setBackButtonText(mContext.getApplicationContext().getString(com.foxit.uiextensions.R.string.fx_string_cancel));
                mDocSaveAsDialog.setBackButtonStyle(TEXT_BACK);
                mDocSaveAsDialog.setRightButtonText(mContext.getApplicationContext().getString(com.foxit.uiextensions.R.string.fx_string_save));
                mDocSaveAsDialog.setRightButtonVisible(View.VISIBLE);
                mDocSaveAsDialog.setBackgroundColor(AppResource.getColor(mContext, com.foxit.uiextensions.R.color.b2));
                if (mPDFScanManager.getActionView(PDFScanManager.PDF_SAVE_AS_ACTION_VIEW) != null) {
                    mDocSaveAsDialog.setView(mPDFScanManager.getActionView(PDFScanManager.PDF_SAVE_AS_ACTION_VIEW).getViewBuilder().getActionView(), UIDocSaveAsDialog.ADD_ITEM_VIEW);
                    mPDFScanManager.getActionView(PDFScanManager.PDF_SAVE_AS_ACTION_VIEW).getViewBuilder().addCloseViewCallback(new UIActionViewBuilder.ICloseViewCallback() {
                        @Override
                        public void onClosed() {
                            mDocSaveAsDialog.dismiss();
                        }
                    });
                }

            }
        }
    }

    void onDocumentMgrEvent(Document document) {
        if (getActivity() == null)
            return;
        if (mBackButtonClicked) {
            saveToImagesFlow(null, document);
        } else if (mCurOperation == DOC_OPERATION.SAVE_TO_LOCAL) {
            saveToPdfFlow(null, document);
        }
    }

    @Override
    public void onDocumentAdded(Document document) {
        onDocumentMgrEvent(document);
    }

    @Override
    public void onDocumentRemoved(Document document) {
        onDocumentMgrEvent(document);
//        updateScanList();
    }

    @Override
    public void onDocumentUpdated(Document document) {
        onDocumentMgrEvent(document);
    }

    @Override
    public void onThumbnailGenerated(Document document) {
//        updateScanList();
    }

    private void closeActAndRefreshDocList() {
        ThreadManager.getInstance().getMainThreadHandler().postDelayed(new Runnable() {
            @Override
            public void run() {
//                updateScanList();
                if (getActivity() != null) {
                    getActivity().finish();
                }
            }
        }, 500); // WAITING UNTIL ALL RENAME OPERATIONS FINISHED
    }

    private void startEditMode() {
        mLastOper = OPER_EDIT_DOC;

        mThumbAdapter.setEditMode(true);
        if (mSelectedPageList.size() > 0 && mSelectedPageList.size() == editingSession.getPageCount()) {
            mSelectCountTextView.setText(AppResource.getString(mContext, com.foxit.uiextensions.R.string.fx_selected_count, editingSession.getPageCount()));

            mThumbAdapter.setSelectedAll(true);
        } else {
            mSelectCountTextView.setText(AppResource.getString(mContext, com.foxit.uiextensions.R.string.fx_selected_count, 0));
            mThumbAdapter.setSelectedAll(false);
        }

        mThumbAdapter.notifyDataSetChanged();
        mNormalTopBar.setVisibility(View.INVISIBLE);
        mNormalBottomBar.setVisibility(View.INVISIBLE);
        mCustomBottomBar.setVisibility(View.INVISIBLE);
        mEditTopBar.setVisibility(View.VISIBLE);
        mEditBottomBar.setVisibility(View.VISIBLE);
        mDeleteButton.setEnabled(mSelectedPageList.size() > 0);
        mRemakeButton.setEnabled(mSelectedPageList.size() == 1);
    }

    public void stopEditMode() {
        mLastOper = OPER_NORMAL;
        mThumbAdapter.setEditMode(false);
        if (mEditTopBar.getVisibility() == View.INVISIBLE) {
            onBackPressed();
//            changeUIState();
//            saveToImages();
        } else {
            if (editingSession != null && editingSession.getPageCount() == 0) {
                mNormalEditButton.setEnabled(false);
                mSaveButton.setEnabled(false);
                mNormalTopBarTitleView.setEnabled(false);
            }
            mEditTopBar.setVisibility(View.INVISIBLE);
            mEditBottomBar.setVisibility(View.INVISIBLE);
            mNormalTopBar.setVisibility(View.VISIBLE);
            customBottomBarVisible();
            mSelectedPageList.clear();
            mSelectCountTextView.setText(AppResource.getString(mContext, com.foxit.uiextensions.R.string.fx_selected_count, 0));
            mSelectCountTextView.setContentDescription(String.format(ResourceUtils.getString(mContext, R.string.atb_filecount_tips), 0));
            mDeleteButton.setEnabled(mSelectedPageList.size() > 0);
            mRemakeButton.setEnabled(mSelectedPageList.size() == 1);
            changeUIState();
        }
    }

    private void customBottomBarVisible() {
        if (mSetToolBarData) {
            mCustomBottomBar.setVisibility(View.VISIBLE);
            mNormalBottomBar.setVisibility(View.INVISIBLE);
        } else {
            mNormalBottomBar.setVisibility(View.VISIBLE);
            mCustomBottomBar.setVisibility(View.INVISIBLE);
        }
    }
    public void onBackPressed(){
        SessionIntentUtils.saveSessionId(intent, editingSession);
        intent.putExtra(ScannerSession.EXTRA_FILE_NAME, mDocName);
        intent.putExtra(RESULT_SCAN_UPDATE, mIsUpDate);
        intent.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
        if (mRemakePageIndex >= 0) {
            intent.putExtra(RESULT_SCAN_UPDATE, true);
        }
        getActivity().setResult(RESULT_SCAN_EDIT_PDF, intent);
        getActivity().finish();
    }
    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.scan_edit_back_button_normal) {
            onBackPressed();
//            saveToImages();
        } else if (id == R.id.scanner_edit_save_button) {
            exportToPdfDoc();
        } else if (id == R.id.scanner_edit_top_bar_title_normal) {
            renameDocument();
        } else if (id == R.id.scanner_edit_edit_button_normal) {
            startEditMode();
        } else if (id == R.id.scan_edit_add_page_button) {
            addPage();
        } else if (id == R.id.scanner_edit_select_all_button) {
            if (mThumbAdapter.isSelectedAll()) {
                mThumbAdapter.setSelectedAll(false);
                mSelectAllButton.setText(R.string.scan_string_select_all);
                mSelectCountTextView.setText(AppResource.getString(mContext, com.foxit.uiextensions.R.string.fx_selected_count, 0));
                mSelectCountTextView.setContentDescription(String.format(ResourceUtils.getString(mContext, R.string.atb_filecount_tips), 0));
                mSelectedPageList.clear();
            } else {
                mThumbAdapter.setSelectedAll(true);
                mSelectAllButton.setText(R.string.scan_string_deselect_all);
                mSelectCountTextView.setText(AppResource.getString(mContext, com.foxit.uiextensions.R.string.fx_selected_count, editingSession.getPageCount()));
                mSelectCountTextView.setContentDescription(String.format(ResourceUtils.getString(mContext, R.string.atb_filecount_tips), editingSession.getPageCount()));
                mSelectedPageList.clear();

                int size = mThumbAdapter.getScanPageList().size();
                for (int i = 0; i < size; i++) {
                    ScanPDFPage page = mThumbAdapter.getScanPageList().get(i);
                    mSelectedPageList.add(page);
                }
            }
            mDeleteButton.setEnabled(mSelectedPageList.size() > 0);
            mRemakeButton.setEnabled(mSelectedPageList.size() == 1);
            mThumbAdapter.notifyDataSetChanged();
        } else if (id == R.id.scanner_edit_delete_button) {
            final UITextEditDialog dialog = new UITextEditDialog(getActivity());
            dialog.setTitle(com.foxit.uiextensions.R.string.menu_more_confirm);
            dialog.getInputEditText().setVisibility(View.GONE);
            dialog.getPromptTextView().setText(R.string.scan_delete_file_prompt);
            dialog.getOKButton().setEnabled(true);
            dialog.getOKButton().setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    dialog.dismiss();

                    int selectedSize = mSelectedPageList.size();
                    for (int i = selectedSize - 1; i >= 0; i--) {
                        int pageIndex = mThumbAdapter.getScanPageList().indexOf(mSelectedPageList.get(i));
                        editingSession.removePage(pageIndex);
                        mThumbAdapter.removeItem(pageIndex);
                    }

                    mSelectCountTextView.setText(AppResource.getString(mContext, com.foxit.uiextensions.R.string.fx_selected_count, 0));
                    mSelectCountTextView.setContentDescription(String.format(ResourceUtils.getString(mContext, R.string.atb_filecount_tips), 0));
                    mThumbAdapter.setSelectedAll(false);
                    mThumbAdapter.notifyDataSetChanged();
                    mIsUpDate=true;
                    mSelectedPageList.clear();
                    if (mThumbAdapter.getItemCount() > 0) {
                        mLastOper = OPER_EDIT_DOC;
                    } else {
                        mLastOper = OPER_NORMAL;
                        mEditTopBar.setVisibility(View.INVISIBLE);
                        mEditBottomBar.setVisibility(View.INVISIBLE);
                        mNormalTopBar.setVisibility(View.VISIBLE);
                        customBottomBarVisible();
                        mNormalEditButton.setEnabled(false);
                        mSaveButton.setEnabled(false);
                        mNormalTopBarTitleView.setEnabled(false);
                        changeUIState();
                    }
                    mDeleteButton.setEnabled(mSelectedPageList.size() > 0);
                    mRemakeButton.setEnabled(mSelectedPageList.size() == 1);
                }
            });
            dialog.getCancelButton().setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    dialog.dismiss();
                }
            });
            dialog.show();
        } else if (id == R.id.scanner_edit_remake_button) {
            mRemakePageIndex = getRemakePageIndex();
            if (mRemakePageIndex < 0) return;
            Intent intent = new Intent(mContext, ScannerCameraActivity.class);
            SessionIntentUtils.saveSessionId(intent, editingSession);
            intent.putExtra(ScannerSession.EXTRA_REMAKE_INDEX, mRemakePageIndex);
            startActivityForResult(intent, ActRequestCode.REQ_SCAN_CAMERA_REMAKE);
            stopEditMode();
        } else if (id == R.id.scanner_edit_edit_done_button) {
            mThumbAdapter.setEditMode(false);
            mThumbAdapter.notifyDataSetChanged();

            mLastOper = OPER_NORMAL;
            mEditTopBar.setVisibility(View.INVISIBLE);
            mEditBottomBar.setVisibility(View.INVISIBLE);
            mNormalTopBar.setVisibility(View.VISIBLE);
            customBottomBarVisible();
            if (editingSession.getPageCount() == 0) {
                mNormalEditButton.setEnabled(false);
                mSaveButton.setEnabled(false);
                mNormalTopBarTitleView.setEnabled(false);
            }
            mSelectedPageList.clear();
            mSelectCountTextView.setText(AppResource.getString(mContext, com.foxit.uiextensions.R.string.fx_selected_count, 0));
            mDeleteButton.setEnabled(mSelectedPageList.size() > 0);
            mRemakeButton.setEnabled(mSelectedPageList.size() == 1);
            mSelectCountTextView.setContentDescription(String.format(ResourceUtils.getString(mContext, R.string.atb_filecount_tips), 0));
        }
    }

    private int mRemakePageIndex;
    private int getRemakePageIndex() {
        int size = mThumbAdapter.getScanPageList().size();
        for (int i = 0; i < size; i++) {
            if (mSelectedPageList.get(0) == mThumbAdapter.getScanPageList().get(i))
                return i;
        }
        return -1;
    }

    private void addPage() {
        mFileNameOnlyForAddPage = mDocName;
        if (getActivity() != null) {
            SessionIntentUtils.saveSessionId(intent, editingSession);
            intent.putExtra(ScannerSession.EXTRA_FILE_NAME, mDocName);
            intent.putExtra(RESULT_SCAN_UPDATE, mIsUpDate);
            intent.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
            getActivity().setResult(RESULT_SCAN_EDIT_PDF,intent);
            getActivity().finish();
        }
    }

    private String mimetypeToFileExt(String mimeType) {
        if (mimeType == null)
            return "";
        int lastIndexOf = mimeType.lastIndexOf("/");
        if (lastIndexOf != -1) {
            return "." + mimeType.substring(lastIndexOf + 1);
        } else {
            return mimeType;
        }
    }

    private int getCameraPhotoOrientationUsingTempFile(Uri selectedImageUri, ContentResolver contentResolver, String ext)
            throws IOException {
        File outFile = FileUtils.storeFileToInternalStorage(getActivity(),
                contentResolver.openInputStream(selectedImageUri), "tempfile." + ext);
        int orientation = getCameraPhotoOrientation(contentResolver, selectedImageUri, outFile.getAbsolutePath());
        return orientation;
    }

    private int getCameraPhotoOrientation(ContentResolver contentResolver,
                                          Uri imageUri, String imagePath) {
        int rotate = 0;
        try {
            contentResolver.notifyChange(imageUri, null);
            File imageFile = new File(imagePath);
            ExifInterface exif = new ExifInterface(imageFile.getAbsolutePath());
            int orientation = exif.getAttributeInt(
                    ExifInterface.TAG_ORIENTATION,
                    ExifInterface.ORIENTATION_NORMAL);

            switch (orientation) {
                case ExifInterface.ORIENTATION_ROTATE_270:
                    rotate = 270;
                    break;
                case ExifInterface.ORIENTATION_ROTATE_180:
                    rotate = 180;
                    break;
                case ExifInterface.ORIENTATION_ROTATE_90:
                    rotate = 90;
                    break;
                default:
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return rotate;
    }

    private Bitmap rotateBitmap(Uri selectedImageUri, ContentResolver contentResolver, int orientation)
            throws IOException {
        Matrix matrix = new Matrix();
        if (orientation != 0f) {
            matrix.preRotate(orientation);
        }
        InputStream stream = contentResolver.openInputStream(selectedImageUri);
        Bitmap bitmap = BitmapFactory.decodeStream(stream);
        stream.close();

        Bitmap rotatedBitmap = Bitmap.createBitmap(bitmap, 0, 0,
                bitmap.getWidth(), bitmap.getHeight(), matrix, true);
        return rotatedBitmap;
    }

    private void renameDocument() {
        mLastOper = OPER_RENAME_DOC;
        mReNameDialog = new UITextEditDialog(getActivity());
        mReNameDialog.getPromptTextView().setVisibility(View.GONE);
        mReNameDialog.setTitle(ResourceUtils.getString(mContext, R.string.hm_photo2pdf_rename));

        final EditText editText = mReNameDialog.getInputEditText();
        mReNameDialog.setPattern("[/\\:*?<>|\"\n\t]");
        editText.setText(mDocName);
        editText.selectAll();
        mReNameDialog.getOKButton().setEnabled(false);
        AppUtils.showSoftInput(editText);
        editText.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                boolean enabled = true;
                if (TextUtils.isEmpty(s.toString().trim()) || s.toString().equals(mDocName))
                    enabled = false;
                mReNameDialog.getOKButton().setEnabled(enabled);
            }
        });

        mReNameDialog.getOKButton().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String name = editText.getText().toString().trim();
                if (!AppUtils.isEmpty(name) && !AppUtils.isEqual(name, mDocName)) {
                    Document doc = DocumentManager.get().findDocument(name);
                    if (!AppUtils.isEqual(name, mOrigDocName) && doc != null) {
                        final UITextEditDialog rmDialog = new UITextEditDialog(getActivity(), UIDialog.NO_INPUT);
                        rmDialog.setTitle(ResourceUtils.getString(mContext, R.string.scan_string_warning));
                        rmDialog.getPromptTextView().setText(ResourceUtils.getString(mContext, R.string.scaner_prompt_file_exist));
                        rmDialog.getCancelButton().setVisibility(View.GONE);
                        rmDialog.show();

                        rmDialog.getOKButton().setOnClickListener(new View.OnClickListener() {
                            @Override
                            public void onClick(View v) {
                                rmDialog.dismiss();
                            }
                        });
                        return;
                    }

                    mNormalTopBarTitleView.setText(name);
                    mDocName = name;
                    if (mPDFScanManager.mObtainDocumentNameCallBackListener != null) {
                        mPDFScanManager.mObtainDocumentNameCallBackListener.onDocumentName(mDocName);
                    }
                    //DocumentManager.get().renameDocument(mDocSession.getEditedDocument(), name);
                }
                mLastOper = OPER_NORMAL;
                AppUtils.dismissInputSoft(editText);
                mReNameDialog.dismiss();
            }
        });

        mReNameDialog.getCancelButton().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mLastOper = OPER_NORMAL;
                AppUtils.dismissInputSoft(editText);
                mReNameDialog.dismiss();
            }
        });

        mReNameDialog.setOnCancelListener(new DialogInterface.OnCancelListener() {
            @Override
            public void onCancel(DialogInterface dialog) {
                mLastOper = OPER_NORMAL;
                AppUtils.dismissInputSoft(editText);
                dialog.dismiss();
            }
        });
        mReNameDialog.show();
    }

    private class CreateThumbnailsOperation extends AsyncTask<Document, ScanPDFPage, Boolean> {
        @Override
        protected void onPreExecute() {
        }

        @Override
        protected Boolean doInBackground(Document... document) {
            try {
                for (int i = 0; i < editingSession.getPageCount(); i++) {
                    Bitmap bitmap = editingSession.getThumbnailForPage(i);
                    ScanPDFPage page = new ScanPDFPage();
                    page.setSession(editingSession);
                    page.setBitmap(bitmap);
                    page.setTitle(getActivity().getString(R.string.editpdf_onclick_text, i + 1));
                    publishProgress(page);
                }
                return true;
            } catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }

        @Override
        protected void onProgressUpdate(ScanPDFPage... doc) {
            mThumbAdapter.addItem(doc[0]);
        }

        @Override
        protected void onPostExecute(Boolean result) {
            if (result != null && result) {
                if (mSavedInstanceState != null) {
                    int state = mSavedInstanceState.getInt(OPER_MODE, OPER_NORMAL);
                    if (state == OPER_EDIT_DOC)
                        startEditMode();
                    else if (state == OPER_RENAME_DOC)
                        renameDocument();
                }
            }
            mThumbAdapter.notifyDataSetChanged();
            changeUIState();
        }

    }

    @Override
    public void onStartedAction(DocumentSession session, String documentName) {
        if (!mProgressView.isShowing())
            mProgressView.start(getActivity(), true);
    }

    @Override
    public void onUpdateProgress(DocumentSession session, int done, int total) {
        if (getActivity() != null) {
            if (mSaveType == SAVE_AS_PDF) {
                if (mLastOper == OPER_SAVEING_PDF)
                    mProgressView.progress(mContext.getApplicationContext().getString(R.string.editpdf_saving, done, total));
                else
                    mProgressView.progress(ResourceUtils.getString(mContext, R.string.scan_string_saving));
            } else {
                mProgressView.progress(mContext.getApplicationContext().getString(R.string.editpdf_saving, done, total));
            }
        }
    }

    @Override
    public void onFinishedAction(DocumentSession session, final Document document) {
        if (getActivity() != null) {
            if (mLastOper == OPER_LOADING_DOC) {
                DocumentSessionManagerFactory.getInstance().cancelLoading(document);
                editingSession = DocumentSessionManagerFactory.getInstance().getEditingSession(session);
                mLastOper = OPER_NORMAL;
            }
            if (mBackButtonClicked) {
                saveToImagesFlow(session, document);
            } else if (mCurOperation == DOC_OPERATION.SAVE_TO_LOCAL) {
                saveToPdfFlow(session, document);
            }
        }
    }

    @Override
    public void onCanceledAction(DocumentSession session) {
        if (getActivity() != null) {
            mProgressView.end();
            if (getActivity() != null)
                getActivity().finish();
        }
    }

    @Override
    public void onPageAdded(DocumentEditingSession session, int newPageIndex) {
        changeUIState();
    }

    @Override
    public void onDidRemovePage(DocumentEditingSession session, int removedPageIndex) {
        changeUIState();
    }

    @Override
    public void onDidMovePage(DocumentEditingSession session, int oldIndex, int newIndex) {
        changeUIState();
    }

    @Override
    public void onDidReplacePage(DocumentEditingSession session, int pageIndex) {
    }

//    private void updateScanList() {
//        final Intent intent = new Intent(ScannerSession.INTENT_ACTION_UPDATE_LIST);
//        if (getActivity() != null)
//            getActivity().sendBroadcast(intent);
//    }

    private String getSaveDocName(String name) {
        String newPath = name;
        while (true) {
            Document doc = DocumentManager.get().findDocument(newPath);
            if (doc != null) {
                int begin = 0;
                int end = newPath.length() - 1;
                if (newPath.charAt(end) == ')') {
                    for (int i = end - 1; i >= 0; i--) {
                        char c = newPath.charAt(i);
                        if (c == '(') {
                            begin = i;
                            break;
                        }
                        if (c < '0' || c > '9')
                            break;
                    }
                }
                if (begin > 0 && end - begin < 32) {
                    String num = newPath.substring(begin + 1, end);
                    int index = Integer.parseInt(num, 10) + 1;
                    newPath = newPath.substring(0, begin) + "(" + index + ")";
                    continue;
                }
                newPath = newPath + "(" + 1 + ")";
                continue;
            }
            break;
        }
        return newPath;
    }

}
