/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.fragment;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.fragment.app.Fragment;

import com.foxit.pdfscan.R;
import com.foxit.pdfscan.utils.DisplayUtils;
import com.foxit.pdfscan.utils.SessionIntentUtils;
import com.foxitsoftware.mobile.scanning.DocumentEditingSession;
import com.luratech.android.appframework.BitmapWithMetadata;

public class DocumentViewerPageFragment extends Fragment {

    private static final String TAG = DocumentViewerPageFragment.class
            .getSimpleName();
    private DocumentEditingSession editingSession;
    private int position;
    private ImageView imageView;
    private BitmapWithMetadata bm;

    public DocumentViewerPageFragment() {
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        // Initialize in particular editingSession before onSaveInstanceState() can be called.
        restoreInstanceState(getArguments());
        restoreInstanceState(savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Bundle bundle = getArguments();
        editingSession = (DocumentEditingSession) SessionIntentUtils.tryGetSession(bundle);
        position = bundle.getInt("position");
        // Maybe we get re-called after onDestroyView(). Getting back the session should be cheap.
        if (editingSession == null) {
            restoreInstanceState(getArguments());
            restoreInstanceState(savedInstanceState);
        }

        ViewGroup rootView = (ViewGroup) inflater.inflate(
                R.layout.fx_photo2pdf_editimage_viewer_page, container, false);
        rootView.setTag(position);
        imageView = (ImageView) rootView.findViewById(R.id.PDFPage);
        try {
            bm = editingSession.getImageForPage(position);
            Bitmap bitmap = bm.getBitmap();
            float scale = getImageScale(bitmap);
            Bitmap newBitmap = Bitmap.createScaledBitmap(bitmap, (int) (bitmap.getWidth() * scale), (int) (bitmap.getHeight() * scale), true);
//            if (!bitmap.isRecycled() && !newBitmap.equals(bitmap)) {
//                bitmap.recycle();
//            }
            imageView.setImageBitmap(newBitmap);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return rootView;
    }

    private float getImageScale(Bitmap bitmap) {
        int screenWidth = DisplayUtils.getInstance(getContext()).getScreenWidth();
        int screenHeight = DisplayUtils.getInstance(getContext()).getScreenHeight();

        float widthScale = (float) screenWidth / bitmap.getWidth();
        float heightScale = (float) screenHeight / bitmap.getHeight();
        return Math.min(widthScale, heightScale);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("position", position);
        SessionIntentUtils.saveSessionId(outState, editingSession);
    }

    /**
     * Restore model on orientation change
     *
     * @param savedInstanceState saved state
     */
    private void restoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            editingSession = (DocumentEditingSession) SessionIntentUtils.tryGetSession(savedInstanceState);
            position = savedInstanceState.getInt("position", 0);
        }
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        bm = null;
        imageView = null;
        editingSession = null;
    }

    // Clean up everything from onCreate().
    @Override
    public void onDestroy() {
        super.onDestroy();
        editingSession = null;
    }

}