/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.format;

import android.content.res.Resources;

import com.foxit.pdfscan.R;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PageFormats implements Serializable {
    private static final long serialVersionUID = -2303987212305380141L;

    public static PageFormat ORIGINAL_PAGE_FORMAT;

    private List<PageFormat> pageFormats;

    private PageFormat currentPageFormat;

    public PageFormats(Resources resources) {
        setSupportedPageFormats(resources);
        ORIGINAL_PAGE_FORMAT = new PageFormat(
                resources.getString(R.string.scan_string_original), 0, 0);
        setCurrentPageFormat(ORIGINAL_PAGE_FORMAT);
    }

    private List<PageFormat> setSupportedPageFormats(Resources resources) {
        if (pageFormats == null) {
            pageFormats = new ArrayList<PageFormat>();

            PageFormat a3 = new PageFormat(
                    resources.getString(R.string.scan_format_A3),
                    resources.getInteger(R.integer.scanner_format_A3_width),
                    resources.getInteger(R.integer.scanner_format_A3_height));
            pageFormats.add(a3);
            PageFormat a4 = new PageFormat(
                    resources.getString(R.string.scan_format_A4),
                    resources.getInteger(R.integer.scanner_format_A4_width),
                    resources.getInteger(R.integer.scanner_format_A4_height));
            pageFormats.add(a4);
            PageFormat a5 = new PageFormat(
                    resources.getString(R.string.scan_format_A5),
                    resources.getInteger(R.integer.scanner_format_A5_width),
                    resources.getInteger(R.integer.scanner_format_A5_height));
            pageFormats.add(a5);
            PageFormat envelope = new PageFormat(
                    resources.getString(R.string.scan_format_envelope),
                    resources
                            .getInteger(R.integer.scanner_format_envelope_width),
                    resources
                            .getInteger(R.integer.scanner_format_envelope_height));
            pageFormats.add(envelope);
            PageFormat businessCard = new PageFormat(
                    resources.getString(R.string.scan_format_business_card),
                    resources
                            .getInteger(R.integer.scanner_format_businessCard_width),
                    resources
                            .getInteger(R.integer.scanner_format_businessCard_height));
            pageFormats.add(businessCard);
            PageFormat executive = new PageFormat(
                    resources.getString(R.string.scan_format_executive),
                    resources
                            .getInteger(R.integer.scanner_format_executive_width),
                    resources
                            .getInteger(R.integer.scanner_format_executive_height));
            pageFormats.add(executive);
            PageFormat legal = new PageFormat(
                    resources.getString(R.string.scan_format_legal),
                    resources.getInteger(R.integer.scanner_format_legal_width),
                    resources.getInteger(R.integer.scanner_format_legal_height));
            pageFormats.add(legal);
            PageFormat letter = new PageFormat(
                    resources.getString(R.string.scan_format_letter),
                    resources.getInteger(R.integer.scanner_format_letter_width),
                    resources
                            .getInteger(R.integer.scanner_format_letter_height));
            pageFormats.add(letter);
            PageFormat ledger = new PageFormat(
                    resources.getString(R.string.scan_format_ledger),
                    resources.getInteger(R.integer.scanner_format_ledger_width),
                    resources
                            .getInteger(R.integer.scanner_format_ledger_height));
            pageFormats.add(ledger);

        }
        return pageFormats;
    }

    public PageFormat getCurrentPageFormat() {
        return currentPageFormat;
    }

    public void setCurrentPageFormat(PageFormat currentPageFormat) {
        this.currentPageFormat = currentPageFormat;
    }

    public List<PageFormat> getPageFormats() {
        return pageFormats;
    }

    public int indexOf(String formatName) {
        for (int index = 0; index < pageFormats.size(); index++) {
            PageFormat pageFormat = pageFormats.get(index);
            if (pageFormat.getName().equals(formatName)) {
                return index;
            }
        }
        return -1;
    }

    public PageFormat get(int index) {
        for (int i = 0; i < pageFormats.size(); i++) {
            if (index == i) {
                return pageFormats.get(i);
            }
        }
        return null;
    }
}
