/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.editimage;

import android.view.View;
import android.widget.SeekBar;
import android.widget.Spinner;

public interface EditImageListener {

    /**
     * @param isEditingMode are we currently editing an image property (e.g. brightness)?
     */
    void editingModeChanged(boolean isEditingMode);

    /**
     * Slider was used to edit an image property (brightness, contrast)
     *
     * @param seekBar  the slider
     * @param progress the current value of the slider
     * @param fromUser the user changed the slider?
     */
    void seekBarChanged(SeekBar seekBar, int progress, boolean fromUser, String useFor);

    /**
     * A spinner selection has been made (colorspace)
     *
     * @param colorSpinner the spinner of the item, that has been chosen
     * @param item         the selected item
     */
    void onItemSelected(Spinner colorSpinner, Object item);


    void onItemSelected(String colorSpace, ColorspaceItem colorspaceItem);

    /**
     * An action has been clicked (rotate, crop view)
     *
     * @param button
     */
    void onButtonClicked(View button);

}
