/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan.editimage;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListView;

import com.foxit.pdfscan.R;

import java.util.ArrayList;

public class ColorspaceAdapter extends ArrayAdapter<ColorspaceItem> {

    /**
     * Spinner must have any selected item initially, therefore we need a dummy.
     *
     * @author k.haendel
     */
    public class NothingSelectedView extends View {
        public NothingSelectedView() {
            super(activity);
            setLayoutParams(new ListView.LayoutParams(0, 0));
        }
    }

    private Activity activity;
    private ArrayList<ColorspaceItem> colorspaces;

    public ColorspaceAdapter(Activity activity, int resource,
                             ArrayList<ColorspaceItem> colorspaces) {
        super(activity, resource, colorspaces);
        this.activity = activity;
        this.colorspaces = colorspaces;
    }

    @Override
    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        if (position == 0) {
            return new NothingSelectedView();
        }
        View row = convertView;
        if (row instanceof NothingSelectedView) {
            LayoutInflater inflater = activity.getLayoutInflater();
            row = inflater.inflate(R.layout.fx_photo2pdf_colorspaces_spinner_row, parent, false);
        }
        ColorspaceItem current = colorspaces.get(position);

        ImageView colorspace = (ImageView) row.findViewById(R.id.colorspace);
        colorspace.setBackgroundResource(current.getResourceId());
        return row;
    }

}