/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdfscan;

import com.foxit.pdfscan.format.PageFormat;

public class ScannerSession {
    public static final String TEMP_SAVE_IMAGE_NAME = "21A58E89_B44D_4A94_5441_B3E1269A5021";
    public static final String TEMP_SAVE_PDF_NAME = "C8E9AF0A_2056_0076_3F2A_E54D05334DAC";
    public static final String TEMP_RENAME_NAME = "D8E9AF0A_2056_0076_3F2A_E54D05334DAd";

    public static final String INTENT_ACTION_UPDATE_LIST = "action_update_scan_list";

    public static final String EXTRA_FORMAT = "EXTRA_FORMAT";
    public static final String EXTRA_FILE_NAME = "EXTRA_FILE_NAME";
    public static final String EXTRA_FILE_PATH = "EXTRA_FILE_PATH";
    public static final String EXTRA_REMAKE_INDEX = "EXTRA_REMAKE_INDEX";
    public static final String EXTRA_SINGLE_CHOOSE= "EXTRA_SINGLE_CHOOSE";

    private static boolean isContinuousSnap = true;
    private static boolean isAutoDetect = false;
    private static PageFormat currentPageFormat;

    public static boolean isContinuousSnap() {
        return isContinuousSnap;
    }

    public static void setContinuousSnap(boolean isContinuousSnap) {
        ScannerSession.isContinuousSnap = isContinuousSnap;
    }

    public static boolean isAutoDetect() {
        return isAutoDetect;
    }

    public static void setAutoDetect(boolean isAutoDetect) {
        ScannerSession.isAutoDetect = isAutoDetect;
    }

    public static PageFormat getCurrentPageFormat() {
        return currentPageFormat;
    }

    public static void setCurrentPageFormat(PageFormat currentPageFormat) {
        ScannerSession.currentPageFormat = currentPageFormat;
    }

    public static void clear() {
        isContinuousSnap = true;
        isAutoDetect = false;
        currentPageFormat = null;
    }

}
