
export namespace FSConvertToTSUtil{

  export function removeKey<T>(obj: T, key: string): T {
    delete obj[key];
    return obj;
  }

  export function convertMapToObject<T>(metricArguments: Map<string,T>): Record<string,T> {
    let newObject: Record<string, T> = {}
    for (let [key, value] of metricArguments) {
      newObject[key] = value;
    }
    return newObject;
  }

  export function getValueForKey(obj:Object, key: string): object{
    if (obj instanceof Object && key in obj){
      return obj[key];
    }
    return undefined;
  }

  export function deepCopyInstance<T>(instance: T): T {

    if (instance === null || typeof instance !== 'object' ) {
      return instance;
    }

    if (instance.constructor.name === 'PixelMap'){
      return instance;
    }
    // 处理特殊对象类型
    if (instance instanceof Date) {
      return new Date(instance.getTime()) as any;
    }

    if (instance instanceof RegExp) {
      return new RegExp(instance.source, instance.flags) as any;
    }

    // 获取实例的原型
    const proto = Object.getPrototypeOf(instance);
    // 创建新对象，保持原型链
    const copy = Object.create(proto);

    // 复制所有属性
    for (const key in instance) {
      if (instance.hasOwnProperty(key)) {
        const value = instance[key];
        // 递归复制
        copy[key] = deepCopyInstance(value);
      }
    }

    return copy;
  }

}